/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.TodoPattern;
import org.jetbrains.annotations.NotNull;

public class TodoItemImpl
implements TodoItem {
    private final PsiFile myFile;
    private final int myStartOffset;
    private final int myEndOffset;
    private final TodoPattern myPattern;

    public TodoItemImpl(@NotNull PsiFile file2, int startOffset, int endOffset, @NotNull TodoPattern pattern) {
        this.myFile = file2;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myPattern = pattern;
    }

    @NotNull
    public PsiFile getFile() {
        return this.myFile;
    }

    @NotNull
    public TextRange getTextRange() {
        return new TextRange(this.myStartOffset, this.myEndOffset);
    }

    @NotNull
    public TodoPattern getPattern() {
        return this.myPattern;
    }

    public int hashCode() {
        return this.myFile.hashCode() + this.myStartOffset + this.myEndOffset + this.myPattern.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TodoItemImpl)) {
            return false;
        }
        TodoItemImpl todoItem = (TodoItemImpl)obj;
        return this.myFile.equals(todoItem.myFile) && this.myStartOffset == todoItem.myStartOffset && this.myEndOffset == todoItem.myEndOffset && this.myPattern.equals((Object)todoItem.myPattern);
    }
}

