/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class VariableInIncompleteCodeSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public VariableInIncompleteCodeSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters p, @NotNull Processor<PsiReference> consumer2) {
        Object[] elements;
        PsiElement refElement = p.getElementToSearch();
        if (!refElement.isValid() || !(refElement instanceof PsiVariable)) {
            return;
        }
        String name = ((PsiVariable)refElement).getName();
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return;
        }
        SearchScope scope = p.getEffectiveSearchScope();
        if (!(scope instanceof LocalSearchScope)) {
            PsiFile file2 = refElement.getContainingFile();
            if (file2 == null || file2 instanceof PsiCompiledElement) {
                return;
            }
            scope = new LocalSearchScope(new PsiElement[]{file2}, null, !PsiSearchHelperImpl.shouldProcessInjectedPsi(p.getScopeDeterminedByUser()));
        } else {
            elements = ((LocalSearchScope)scope).getScope();
            PsiElement[] sourceElements = (PsiElement[])ContainerUtil.findAllAsArray((Object[])elements, e -> !(e instanceof PsiCompiledElement));
            if (sourceElements.length != elements.length) {
                if (sourceElements.length == 0) {
                    return;
                }
                scope = new LocalSearchScope(sourceElements);
            }
        }
        elements = ((LocalSearchScope)scope).getScope();
        if (elements.length == 0) {
            return;
        }
        PsiSearchHelper.SERVICE.getInstance((Project)p.getProject()).processElementsWithWord((element, offsetInElement) -> {
            for (PsiElement child = element.findElementAt(offsetInElement); child != null && child.textMatches((CharSequence)name); child = child.getParent()) {
                PsiJavaCodeReferenceElement ref;
                if (!(child instanceof PsiJavaCodeReferenceElement) || (ref = (PsiJavaCodeReferenceElement)child).isQualified() || ref.getParent() instanceof PsiMethodCallExpression || ref.resolve() != null || ref.advancedResolve(true).getElement() != refElement) continue;
                consumer2.process((Object)ref);
            }
            return true;
        }, scope, name, (short)255, true);
    }
}

