/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.Identikit;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InjectedSelfElementInfo
extends SmartPointerElementInfo {
    private final SmartPsiFileRange myInjectedFileRangeInHostFile;
    @Nullable
    private final AffixOffsets myAffixOffsets;
    private final Identikit myType;
    @NotNull
    private final SmartPsiElementPointer<PsiLanguageInjectionHost> myHostContext;

    InjectedSelfElementInfo(@NotNull Project project2, @NotNull PsiElement injectedElement, @NotNull TextRange injectedRange, @NotNull PsiFile containingFile, @NotNull SmartPsiElementPointer<PsiLanguageInjectionHost> hostContext) {
        this.myHostContext = hostContext;
        assert (containingFile.getViewProvider() instanceof FreeThreadedFileViewProvider) : "element parameter must be an injected element: " + injectedElement + "; " + containingFile;
        assert (containingFile.getTextRange().contains(injectedRange)) : "Injected range outside the file: " + injectedRange + "; file: " + containingFile.getTextRange();
        TextRange hostRange = InjectedLanguageManager.getInstance((Project)project2).injectedToHost(injectedElement, injectedRange);
        PsiFile hostFile = hostContext.getContainingFile();
        assert (!(hostFile.getViewProvider() instanceof FreeThreadedFileViewProvider)) : "hostContext parameter must not be and injected element: " + hostContext;
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project2);
        this.myInjectedFileRangeInHostFile = smartPointerManager.createSmartPsiFileRangePointer(hostFile, hostRange);
        this.myType = Identikit.fromPsi(injectedElement, LanguageUtil.getRootLanguage((PsiElement)containingFile));
        int startAffixIndex = -1;
        int startAffixOffset = -1;
        int endAffixIndex = -1;
        int endAffixOffset = -1;
        List fragments = InjectedLanguageManager.getInstance((Project)project2).getNonEditableFragments((DocumentWindow)containingFile.getViewProvider().getDocument());
        for (int i2 = 0; i2 < fragments.size(); ++i2) {
            TextRange range = (TextRange)fragments.get(i2);
            if (range.containsOffset(injectedRange.getStartOffset())) {
                startAffixIndex = i2;
                startAffixOffset = injectedRange.getStartOffset() - range.getStartOffset();
            }
            if (!range.containsOffset(injectedRange.getEndOffset())) continue;
            endAffixIndex = i2;
            endAffixOffset = injectedRange.getEndOffset() - range.getStartOffset();
        }
        this.myAffixOffsets = startAffixIndex >= 0 || endAffixIndex >= 0 ? new AffixOffsets(startAffixIndex, startAffixOffset, endAffixIndex, endAffixOffset) : null;
    }

    @Override
    public VirtualFile getVirtualFile() {
        PsiElement element = this.restoreElement();
        if (element == null) {
            return null;
        }
        return element.getContainingFile().getVirtualFile();
    }

    @Override
    public Segment getRange() {
        return this.getInjectedRange(false);
    }

    @Override
    @Nullable
    public Segment getPsiRange() {
        return this.getInjectedRange(true);
    }

    @Override
    public PsiElement restoreElement() {
        PsiFile hostFile = this.myHostContext.getContainingFile();
        if (hostFile == null || !hostFile.isValid()) {
            return null;
        }
        PsiElement hostContext = this.myHostContext.getElement();
        if (hostContext == null) {
            return null;
        }
        Segment segment = this.myInjectedFileRangeInHostFile.getPsiRange();
        if (segment == null) {
            return null;
        }
        PsiFile injectedPsi = this.getInjectedFileIn(hostContext, hostFile, TextRange.create((Segment)segment));
        ProperTextRange rangeInInjected = InjectedSelfElementInfo.hostToInjected(true, segment, injectedPsi, this.myAffixOffsets);
        if (rangeInInjected == null) {
            return null;
        }
        return this.myType.findPsiElement(injectedPsi, rangeInInjected.getStartOffset(), rangeInInjected.getEndOffset());
    }

    private PsiFile getInjectedFileIn(@NotNull PsiElement hostContext, @NotNull PsiFile hostFile, final @NotNull TextRange rangeInHostFile) {
        PsiFile[] result2;
        block3: {
            PsiLanguageInjectionHost.InjectedPsiVisitor visitor;
            block2: {
                final PsiDocumentManagerBase docManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.getProject());
                result2 = new PsiFile[]{null};
                visitor = new PsiLanguageInjectionHost.InjectedPsiVisitor(){

                    public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                        DocumentWindow window;
                        TextRange hostRange;
                        Document document = docManager.getDocument(injectedPsi);
                        if (document instanceof DocumentWindow && (hostRange = (window = (DocumentWindow)docManager.getLastCommittedDocument(document)).injectedToHost(new TextRange(0, injectedPsi.getTextLength()))).contains(rangeInHostFile)) {
                            result2[0] = injectedPsi;
                        }
                    }
                };
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.getProject());
                Document document = documentManager.getDocument(hostFile);
                if (document == null || !documentManager.isUncommited(document)) break block2;
                for (DocumentWindow documentWindow : InjectedLanguageManager.getInstance((Project)this.getProject()).getCachedInjectedDocuments(hostFile)) {
                    PsiFile injected = documentManager.getPsiFile((Document)documentWindow);
                    if (injected == null) continue;
                    visitor.visit(injected, Collections.emptyList());
                }
                break block3;
            }
            List injected = InjectedLanguageManager.getInstance((Project)this.getProject()).getInjectedPsiFiles(hostContext);
            if (injected == null) break block3;
            for (Pair pair : injected) {
                PsiFile injectedFile = ((PsiElement)pair.first).getContainingFile();
                visitor.visit(injectedFile, ContainerUtil.emptyList());
            }
        }
        return result2[0];
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other) {
        if (this.getClass() != other.getClass()) {
            return false;
        }
        if (!((InjectedSelfElementInfo)other).myHostContext.equals(this.myHostContext)) {
            return false;
        }
        SmartPointerElementInfo myElementInfo = ((SmartPsiElementPointerImpl)this.myInjectedFileRangeInHostFile).getElementInfo();
        SmartPointerElementInfo oElementInfo = ((SmartPsiElementPointerImpl)((InjectedSelfElementInfo)other).myInjectedFileRangeInHostFile).getElementInfo();
        return myElementInfo.pointsToTheSameElementAs(oElementInfo);
    }

    @Override
    public PsiFile restoreFile() {
        PsiFile hostFile = this.myHostContext.getContainingFile();
        if (hostFile == null || !hostFile.isValid()) {
            return null;
        }
        PsiElement hostContext = this.myHostContext.getElement();
        if (hostContext == null) {
            return null;
        }
        Segment segment = this.myInjectedFileRangeInHostFile.getPsiRange();
        if (segment == null) {
            return null;
        }
        TextRange rangeInHostFile = TextRange.create((Segment)segment);
        return this.getInjectedFileIn(hostContext, hostFile, rangeInHostFile);
    }

    @Nullable
    private ProperTextRange getInjectedRange(boolean psi) {
        Segment hostElementRange;
        PsiElement hostContext = this.myHostContext.getElement();
        if (hostContext == null) {
            return null;
        }
        Segment segment = hostElementRange = psi ? this.myInjectedFileRangeInHostFile.getPsiRange() : this.myInjectedFileRangeInHostFile.getRange();
        if (hostElementRange == null) {
            return null;
        }
        return InjectedSelfElementInfo.hostToInjected(psi, hostElementRange, this.restoreFile(), this.myAffixOffsets);
    }

    @Nullable
    private static ProperTextRange hostToInjected(boolean psi, Segment hostRange, @Nullable PsiFile injectedFile, @Nullable AffixOffsets affixOffsets) {
        VirtualFile virtualFile;
        VirtualFile virtualFile2 = virtualFile = injectedFile == null ? null : injectedFile.getVirtualFile();
        if (virtualFile instanceof VirtualFileWindow) {
            Project project2 = injectedFile.getProject();
            DocumentWindow documentWindow = ((VirtualFileWindow)virtualFile).getDocumentWindow();
            if (psi) {
                documentWindow = (DocumentWindow)((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project2)).getLastCommittedDocument((Document)documentWindow);
            }
            int start = documentWindow.hostToInjected(hostRange.getStartOffset());
            int end = documentWindow.hostToInjected(hostRange.getEndOffset());
            if (affixOffsets != null) {
                return affixOffsets.expandRangeToAffixes(start, end, InjectedLanguageManager.getInstance((Project)project2).getNonEditableFragments(documentWindow));
            }
            return ProperTextRange.create((int)start, (int)end);
        }
        return null;
    }

    @Override
    public void cleanup() {
        SmartPointerManager.getInstance((Project)this.getProject()).removePointer((SmartPsiElementPointer)this.myInjectedFileRangeInHostFile);
    }

    @Override
    @Nullable
    public Document getDocumentToSynchronize() {
        return ((SmartPsiElementPointerImpl)this.myHostContext).getElementInfo().getDocumentToSynchronize();
    }

    @Override
    public int elementHashCode() {
        return ((SmartPsiElementPointerImpl)this.myHostContext).getElementInfo().elementHashCode();
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.myHostContext.getProject();
    }

    public String toString() {
        return "injected{type=" + this.myType + ", range=" + this.myInjectedFileRangeInHostFile + ", host=" + this.myHostContext + "}";
    }

    private static class AffixOffsets {
        final int startAffixIndex;
        final int startAffixOffset;
        final int endAffixIndex;
        final int endAffixOffset;

        AffixOffsets(int startAffixIndex, int startAffixOffset, int endAffixIndex, int endAffixOffset) {
            this.startAffixIndex = startAffixIndex;
            this.startAffixOffset = startAffixOffset;
            this.endAffixIndex = endAffixIndex;
            this.endAffixOffset = endAffixOffset;
        }

        @Nullable
        ProperTextRange expandRangeToAffixes(int start, int end, List<TextRange> fragments) {
            TextRange fragment;
            if (this.startAffixIndex >= 0) {
                TextRange textRange = fragment = this.startAffixIndex < fragments.size() ? fragments.get(this.startAffixIndex) : null;
                if (fragment == null || this.startAffixOffset > fragment.getLength()) {
                    return null;
                }
                start = fragment.getStartOffset() + this.startAffixOffset;
            }
            if (this.endAffixIndex >= 0) {
                TextRange textRange = fragment = this.endAffixIndex < fragments.size() ? fragments.get(this.endAffixIndex) : null;
                if (fragment == null || this.endAffixOffset > fragment.getLength()) {
                    return null;
                }
                end = fragment.getStartOffset() + this.endAffixOffset;
            }
            return ProperTextRange.create((int)start, (int)end);
        }
    }
}

