/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.LanguageUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.smartPointers.FileElementInfo;
import com.intellij.psi.impl.smartPointers.Identikit;
import com.intellij.psi.impl.smartPointers.InjectedSelfElementInfo;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import org.jetbrains.annotations.NotNull;

class SmartPsiFileRangePointerImpl
extends SmartPsiElementPointerImpl<PsiFile>
implements SmartPsiFileRange {
    SmartPsiFileRangePointerImpl(@NotNull PsiFile containingFile, @NotNull ProperTextRange range, boolean forInjected) {
        super(containingFile, SmartPsiFileRangePointerImpl.createElementInfo(containingFile, range, forInjected));
    }

    @NotNull
    private static SmartPointerElementInfo createElementInfo(@NotNull PsiFile containingFile, @NotNull ProperTextRange range, boolean forInjected) {
        PsiLanguageInjectionHost host;
        Project project2 = containingFile.getProject();
        if (containingFile.getViewProvider() instanceof FreeThreadedFileViewProvider && (host = InjectedLanguageManager.getInstance((Project)project2).getInjectionHost((PsiElement)containingFile)) != null) {
            SmartPsiElementPointer hostPointer = SmartPointerManager.getInstance((Project)project2).createSmartPsiElementPointer((PsiElement)host);
            return new InjectedSelfElementInfo(project2, (PsiElement)containingFile, (TextRange)range, containingFile, (SmartPsiElementPointer<PsiLanguageInjectionHost>)hostPointer);
        }
        if (!forInjected && range.equals((Object)containingFile.getTextRange())) {
            return new FileElementInfo(containingFile);
        }
        return new SelfElementInfo(project2, range, Identikit.fromTypes(PsiElement.class, null, LanguageUtil.getRootLanguage((PsiElement)containingFile)), containingFile, forInjected);
    }

    @Override
    public PsiFile getContainingFile() {
        return this.getElementInfo().restoreFile();
    }

    @Override
    public PsiFile getElement() {
        if (this.getRange() == null) {
            return null;
        }
        return this.getContainingFile();
    }

    @Override
    public String toString() {
        return "SmartPsiFileRangePointerImpl{" + this.getElementInfo() + "}";
    }
}

