/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassInnerStuffCache {
    private final PsiExtensibleClass myClass;
    private final SimpleModificationTracker myTracker = new SimpleModificationTracker();

    public ClassInnerStuffCache(@NotNull PsiExtensibleClass aClass) {
        this.myClass = aClass;
    }

    private static <T> T[] copy(T[] value2) {
        return value2.length == 0 ? value2 : (Object[])value2.clone();
    }

    @NotNull
    public PsiMethod[] getConstructors() {
        return (PsiMethod[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> CachedValueProvider.Result.create((Object)PsiImplUtil.getConstructors(this.myClass), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTracker})));
    }

    @NotNull
    public PsiField[] getFields() {
        return (PsiField[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> CachedValueProvider.Result.create((Object)this.getAllFields(), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTracker})));
    }

    @NotNull
    public PsiMethod[] getMethods() {
        return (PsiMethod[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> CachedValueProvider.Result.create((Object)this.getAllMethods(), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTracker})));
    }

    @NotNull
    public PsiClass[] getInnerClasses() {
        return (PsiClass[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> CachedValueProvider.Result.create((Object)this.getAllInnerClasses(), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTracker})));
    }

    @Nullable
    public PsiField findFieldByName(String name, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findFieldByName(this.myClass, name, true);
        }
        return (PsiField)((Map)CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> CachedValueProvider.Result.create(this.getFieldsMap(), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTracker}))).get(name);
    }

    @NotNull
    public PsiMethod[] findMethodsByName(String name, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findMethodsByName(this.myClass, name, true);
        }
        PsiMethod[] methods = (PsiMethod[])((Map)CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> CachedValueProvider.Result.create(this.getMethodsMap(), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTracker}))).get(name);
        return methods == null ? PsiMethod.EMPTY_ARRAY : (PsiMethod[])methods.clone();
    }

    @Nullable
    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findInnerByName(this.myClass, name, true);
        }
        return (PsiClass)((Map)CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> CachedValueProvider.Result.create(this.getInnerClassesMap(), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTracker}))).get(name);
    }

    @Nullable
    public PsiMethod getValuesMethod() {
        return !this.myClass.isEnum() || this.myClass.getName() == null ? null : (PsiMethod)CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> {
            String text = "public static " + this.myClass.getName() + "[] values() { }";
            return new CachedValueProvider.Result((Object)this.getSyntheticMethod(text), new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTracker});
        });
    }

    @Nullable
    public PsiMethod getValueOfMethod() {
        return !this.myClass.isEnum() || this.myClass.getName() == null ? null : (PsiMethod)CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> {
            String text = "public static " + this.myClass.getName() + " valueOf(java.lang.String name) throws java.lang.IllegalArgumentException { }";
            return new CachedValueProvider.Result((Object)this.getSyntheticMethod(text), new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTracker});
        });
    }

    @NotNull
    private PsiField[] getAllFields() {
        List<PsiField> own = this.myClass.getOwnFields();
        List ext = PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiField.class);
        return (PsiField[])ArrayUtil.mergeCollections(own, (Collection)ext, (ArrayFactory)PsiField.ARRAY_FACTORY);
    }

    @NotNull
    private PsiMethod[] getAllMethods() {
        List<PsiMethod> own = this.myClass.getOwnMethods();
        List ext = PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiMethod.class);
        return (PsiMethod[])ArrayUtil.mergeCollections(own, (Collection)ext, (ArrayFactory)PsiMethod.ARRAY_FACTORY);
    }

    @NotNull
    private PsiClass[] getAllInnerClasses() {
        List<PsiClass> own = this.myClass.getOwnInnerClasses();
        List ext = PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiClass.class);
        return (PsiClass[])ArrayUtil.mergeCollections(own, (Collection)ext, (ArrayFactory)PsiClass.ARRAY_FACTORY);
    }

    @NotNull
    private Map<String, PsiField> getFieldsMap() {
        PsiField[] fields = this.getFields();
        if (fields.length == 0) {
            return Collections.emptyMap();
        }
        THashMap cachedFields = new THashMap();
        for (PsiField field : fields) {
            String name = field.getName();
            if (field instanceof ExternallyDefinedPsiElement && cachedFields.containsKey(name)) continue;
            cachedFields.put(name, field);
        }
        return cachedFields;
    }

    @NotNull
    private Map<String, PsiMethod[]> getMethodsMap() {
        PsiMethod[] methods = this.getMethods();
        if (methods.length == 0) {
            return Collections.emptyMap();
        }
        HashMap collectedMethods = ContainerUtil.newHashMap();
        for (PsiMethod method2 : methods) {
            List list = (List)collectedMethods.get(method2.getName());
            if (list == null) {
                list = ContainerUtil.newSmartList();
                collectedMethods.put(method2.getName(), list);
            }
            list.add(method2);
        }
        THashMap cachedMethods = ContainerUtil.newTroveMap();
        for (Map.Entry entry : collectedMethods.entrySet()) {
            List list = (List)entry.getValue();
            cachedMethods.put(entry.getKey(), list.toArray(new PsiMethod[list.size()]));
        }
        return cachedMethods;
    }

    @NotNull
    private Map<String, PsiClass> getInnerClassesMap() {
        PsiClass[] classes2 = this.getInnerClasses();
        if (classes2.length == 0) {
            return Collections.emptyMap();
        }
        THashMap cachedInners = new THashMap();
        for (PsiClass psiClass : classes2) {
            String name = psiClass.getName();
            if (name == null) {
                Logger.getInstance(ClassInnerStuffCache.class).error((Object)psiClass);
                continue;
            }
            if (psiClass instanceof ExternallyDefinedPsiElement && cachedInners.containsKey(name)) continue;
            cachedInners.put(name, psiClass);
        }
        return cachedInners;
    }

    private PsiMethod getSyntheticMethod(String text) {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myClass.getProject()).getElementFactory();
        PsiMethod method2 = factory.createMethodFromText(text, (PsiElement)this.myClass);
        return new LightMethod(this.myClass.getManager(), method2, this.myClass){

            @Override
            public int getTextOffset() {
                return ClassInnerStuffCache.this.myClass.getTextOffset();
            }
        };
    }

    public void dropCaches() {
        this.myTracker.incModificationCount();
    }
}

