/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.psi.DummyHolderViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.IdentityCharTable;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DummyHolder
extends PsiFileImpl {
    protected final PsiElement myContext;
    private final CharTable myTable;
    private final Boolean myExplicitlyValid;
    private final Language myLanguage;
    private final DummyHolderTreeLock myTreeElementLock = new DummyHolderTreeLock();
    private FileViewProvider myViewProvider;

    public DummyHolder(@NotNull PsiManager manager, TreeElement contentElement, PsiElement context) {
        this(manager, contentElement, context, SharedImplUtil.findCharTableByTree(contentElement));
    }

    public DummyHolder(@NotNull PsiManager manager, CharTable table, boolean validity) {
        this(manager, null, null, table, validity, PlainTextLanguage.INSTANCE);
    }

    public DummyHolder(@NotNull PsiManager manager, PsiElement context) {
        this(manager, null, context, null);
    }

    public DummyHolder(@NotNull PsiManager manager, @Nullable TreeElement contentElement, PsiElement context, @Nullable CharTable table) {
        this(manager, contentElement, context, table, null, DummyHolder.language(context, PlainTextLanguage.INSTANCE));
    }

    protected static Language language(PsiElement context, Language defaultLanguage) {
        if (context == null) {
            return defaultLanguage;
        }
        PsiFile file2 = context.getContainingFile();
        if (file2 == null) {
            return defaultLanguage;
        }
        Language contextLanguage = context.getLanguage();
        Language language = file2.getLanguage();
        if (language.isKindOf(contextLanguage)) {
            return language;
        }
        return contextLanguage;
    }

    public DummyHolder(@NotNull PsiManager manager, @Nullable TreeElement contentElement, @Nullable PsiElement context, @Nullable CharTable table, @Nullable Boolean validity, Language language) {
        super(TokenType.DUMMY_HOLDER, TokenType.DUMMY_HOLDER, new DummyHolderViewProvider(manager));
        this.myLanguage = language;
        ((DummyHolderViewProvider)this.getViewProvider()).setDummyHolder(this);
        this.myContext = context;
        Object object = this.myTable = table != null ? table : IdentityCharTable.INSTANCE;
        if (contentElement instanceof FileElement) {
            ((FileElement)contentElement).setPsi((PsiElement)this);
            ((FileElement)contentElement).setCharTable(this.myTable);
            this.setTreeElementPointer((FileElement)contentElement);
        } else if (contentElement != null) {
            this.getTreeElement().rawAddChildren(contentElement);
            this.clearCaches();
        }
        this.myExplicitlyValid = validity;
    }

    public DummyHolder(@NotNull PsiManager manager, PsiElement context, CharTable table) {
        this(manager, null, context, table);
    }

    public DummyHolder(@NotNull PsiManager manager, CharTable table, Language language) {
        this(manager, null, null, table, null, language);
    }

    public DummyHolder(@NotNull PsiManager manager, Language language, PsiElement context) {
        this(manager, null, context, null, null, language);
    }

    @Override
    public PsiElement getContext() {
        return this.myContext != null && this.myContext.isValid() ? this.myContext : super.getContext();
    }

    @Override
    public boolean isValid() {
        if (this.myExplicitlyValid != null) {
            return this.myExplicitlyValid;
        }
        return super.isValid();
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        visitor.visitFile((PsiFile)this);
    }

    @Override
    public String toString() {
        return "DummyHolder";
    }

    @NotNull
    public FileType getFileType() {
        PsiFile containingFile;
        PsiElement context = this.getContext();
        if (context != null && (containingFile = context.getContainingFile()) != null) {
            return containingFile.getFileType();
        }
        LanguageFileType fileType = this.myLanguage.getAssociatedFileType();
        return fileType != null ? fileType : PlainTextFileType.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FileElement getTreeElement() {
        FileElement fileElement = super.derefTreeElement();
        if (fileElement != null) {
            return fileElement;
        }
        DummyHolderTreeLock dummyHolderTreeLock = this.myTreeElementLock;
        synchronized (dummyHolderTreeLock) {
            fileElement = super.derefTreeElement();
            if (fileElement == null) {
                fileElement = new FileElement(TokenType.DUMMY_HOLDER, null);
                fileElement.setPsi((PsiElement)this);
                if (this.myTable != null) {
                    fileElement.setCharTable(this.myTable);
                }
                this.setTreeElementPointer(fileElement);
                this.clearCaches();
            }
            return fileElement;
        }
    }

    @Override
    @NotNull
    public Language getLanguage() {
        return this.myLanguage;
    }

    @Override
    protected PsiFileImpl clone() {
        PsiFileImpl psiClone = this.cloneImpl(this.getTreeElement());
        DummyHolderViewProvider dummyHolderViewProvider = new DummyHolderViewProvider(this.getManager());
        this.myViewProvider = dummyHolderViewProvider;
        dummyHolderViewProvider.setDummyHolder((DummyHolder)psiClone);
        FileElement treeClone = (FileElement)this.calcTreeElement().clone();
        psiClone.setTreeElementPointer(treeClone);
        psiClone.myOriginalFile = this.isPhysical() ? this : this.myOriginalFile;
        treeClone.setPsi((PsiElement)psiClone);
        return psiClone;
    }

    @Override
    @NotNull
    public FileViewProvider getViewProvider() {
        if (this.myViewProvider != null) {
            return this.myViewProvider;
        }
        return super.getViewProvider();
    }

    private static class DummyHolderTreeLock {
        private DummyHolderTreeLock() {
        }
    }
}

