/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLightTreeUtil {
    @Nullable
    @Contract(value="_,null->null")
    public static List<LighterASTNode> getArgList(@NotNull LighterAST tree, @Nullable LighterASTNode call) {
        LighterASTNode anonClass = LightTreeUtil.firstChildOfType(tree, call, JavaElementType.ANONYMOUS_CLASS);
        LighterASTNode exprList = LightTreeUtil.firstChildOfType(tree, anonClass != null ? anonClass : call, JavaElementType.EXPRESSION_LIST);
        return exprList == null ? null : JavaLightTreeUtil.getExpressionChildren(tree, exprList);
    }

    @Nullable
    @Contract(value="_,null->null")
    public static String getNameIdentifierText(@NotNull LighterAST tree, @Nullable LighterASTNode idOwner) {
        LighterASTNode id = LightTreeUtil.firstChildOfType(tree, idOwner, JavaTokenType.IDENTIFIER);
        return id != null ? RecordUtil.intern(tree.getCharTable(), id) : null;
    }

    @NotNull
    public static List<LighterASTNode> getExpressionChildren(@NotNull LighterAST tree, @NotNull LighterASTNode node) {
        return LightTreeUtil.getChildrenOfType(tree, node, ElementType.EXPRESSION_BIT_SET);
    }

    @Nullable
    public static LighterASTNode findExpressionChild(@NotNull LighterAST tree, @Nullable LighterASTNode node) {
        return LightTreeUtil.firstChildOfType(tree, node, ElementType.EXPRESSION_BIT_SET);
    }
}

