/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.formatting.FormatTextRanges;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.ChangeInfo;
import com.intellij.pom.tree.events.TreeChange;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiTreeDebugBuilder;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.DisabledIndentRangesProvider;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.impl.source.codeStyle.IndentHelperImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementVisitor;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.TextRangeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class PostprocessReformattingAspect
implements PomModelAspect {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PostprocessReformattingAspect");
    private final Project myProject;
    private final PsiManager myPsiManager;
    private final TreeAspect myTreeAspect;
    private static final Key<Throwable> REFORMAT_ORIGINATOR = Key.create((String)"REFORMAT_ORIGINATOR");
    private final ThreadLocal<Context> myContext = new ThreadLocal<Context>(){

        @Override
        protected Context initialValue() {
            return new Context();
        }
    };

    public PostprocessReformattingAspect(Project project2, PsiManager psiManager, TreeAspect treeAspect, final CommandProcessor processor2) {
        this.myProject = project2;
        this.myPsiManager = psiManager;
        this.myTreeAspect = treeAspect;
        PomManager.getModel((Project)psiManager.getProject()).registerAspect(PostprocessReformattingAspect.class, (PomModelAspect)this, Collections.singleton(treeAspect));
        ApplicationAdapter applicationListener = new ApplicationAdapter(){

            public void writeActionStarted(@NotNull Object action) {
                Project project2;
                if (processor2 != null && (project2 = processor2.getCurrentCommandProject()) == PostprocessReformattingAspect.this.myProject) {
                    PostprocessReformattingAspect.this.incrementPostponedCounter();
                }
            }

            public void writeActionFinished(@NotNull Object action) {
                Project project2;
                if (processor2 != null && (project2 = processor2.getCurrentCommandProject()) == PostprocessReformattingAspect.this.myProject) {
                    PostprocessReformattingAspect.this.decrementPostponedCounter();
                }
            }
        };
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)applicationListener, (Disposable)project2);
    }

    public void disablePostprocessFormattingInside(@NotNull Runnable runnable2) {
        this.disablePostprocessFormattingInside((Computable)((NullableComputable)() -> {
            runnable2.run();
            return null;
        }));
    }

    public <T> T disablePostprocessFormattingInside(@NotNull Computable<T> computable) {
        Object object;
        try {
            this.getContext().myDisabledCounter++;
            object = computable.compute();
        }
        catch (Throwable throwable) {
            this.getContext().myDisabledCounter--;
            LOG.assertTrue(this.getContext().myDisabledCounter > 0 || !this.isDisabled());
            throw throwable;
        }
        this.getContext().myDisabledCounter--;
        LOG.assertTrue(this.getContext().myDisabledCounter > 0 || !this.isDisabled());
        return (T)object;
    }

    public void postponeFormattingInside(@NotNull Runnable runnable2) {
        this.postponeFormattingInside((Computable)((NullableComputable)() -> {
            runnable2.run();
            return null;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T postponeFormattingInside(@NotNull Computable<T> computable) {
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        try {
            this.incrementPostponedCounter();
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            this.decrementPostponedCounter();
        }
    }

    private void incrementPostponedCounter() {
        this.getContext().myPostponedCounter++;
    }

    private void decrementPostponedCounter() {
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        if (--this.getContext().myPostponedCounter == 0) {
            if (application.isWriteAccessAllowed()) {
                this.doPostponedFormatting();
            } else {
                application.runWriteAction(() -> this.doPostponedFormatting());
            }
        }
    }

    private static void atomic(@NotNull Runnable r) {
        ProgressManager.getInstance().executeNonCancelableSection(r);
    }

    public void update(final @NotNull PomModelEvent event) {
        PostprocessReformattingAspect.atomic(new Runnable(){

            @Override
            public void run() {
                if (PostprocessReformattingAspect.this.isDisabled() || PostprocessReformattingAspect.this.getContext().myPostponedCounter == 0 && !ApplicationManager.getApplication().isUnitTestMode()) {
                    return;
                }
                TreeChangeEvent changeSet = (TreeChangeEvent)event.getChangeSet((PomModelAspect)PostprocessReformattingAspect.this.myTreeAspect);
                if (changeSet == null) {
                    return;
                }
                PsiElement psiElement = changeSet.getRootElement().getPsi();
                if (psiElement == null) {
                    return;
                }
                PsiFile containingFile = InjectedLanguageManager.getInstance((Project)psiElement.getProject()).getTopLevelFile(psiElement);
                final FileViewProvider viewProvider = containingFile.getViewProvider();
                if (!viewProvider.isEventSystemEnabled()) {
                    return;
                }
                PostprocessReformattingAspect.this.getContext().myUpdatedProviders.add(viewProvider);
                for (ASTNode node : changeSet.getChangedElements()) {
                    TreeChange treeChange = changeSet.getChangesByElement(node);
                    block5: for (ASTNode affectedChild : treeChange.getAffectedChildren()) {
                        ChangeInfo childChange = treeChange.getChangeByChild(affectedChild);
                        switch (childChange.getChangeType()) {
                            case 0: 
                            case 2: {
                                PostprocessReformattingAspect.this.postponeFormatting(viewProvider, affectedChild);
                                continue block5;
                            }
                            case 3: {
                                if (CodeEditUtil.isNodeGenerated(affectedChild)) continue block5;
                                ((TreeElement)affectedChild).acceptTree(new RecursiveTreeElementWalkingVisitor(){

                                    @Override
                                    protected void visitNode(TreeElement element) {
                                        if (CodeEditUtil.isNodeGenerated(element) && CodeEditUtil.isSuspendedNodesReformattingAllowed()) {
                                            PostprocessReformattingAspect.this.postponeFormatting(viewProvider, element);
                                            return;
                                        }
                                        super.visitNode(element);
                                    }
                                });
                            }
                        }
                    }
                }
            }
        });
    }

    public void doPostponedFormatting() {
        PostprocessReformattingAspect.atomic(() -> {
            if (this.isDisabled()) {
                return;
            }
            try {
                FileViewProvider[] viewProviders;
                for (FileViewProvider viewProvider : viewProviders = this.getContext().myUpdatedProviders.toArray(new FileViewProvider[this.getContext().myUpdatedProviders.size()])) {
                    this.doPostponedFormatting(viewProvider);
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            finally {
                LOG.assertTrue(this.getContext().myReformatElements.isEmpty(), (Object)this.getContext().myReformatElements);
            }
        });
    }

    public void postponedFormatting(@NotNull FileViewProvider viewProvider) {
        this.postponedFormattingImpl(viewProvider, true);
    }

    public void doPostponedFormatting(@NotNull FileViewProvider viewProvider) {
        this.postponedFormattingImpl(viewProvider, false);
    }

    private void postponedFormattingImpl(@NotNull FileViewProvider viewProvider, boolean check) {
        PostprocessReformattingAspect.atomic(() -> {
            if (this.isDisabled() || check && !this.getContext().myUpdatedProviders.contains(viewProvider)) {
                return;
            }
            try {
                this.disablePostprocessFormattingInside(() -> this.doPostponedFormattingInner(viewProvider));
            }
            finally {
                this.getContext().myUpdatedProviders.remove(viewProvider);
                this.getContext().myReformatElements.remove(viewProvider);
                viewProvider.putUserData(REFORMAT_ORIGINATOR, null);
            }
        });
    }

    public boolean isViewProviderLocked(@NotNull FileViewProvider fileViewProvider) {
        return this.getContext().myReformatElements.containsKey(fileViewProvider);
    }

    public void beforeDocumentChanged(@NotNull FileViewProvider viewProvider) {
        if (this.isViewProviderLocked(viewProvider)) {
            Throwable cause = (Throwable)viewProvider.getUserData(REFORMAT_ORIGINATOR);
            String message2 = "Document is locked by write PSI operations. Use PsiDocumentManager.doPostponedOperationsAndUnblockDocument() to commit PSI changes to the document." + (cause == null ? "" : " See cause stacktrace for the reason to lock.");
            throw cause == null ? new RuntimeException(message2) : new RuntimeException(message2, cause);
        }
        this.postponedFormatting(viewProvider);
    }

    public static PostprocessReformattingAspect getInstance(Project project2) {
        return (PostprocessReformattingAspect)project2.getComponent(PostprocessReformattingAspect.class);
    }

    private void postponeFormatting(@NotNull FileViewProvider viewProvider, @NotNull ASTNode child) {
        ArrayList<ASTNode> list;
        if (!CodeEditUtil.isNodeGenerated(child) && child.getElementType() != TokenType.WHITE_SPACE) {
            int oldIndent = CodeEditUtil.getOldIndentation(child);
            LOG.assertTrue(oldIndent >= 0, (Object)("for not generated items old indentation must be defined: element=" + child + ", text=" + child.getText()));
        }
        if ((list = (ArrayList<ASTNode>)this.getContext().myReformatElements.get(viewProvider)) == null) {
            list = new ArrayList<ASTNode>();
            this.getContext().myReformatElements.put(viewProvider, list);
            if (Holder.STORE_REFORMAT_ORIGINATOR_STACKTRACE) {
                viewProvider.putUserData(REFORMAT_ORIGINATOR, (Object)new Throwable());
            }
        }
        list.add(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPostponedFormattingInner(@NotNull FileViewProvider key2) {
        FileManager fileManager;
        FileViewProvider viewProvider;
        List astNodes = (List)this.getContext().myReformatElements.remove(key2);
        Document document = key2.getDocument();
        if (document == null) {
            return;
        }
        VirtualFile virtualFile = key2.getVirtualFile();
        if (!virtualFile.isValid()) {
            return;
        }
        PsiManager manager = key2.getManager();
        if (manager instanceof PsiManagerEx && (viewProvider = (fileManager = ((PsiManagerEx)manager).getFileManager()).findCachedViewProvider(virtualFile)) != key2) {
            if (viewProvider == null) {
                viewProvider = fileManager.findViewProvider(virtualFile);
            }
            if (viewProvider != null) {
                key2 = viewProvider;
            }
        }
        TreeSet<PostprocessFormattingTask> postProcessTasks = new TreeSet<PostprocessFormattingTask>();
        ArrayList toDispose = ContainerUtilRt.newArrayList();
        try {
            PostprocessReformattingAspect.handleReformatMarkers(key2, postProcessTasks);
            toDispose.addAll(postProcessTasks);
            if (astNodes != null) {
                PostprocessReformattingAspect.createActionsMap(astNodes, key2, postProcessTasks);
            }
            if (Boolean.getBoolean("check.psi.is.valid") && ApplicationManager.getApplication().isUnitTestMode()) {
                this.checkPsiIsCorrect(key2);
            }
            while (!postProcessTasks.isEmpty()) {
                List<PostponedAction> normalizedActions = this.normalizeAndReorderPostponedActions(postProcessTasks, document);
                toDispose.addAll(normalizedActions);
                for (PostponedAction normalizedAction : normalizedActions) {
                    CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)this.myPsiManager.getProject());
                    boolean old = settings.ENABLE_JAVADOC_FORMATTING;
                    settings.ENABLE_JAVADOC_FORMATTING = false;
                    try {
                        normalizedAction.execute(key2);
                    }
                    finally {
                        settings.ENABLE_JAVADOC_FORMATTING = old;
                    }
                }
            }
        }
        finally {
            for (Disposable disposable : toDispose) {
                disposable.dispose();
            }
        }
    }

    private void checkPsiIsCorrect(@NotNull FileViewProvider key2) {
        String expectedPsi;
        PsiFile actualPsi = key2.getPsi(key2.getBaseLanguage());
        PsiTreeDebugBuilder treeDebugBuilder = new PsiTreeDebugBuilder().setShowErrorElements(false).setShowWhiteSpaces(false);
        String actualPsiTree = treeDebugBuilder.psiToString((PsiElement)actualPsi);
        String fileName = key2.getVirtualFile().getName();
        PsiFile psi = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(fileName, FileTypeManager.getInstance().getFileTypeByFileName(fileName), (CharSequence)actualPsi.getNode().getText(), LocalTimeCounter.currentTime(), false);
        if (actualPsi.getClass().equals(psi.getClass()) && !(expectedPsi = treeDebugBuilder.psiToString((PsiElement)psi)).equals(actualPsiTree)) {
            this.getContext().myReformatElements.clear();
            assert (expectedPsi.equals(actualPsiTree)) : "Refactored psi should be the same as result of parsing";
        }
    }

    @NotNull
    private List<PostponedAction> normalizeAndReorderPostponedActions(@NotNull Set<PostprocessFormattingTask> rangesToProcess, @NotNull Document document) {
        ArrayList<PostprocessFormattingTask> freeFormattingActions = new ArrayList<PostprocessFormattingTask>();
        ArrayList<ReindentTask> indentActions = new ArrayList<ReindentTask>();
        PostprocessFormattingTask accumulatedTask = null;
        Iterator<PostprocessFormattingTask> iterator = rangesToProcess.iterator();
        while (iterator.hasNext()) {
            PostprocessFormattingTask currentTask = iterator.next();
            if (accumulatedTask == null) {
                accumulatedTask = currentTask;
                iterator.remove();
                continue;
            }
            if (accumulatedTask.getStartOffset() > currentTask.getEndOffset() || accumulatedTask.getStartOffset() == currentTask.getEndOffset() && !PostprocessReformattingAspect.canStickActionsTogether(accumulatedTask, currentTask)) {
                if (accumulatedTask instanceof ReindentTask) {
                    indentActions.add((ReindentTask)accumulatedTask);
                } else {
                    freeFormattingActions.add(accumulatedTask);
                }
                accumulatedTask = currentTask;
                iterator.remove();
                continue;
            }
            if (accumulatedTask instanceof ReformatTask && currentTask instanceof ReindentTask) {
                if (accumulatedTask.getStartOffset() < currentTask.getStartOffset()) {
                    RangeMarker endOfRange = document.createRangeMarker(accumulatedTask.getStartOffset(), currentTask.getStartOffset());
                    rangesToProcess.add(new ReformatTask(endOfRange));
                    iterator = rangesToProcess.iterator();
                    while (iterator.next().getRange() != currentTask.getRange()) {
                    }
                }
                RangeMarker rangeToProcess = document.createRangeMarker(currentTask.getEndOffset(), accumulatedTask.getEndOffset());
                freeFormattingActions.add(new ReformatWithHeadingWhitespaceTask(rangeToProcess));
                accumulatedTask = currentTask;
                iterator.remove();
                continue;
            }
            if (!(accumulatedTask instanceof ReindentTask)) {
                iterator.remove();
                boolean withLeadingWhitespace = accumulatedTask instanceof ReformatWithHeadingWhitespaceTask;
                if (accumulatedTask instanceof ReformatTask && currentTask instanceof ReformatWithHeadingWhitespaceTask && accumulatedTask.getStartOffset() == currentTask.getStartOffset()) {
                    withLeadingWhitespace = true;
                } else if (accumulatedTask instanceof ReformatWithHeadingWhitespaceTask && currentTask instanceof ReformatTask && accumulatedTask.getStartOffset() < currentTask.getStartOffset()) {
                    withLeadingWhitespace = false;
                }
                int newStart = Math.min(accumulatedTask.getStartOffset(), currentTask.getStartOffset());
                int newEnd = Math.max(accumulatedTask.getEndOffset(), currentTask.getEndOffset());
                RangeMarker rangeMarker = accumulatedTask.getStartOffset() == newStart && accumulatedTask.getEndOffset() == newEnd ? accumulatedTask.getRange() : (currentTask.getStartOffset() == newStart && currentTask.getEndOffset() == newEnd ? currentTask.getRange() : document.createRangeMarker(newStart, newEnd));
                if (withLeadingWhitespace) {
                    accumulatedTask = new ReformatWithHeadingWhitespaceTask(rangeMarker);
                    continue;
                }
                accumulatedTask = new ReformatTask(rangeMarker);
                continue;
            }
            if (!(currentTask instanceof ReindentTask)) continue;
            iterator.remove();
        }
        if (accumulatedTask != null) {
            if (accumulatedTask instanceof ReindentTask) {
                indentActions.add((ReindentTask)accumulatedTask);
            } else {
                freeFormattingActions.add(accumulatedTask);
            }
        }
        ArrayList<PostponedAction> result2 = new ArrayList<PostponedAction>();
        Collections.reverse(freeFormattingActions);
        Collections.reverse(indentActions);
        if (!freeFormattingActions.isEmpty()) {
            FormatTextRanges ranges = new FormatTextRanges();
            for (PostprocessFormattingTask action : freeFormattingActions) {
                TextRange range = TextRange.create((Segment)action);
                ranges.add(range, action instanceof ReformatWithHeadingWhitespaceTask);
            }
            result2.add(new ReformatRangesAction(ranges));
        }
        if (!indentActions.isEmpty()) {
            ReindentRangesAction reindentRangesAction = new ReindentRangesAction();
            for (ReindentTask action : indentActions) {
                reindentRangesAction.add(action.getRange(), action.getOldIndent());
            }
            result2.add(reindentRangesAction);
        }
        return result2;
    }

    private static boolean canStickActionsTogether(PostprocessFormattingTask currentTask, PostprocessFormattingTask nextTask) {
        if (nextTask instanceof ReformatWithHeadingWhitespaceTask && nextTask.getStartOffset() == nextTask.getEndOffset()) {
            return false;
        }
        if (currentTask instanceof ReformatWithHeadingWhitespaceTask && currentTask.getStartOffset() == currentTask.getEndOffset()) {
            return false;
        }
        return !(currentTask instanceof ReindentTask);
    }

    private static void createActionsMap(@NotNull List<ASTNode> astNodes, @NotNull FileViewProvider provider2, final @NotNull TreeSet<PostprocessFormattingTask> rangesToProcess) {
        final HashSet<ASTNode> nodesToProcess = new HashSet<ASTNode>(astNodes);
        final Document document = provider2.getDocument();
        if (document == null) {
            return;
        }
        for (ASTNode node : astNodes) {
            nodesToProcess.remove(node);
            FileElement fileElement = TreeUtil.getFileElement((TreeElement)node);
            if (fileElement == null || ((PsiFile)fileElement.getPsi()).getViewProvider() != provider2) continue;
            final boolean isGenerated = CodeEditUtil.isNodeGenerated(node);
            ((TreeElement)node).acceptTree(new RecursiveTreeElementVisitor(){
                private boolean inGeneratedContext;
                {
                    this.inGeneratedContext = !isGenerated;
                }

                @Override
                protected boolean visitNode(TreeElement element) {
                    if (nodesToProcess.contains(element)) {
                        return false;
                    }
                    boolean currentNodeGenerated = CodeEditUtil.isNodeGenerated(element);
                    CodeEditUtil.setNodeGenerated(element, false);
                    if (currentNodeGenerated && !this.inGeneratedContext) {
                        rangesToProcess.add(new ReformatTask(document.createRangeMarker(element.getTextRange())));
                        this.inGeneratedContext = true;
                    }
                    if (!currentNodeGenerated && this.inGeneratedContext) {
                        if (element.getElementType() == TokenType.WHITE_SPACE) {
                            return false;
                        }
                        int oldIndent = CodeEditUtil.getOldIndentation(element);
                        if (oldIndent < 0) {
                            LOG.warn("For not generated items old indentation must be defined: element " + element);
                            oldIndent = 0;
                        }
                        CodeEditUtil.setOldIndentation(element, -1);
                        for (TextRange indentRange : this.getEnabledRanges(element.getPsi())) {
                            rangesToProcess.add(new ReindentTask(document.createRangeMarker(indentRange), oldIndent));
                        }
                        this.inGeneratedContext = false;
                    }
                    return true;
                }

                private Iterable<TextRange> getEnabledRanges(@NotNull PsiElement element) {
                    ArrayList<TextRange> disabledRanges = new ArrayList<TextRange>();
                    for (DisabledIndentRangesProvider rangesProvider : (DisabledIndentRangesProvider[])DisabledIndentRangesProvider.EP_NAME.getExtensions()) {
                        Collection<TextRange> providedDisabledRanges = rangesProvider.getDisabledIndentRanges(element);
                        if (providedDisabledRanges == null) continue;
                        disabledRanges.addAll(providedDisabledRanges);
                    }
                    return TextRangeUtil.excludeRanges((TextRange)element.getTextRange(), disabledRanges);
                }

                @Override
                public void visitComposite(CompositeElement composite) {
                    boolean oldGeneratedContext = this.inGeneratedContext;
                    super.visitComposite(composite);
                    this.inGeneratedContext = oldGeneratedContext;
                }

                @Override
                public void visitLeaf(LeafElement leaf) {
                    boolean oldGeneratedContext = this.inGeneratedContext;
                    super.visitLeaf(leaf);
                    this.inGeneratedContext = oldGeneratedContext;
                }
            });
        }
    }

    private static void handleReformatMarkers(@NotNull FileViewProvider key2, final @NotNull Set<PostprocessFormattingTask> rangesToProcess) {
        final Document document = key2.getDocument();
        if (document == null) {
            return;
        }
        for (FileElement fileElement : ((SingleRootFileViewProvider)key2).getKnownTreeRoots()) {
            fileElement.acceptTree(new RecursiveTreeElementWalkingVisitor(){

                @Override
                protected void visitNode(TreeElement element) {
                    if (CodeEditUtil.isMarkedToReformatBefore(element)) {
                        CodeEditUtil.markToReformatBefore(element, false);
                        rangesToProcess.add(new ReformatWithHeadingWhitespaceTask(document.createRangeMarker(element.getStartOffset(), element.getStartOffset())));
                    } else if (CodeEditUtil.isMarkedToReformat(element)) {
                        CodeEditUtil.markToReformat(element, false);
                        rangesToProcess.add(new ReformatWithHeadingWhitespaceTask(document.createRangeMarker(element.getStartOffset(), element.getStartOffset() + element.getTextLength())));
                    }
                    super.visitNode(element);
                }
            });
        }
    }

    private static void adjustIndentationInRange(@NotNull PsiFile file2, @NotNull Document document, @NotNull TextRange[] indents, int indentAdjustment) {
        CharSequence charsSequence = document.getCharsSequence();
        for (TextRange indent : indents) {
            String oldIndentStr = charsSequence.subSequence(indent.getStartOffset() + 1, indent.getEndOffset()).toString();
            int oldIndent = IndentHelperImpl.getIndent(file2.getProject(), file2.getFileType(), oldIndentStr, true);
            String newIndentStr = IndentHelperImpl.fillIndent(file2.getProject(), file2.getFileType(), Math.max(oldIndent + indentAdjustment, 0));
            document.replaceString(indent.getStartOffset() + 1, indent.getEndOffset(), (CharSequence)newIndentStr);
        }
    }

    private static int getNewIndent(@NotNull PsiFile psiFile, int firstWhitespace) {
        int startOffset;
        Document document = psiFile.getViewProvider().getDocument();
        assert (document != null);
        int endOffset = startOffset = document.getLineStartOffset(document.getLineNumber(firstWhitespace));
        CharSequence charsSequence = document.getCharsSequence();
        while (Character.isWhitespace(charsSequence.charAt(endOffset++))) {
        }
        String newIndentStr = charsSequence.subSequence(startOffset, endOffset - 1).toString();
        return IndentHelperImpl.getIndent(psiFile.getProject(), psiFile.getFileType(), newIndentStr, true);
    }

    public boolean isDisabled() {
        return this.getContext().myDisabledCounter > 0;
    }

    @NotNull
    private CodeFormatterFacade getFormatterFacade(@NotNull FileViewProvider viewProvider) {
        CodeStyleSettings styleSettings = CodeStyleSettingsManager.getSettings((Project)this.myPsiManager.getProject());
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myPsiManager.getProject());
        Document document = viewProvider.getDocument();
        assert (document != null);
        CodeFormatterFacade codeFormatter = new CodeFormatterFacade(styleSettings, viewProvider.getBaseLanguage());
        documentManager.commitDocument(document);
        return codeFormatter;
    }

    public void clear() {
        this.getContext().myReformatElements.clear();
    }

    private Context getContext() {
        return this.myContext.get();
    }

    private static class Context {
        private int myPostponedCounter = 0;
        private int myDisabledCounter = 0;
        private final Set<FileViewProvider> myUpdatedProviders = new HashSet<FileViewProvider>();
        private final Map<FileViewProvider, List<ASTNode>> myReformatElements = new HashMap<FileViewProvider, List<ASTNode>>();

        private Context() {
        }
    }

    private static class ReindentRangesAction
    implements PostponedAction {
        private final List<Pair<Integer, RangeMarker>> myRangesToReindent = new ArrayList<Pair<Integer, RangeMarker>>();

        private ReindentRangesAction() {
        }

        public void add(@NotNull RangeMarker rangeMarker, int oldIndent) {
            this.myRangesToReindent.add((Pair<Integer, RangeMarker>)new Pair((Object)oldIndent, (Object)rangeMarker));
        }

        @Override
        public void execute(@NotNull FileViewProvider viewProvider) {
            Document document = viewProvider.getDocument();
            assert (document != null);
            PsiFile psiFile = viewProvider.getPsi(viewProvider.getBaseLanguage());
            for (Pair<Integer, RangeMarker> integerRangeMarkerPair : this.myRangesToReindent) {
                RangeMarker marker = (RangeMarker)integerRangeMarkerPair.second;
                CharSequence charsSequence = document.getCharsSequence().subSequence(marker.getStartOffset(), marker.getEndOffset());
                int oldIndent = (Integer)integerRangeMarkerPair.first;
                TextRange[] whitespaces = CharArrayUtil.getIndents((CharSequence)charsSequence, (int)marker.getStartOffset());
                int indentAdjustment = PostprocessReformattingAspect.getNewIndent(psiFile, marker.getStartOffset()) - oldIndent;
                if (indentAdjustment == 0) continue;
                PostprocessReformattingAspect.adjustIndentationInRange(psiFile, document, whitespaces, indentAdjustment);
            }
        }

        public void dispose() {
            for (Pair<Integer, RangeMarker> pair : this.myRangesToReindent) {
                RangeMarker marker = (RangeMarker)pair.second;
                if (!marker.isValid()) continue;
                marker.dispose();
            }
        }
    }

    private class ReformatRangesAction
    implements PostponedAction {
        private final FormatTextRanges myRanges;

        public ReformatRangesAction(FormatTextRanges ranges) {
            this.myRanges = ranges;
        }

        @Override
        public void execute(@NotNull FileViewProvider viewProvider) {
            CodeFormatterFacade codeFormatter = PostprocessReformattingAspect.this.getFormatterFacade(viewProvider);
            codeFormatter.setReformatContext(true);
            codeFormatter.processText(viewProvider.getPsi(viewProvider.getBaseLanguage()), this.myRanges.ensureNonEmpty(), false);
        }

        public void dispose() {
        }
    }

    private static interface PostponedAction
    extends Disposable {
        public void execute(@NotNull FileViewProvider var1);
    }

    private static class ReindentTask
    extends PostprocessFormattingTask {
        private final int myOldIndent;

        public ReindentTask(@NotNull RangeMarker rangeMarker, int oldIndent) {
            super(rangeMarker);
            this.myOldIndent = oldIndent;
        }

        public int getOldIndent() {
            return this.myOldIndent;
        }
    }

    private static class ReformatWithHeadingWhitespaceTask
    extends PostprocessFormattingTask {
        public ReformatWithHeadingWhitespaceTask(@NotNull RangeMarker rangeMarker) {
            super(rangeMarker);
        }
    }

    private static class ReformatTask
    extends PostprocessFormattingTask {
        public ReformatTask(@NotNull RangeMarker rangeMarker) {
            super(rangeMarker);
        }
    }

    private static abstract class PostprocessFormattingTask
    implements Comparable<PostprocessFormattingTask>,
    Segment,
    Disposable {
        @NotNull
        private final RangeMarker myRange;

        public PostprocessFormattingTask(@NotNull RangeMarker rangeMarker) {
            this.myRange = rangeMarker;
        }

        @Override
        public int compareTo(@NotNull PostprocessFormattingTask o) {
            RangeMarker o1 = this.myRange;
            RangeMarker o2 = o.myRange;
            if (o1.equals(o2)) {
                return 0;
            }
            int diff = o2.getEndOffset() - o1.getEndOffset();
            if (diff == 0) {
                if (o1.getStartOffset() == o2.getStartOffset()) {
                    return 0;
                }
                if (o1.getStartOffset() == o1.getEndOffset()) {
                    return -1;
                }
                if (o2.getStartOffset() == o2.getEndOffset()) {
                    return 1;
                }
                return o1.getStartOffset() - o2.getStartOffset();
            }
            return diff;
        }

        @NotNull
        public RangeMarker getRange() {
            return this.myRange;
        }

        public int getStartOffset() {
            return this.myRange.getStartOffset();
        }

        public int getEndOffset() {
            return this.myRange.getEndOffset();
        }

        public void dispose() {
            if (this.myRange.isValid()) {
                this.myRange.dispose();
            }
        }
    }

    private static class Holder {
        private static final boolean STORE_REFORMAT_ORIGINATOR_STACKTRACE = ApplicationManager.getApplication().isInternal();

        private Holder() {
        }
    }
}

