/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotatedJavaCodeReferenceElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiClassReferenceType
extends PsiClassType.Stub {
    private final Computable<PsiJavaCodeReferenceElement> myReference;

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel level) {
        this(reference, level, PsiClassReferenceType.collectAnnotations(reference));
    }

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel level, @NotNull PsiAnnotation[] annotations2) {
        super(level, annotations2);
        this.myReference = new Computable.PredefinedValueComputable((Object)reference);
    }

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel level, @NotNull TypeAnnotationProvider provider2) {
        this((Computable<PsiJavaCodeReferenceElement>)new Computable.PredefinedValueComputable((Object)reference), level, provider2);
    }

    public PsiClassReferenceType(@NotNull Computable<PsiJavaCodeReferenceElement> reference, LanguageLevel level, @NotNull TypeAnnotationProvider provider2) {
        super(level, provider2);
        this.myReference = reference;
    }

    private static PsiAnnotation[] collectAnnotations(PsiJavaCodeReferenceElement reference) {
        List result2 = null;
        for (PsiElement child = reference.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiAnnotation)) continue;
            if (result2 == null) {
                result2 = new SmartList();
            }
            result2.add((PsiAnnotation)child);
        }
        return result2 == null ? PsiAnnotation.EMPTY_ARRAY : result2.toArray(new PsiAnnotation[result2.size()]);
    }

    public boolean isValid() {
        PsiJavaCodeReferenceElement reference = (PsiJavaCodeReferenceElement)this.myReference.compute();
        return reference != null && reference.isValid();
    }

    public boolean equalsToText(@NotNull String text) {
        return Comparing.equal((String)text, (String)this.getCanonicalText());
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        return this.getReference().getResolveScope();
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        if (this.myLanguageLevel != null) {
            return this.myLanguageLevel;
        }
        return PsiUtil.getLanguageLevel((PsiElement)this.getReference());
    }

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel.equals((Object)this.myLanguageLevel)) {
            return this;
        }
        return new PsiClassReferenceType(this.getReference(), languageLevel, this.getAnnotationProvider());
    }

    public PsiClass resolve() {
        return this.resolveGenerics().getElement();
    }

    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        PsiJavaCodeReferenceElement reference = this.getReference();
        PsiUtilCore.ensureValid((PsiElement)reference);
        JavaResolveResult result2 = reference.advancedResolve(false);
        return result2.getElement() == null ? PsiClassType.ClassResolveResult.EMPTY : new DelegatingClassResolveResult(result2);
    }

    @NotNull
    public PsiClassType rawType() {
        PsiJavaCodeReferenceElement reference = this.getReference();
        PsiElement resolved = reference.resolve();
        if (resolved instanceof PsiClass) {
            PsiClass aClass = (PsiClass)resolved;
            if (!PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass).iterator().hasNext()) {
                return this;
            }
            PsiManager manager = reference.getManager();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
            PsiSubstitutor rawSubstitutor = factory.createRawSubstitutor((PsiTypeParameterListOwner)aClass);
            return new PsiImmediateClassType(aClass, rawSubstitutor, this.getLanguageLevel(), this.getAnnotationProvider());
        }
        String qualifiedName = reference.getQualifiedName();
        String name = reference.getReferenceName();
        if (name == null) {
            name = "";
        }
        LightClassReference lightReference = new LightClassReference(reference.getManager(), name, qualifiedName, reference.getResolveScope());
        return new PsiClassReferenceType((PsiJavaCodeReferenceElement)lightReference, null, this.getAnnotationProvider());
    }

    public String getClassName() {
        return this.getReference().getReferenceName();
    }

    @NotNull
    public PsiType[] getParameters() {
        return this.getReference().getTypeParameters();
    }

    @NotNull
    public PsiClassType createImmediateCopy() {
        PsiClassType.ClassResolveResult resolveResult = this.resolveGenerics();
        PsiClass element = resolveResult.getElement();
        return element == null ? this : new PsiImmediateClassType(element, resolveResult.getSubstitutor());
    }

    @NotNull
    public String getPresentableText(boolean annotated) {
        PsiAnnotation[] annotations2;
        String presentableText = PsiNameHelper.getPresentableText((PsiJavaCodeReferenceElement)this.getReference());
        PsiAnnotation[] psiAnnotationArray = annotations2 = annotated ? this.getAnnotations() : PsiAnnotation.EMPTY_ARRAY;
        if (annotations2.length == 0) {
            return presentableText;
        }
        StringBuilder sb = new StringBuilder();
        PsiNameHelper.appendAnnotations((StringBuilder)sb, (PsiAnnotation[])annotations2, (boolean)false);
        sb.append(presentableText);
        return sb.toString();
    }

    @NotNull
    public String getCanonicalText(boolean annotated) {
        return this.getText(annotated);
    }

    @NotNull
    public String getInternalCanonicalText() {
        return this.getCanonicalText(true);
    }

    private String getText(boolean annotated) {
        PsiJavaCodeReferenceElement reference = this.getReference();
        if (reference instanceof PsiAnnotatedJavaCodeReferenceElement) {
            PsiAnnotatedJavaCodeReferenceElement ref = (PsiAnnotatedJavaCodeReferenceElement)reference;
            PsiAnnotation[] annotations2 = annotated ? this.getAnnotations() : PsiAnnotation.EMPTY_ARRAY;
            return ref.getCanonicalText(annotated, annotations2.length == 0 ? null : annotations2);
        }
        return reference.getCanonicalText();
    }

    @NotNull
    public PsiJavaCodeReferenceElement getReference() {
        return (PsiJavaCodeReferenceElement)ObjectUtils.assertNotNull((Object)this.myReference.compute());
    }

    private static class DelegatingClassResolveResult
    implements PsiClassType.ClassResolveResult {
        private final JavaResolveResult myDelegate;

        private DelegatingClassResolveResult(@NotNull JavaResolveResult delegate) {
            this.myDelegate = delegate;
        }

        @NotNull
        public PsiSubstitutor getSubstitutor() {
            return this.myDelegate.getSubstitutor();
        }

        public boolean isValidResult() {
            return this.myDelegate.isValidResult();
        }

        public boolean isAccessible() {
            return this.myDelegate.isAccessible();
        }

        public boolean isStaticsScopeCorrect() {
            return this.myDelegate.isStaticsScopeCorrect();
        }

        public PsiElement getCurrentFileResolveScope() {
            return this.myDelegate.getCurrentFileResolveScope();
        }

        public boolean isPackagePrefixPackageReference() {
            return this.myDelegate.isPackagePrefixPackageReference();
        }

        public PsiClass getElement() {
            PsiElement element = this.myDelegate.getElement();
            return element instanceof PsiClass ? (PsiClass)element : null;
        }
    }
}

