/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.Language;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.IntentionFilterOwner;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.testFramework.LightVirtualFile;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiCodeFragmentImpl
extends PsiFileImpl
implements JavaCodeFragment,
IntentionFilterOwner {
    private final PsiElement myContext;
    private boolean myPhysical;
    private PsiType myThisType;
    private PsiType mySuperType;
    private LinkedHashMap<String, String> myPseudoImports = new LinkedHashMap();
    private JavaCodeFragment.VisibilityChecker myVisibilityChecker;
    private JavaCodeFragment.ExceptionHandler myExceptionHandler;
    private GlobalSearchScope myResolveScope;
    private IntentionFilterOwner.IntentionActionsFilter myIntentionActionsFilter;
    private FileViewProvider myViewProvider;

    public PsiCodeFragmentImpl(Project project2, IElementType contentElementType, boolean isPhysical, @NonNls String name, CharSequence text, @Nullable PsiElement context) {
        super(TokenType.CODE_FRAGMENT, contentElementType, PsiManagerEx.getInstanceEx(project2).getFileManager().createFileViewProvider((VirtualFile)new LightVirtualFile(name, FileTypeManager.getInstance().getFileTypeByFileName(name), text), isPhysical));
        this.myContext = context;
        ((SingleRootFileViewProvider)this.getViewProvider()).forceCachedPsi(this);
        this.myPhysical = isPhysical;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        return this.getContentElementType().getLanguage();
    }

    @Override
    protected PsiCodeFragmentImpl clone() {
        PsiCodeFragmentImpl clone = (PsiCodeFragmentImpl)this.cloneImpl((FileElement)this.calcTreeElement().clone());
        clone.myPhysical = false;
        clone.myOriginalFile = this;
        clone.myPseudoImports = new LinkedHashMap<String, String>(this.myPseudoImports);
        FileManager fileManager = ((PsiManagerEx)this.getManager()).getFileManager();
        SingleRootFileViewProvider cloneViewProvider = (SingleRootFileViewProvider)fileManager.createFileViewProvider((VirtualFile)new LightVirtualFile(this.getName(), this.getLanguage(), (CharSequence)this.getText()), false);
        cloneViewProvider.forceCachedPsi(clone);
        clone.myViewProvider = cloneViewProvider;
        return clone;
    }

    @Override
    @NotNull
    public FileViewProvider getViewProvider() {
        if (this.myViewProvider != null) {
            return this.myViewProvider;
        }
        return super.getViewProvider();
    }

    @NotNull
    public FileType getFileType() {
        return StdFileTypes.JAVA;
    }

    @Override
    public PsiElement getContext() {
        return this.myContext != null && this.myContext.isValid() ? this.myContext : super.getContext();
    }

    public PsiType getThisType() {
        return this.myThisType;
    }

    public void setThisType(PsiType psiType) {
        this.myThisType = psiType;
    }

    public PsiType getSuperType() {
        return this.mySuperType;
    }

    public void setSuperType(PsiType superType) {
        this.mySuperType = superType;
    }

    public String importsToString() {
        return StringUtil.join(this.myPseudoImports.values(), (String)",");
    }

    public void addImportsFromString(String imports2) {
        StringTokenizer tokenizer = new StringTokenizer(imports2, ",");
        while (tokenizer.hasMoreTokens()) {
            String qName = tokenizer.nextToken();
            String name = PsiNameHelper.getShortClassName((String)qName);
            this.myPseudoImports.put(name, qName);
        }
    }

    public void setVisibilityChecker(JavaCodeFragment.VisibilityChecker checker) {
        this.myVisibilityChecker = checker;
    }

    public JavaCodeFragment.VisibilityChecker getVisibilityChecker() {
        return this.myVisibilityChecker;
    }

    @Override
    public boolean isPhysical() {
        return this.myPhysical;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitCodeFragment((JavaCodeFragment)this);
        } else {
            visitor.visitFile((PsiFile)this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        IElementType i2;
        ElementClassHint classHint = (ElementClassHint)processor2.getHint(ElementClassHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            String name;
            NameHint nameHint = (NameHint)processor2.getHint(NameHint.KEY);
            String string = name = nameHint != null ? nameHint.getName(state) : null;
            if (name != null) {
                PsiClass imported;
                String qNameImported = this.myPseudoImports.get(name);
                if (qNameImported != null && (imported = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findClass(qNameImported, this.getResolveScope())) != null && !processor2.execute((PsiElement)imported, state)) {
                    return false;
                }
            } else {
                for (String qNameImported : this.myPseudoImports.values()) {
                    PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findClass(qNameImported, this.getResolveScope());
                    if (aClass == null || processor2.execute((PsiElement)aClass, state)) continue;
                    return false;
                }
            }
            if (this.myContext == null) {
                return JavaResolveUtil.processImplicitlyImportedPackages(processor2, state, place, this.getManager());
            }
        }
        if ((i2 = this.myContentElementType) == JavaElementType.TYPE_WITH_CONJUNCTIONS_TEXT || i2 == JavaElementType.TYPE_WITH_DISJUNCTIONS_TEXT || i2 == JavaElementType.EXPRESSION_STATEMENT || i2 == JavaElementType.REFERENCE_TEXT) {
            return true;
        }
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        if (lastParent == null) {
            return true;
        }
        return PsiScopesUtil.walkChildrenScopes((PsiElement)this, processor2, state, lastParent, place);
    }

    @Override
    public String toString() {
        return "PsiCodeFragment:" + this.getName();
    }

    public boolean importClass(PsiClass aClass) {
        String className = aClass.getName();
        String qName = aClass.getQualifiedName();
        if (qName == null) {
            return false;
        }
        this.myPseudoImports.put(className, qName);
        this.myManager.beforeChange(false);
        if (this.isPhysical()) {
            Project project2 = this.myManager.getProject();
            Document document = PsiDocumentManager.getInstance((Project)project2).getDocument((PsiFile)this);
            UndoManager.getInstance((Project)project2).undoableActionPerformed((UndoableAction)new ImportClassUndoableAction(className, qName, document, this.myPseudoImports));
        }
        return true;
    }

    public JavaCodeFragment.ExceptionHandler getExceptionHandler() {
        return this.myExceptionHandler;
    }

    public void setIntentionActionsFilter(@NotNull IntentionFilterOwner.IntentionActionsFilter filter) {
        this.myIntentionActionsFilter = filter;
    }

    public IntentionFilterOwner.IntentionActionsFilter getIntentionActionsFilter() {
        return this.myIntentionActionsFilter;
    }

    public void forceResolveScope(GlobalSearchScope scope) {
        this.myResolveScope = scope;
    }

    public GlobalSearchScope getForcedResolveScope() {
        return this.myResolveScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        if (this.myResolveScope != null) {
            return this.myResolveScope;
        }
        return super.getResolveScope();
    }

    public void setExceptionHandler(JavaCodeFragment.ExceptionHandler exceptionHandler) {
        this.myExceptionHandler = exceptionHandler;
    }

    private static class ImportClassUndoableAction
    extends BasicUndoableAction {
        private final String myClassName;
        private final String myQName;
        private final LinkedHashMap<String, String> myPseudoImports;

        public ImportClassUndoableAction(String className, String qName, Document document, LinkedHashMap<String, String> pseudoImportsMap) {
            super(new Document[]{document});
            this.myClassName = className;
            this.myQName = qName;
            this.myPseudoImports = pseudoImportsMap;
        }

        public void undo() {
            this.myPseudoImports.remove(this.myClassName);
        }

        public void redo() {
            this.myPseudoImports.put(this.myClassName, this.myQName);
        }
    }
}

