/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotatedJavaCodeReferenceElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ConstructorFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.element.ModifierFilter;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.impl.source.SourceJavaCodeReference;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.VariableResolverProcessor;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ICodeFragmentElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiJavaCodeReferenceElementImpl
extends CompositePsiElement
implements PsiAnnotatedJavaCodeReferenceElement,
SourceJavaCodeReference {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl");
    private volatile String myCachedQName;
    private volatile String myCachedNormalizedText;
    private volatile int myKindWhenDummy = 1;
    public static final int CLASS_NAME_KIND = 1;
    public static final int PACKAGE_NAME_KIND = 2;
    public static final int CLASS_OR_PACKAGE_NAME_KIND = 3;
    public static final int CLASS_FQ_NAME_KIND = 4;
    public static final int CLASS_FQ_OR_PACKAGE_NAME_KIND = 5;
    public static final int CLASS_IN_QUALIFIED_NEW_KIND = 6;
    private final int myHC = ourHC++;

    public PsiJavaCodeReferenceElementImpl() {
        super(JavaElementType.JAVA_CODE_REFERENCE);
    }

    public final int hashCode() {
        return this.myHC;
    }

    @Override
    public int getTextOffset() {
        ASTNode refName = this.getReferenceNameNode();
        return refName != null ? refName.getStartOffset() : super.getTextOffset();
    }

    public void setKindWhenDummy(int kind2) {
        LOG.assertTrue(PsiJavaCodeReferenceElementImpl.isDummy(this.getTreeParent().getElementType()));
        this.myKindWhenDummy = kind2;
    }

    private static boolean isDummy(IElementType type2) {
        return type2 == TokenType.DUMMY_HOLDER || type2 == JavaElementType.DUMMY_ELEMENT;
    }

    public int getKind(@NotNull PsiFile containingFile) {
        CompositeElement treeParent;
        IElementType i;
        if (!containingFile.isValid()) {
            PsiUtilCore.ensureValid((PsiElement)this);
        }
        if (PsiJavaCodeReferenceElementImpl.isDummy(i = (treeParent = this.getTreeParent()).getElementType())) {
            return this.myKindWhenDummy;
        }
        if (i == JavaElementType.TYPE) {
            return treeParent.getTreeParent().getPsi() instanceof PsiTypeCodeFragment ? 3 : 1;
        }
        if (i == JavaElementType.EXTENDS_LIST || i == JavaElementType.IMPLEMENTS_LIST || i == JavaElementType.EXTENDS_BOUND_LIST || i == JavaElementType.THROWS_LIST || i == JavaElementType.THIS_EXPRESSION || i == JavaElementType.SUPER_EXPRESSION || i == JavaDocElementType.DOC_METHOD_OR_FIELD_REF || i == JavaDocElementType.DOC_TAG_VALUE_ELEMENT || i == JavaElementType.REFERENCE_PARAMETER_LIST || i == JavaElementType.ANNOTATION) {
            if (this.isQualified()) {
                return 3;
            }
            return 1;
        }
        if (i == JavaElementType.NEW_EXPRESSION) {
            ASTNode qualifier = treeParent.findChildByRole(54);
            return qualifier != null ? 6 : 1;
        }
        if (i == JavaElementType.ANONYMOUS_CLASS) {
            if (treeParent.getChildRole(this) == 78) {
                LOG.assertTrue(treeParent.getTreeParent().getElementType() == JavaElementType.NEW_EXPRESSION);
                ASTNode qualifier = treeParent.getTreeParent().findChildByRole(54);
                return qualifier != null ? 6 : 1;
            }
            return 3;
        }
        if (i == JavaElementType.PACKAGE_STATEMENT || i == JavaElementType.EXPORTS_STATEMENT || i == JavaElementType.OPENS_STATEMENT) {
            return 2;
        }
        if (i == JavaElementType.IMPORT_STATEMENT) {
            boolean isOnDemand = ((PsiImportStatement)SourceTreeToPsiMap.treeToPsiNotNull(treeParent)).isOnDemand();
            return isOnDemand ? 5 : 4;
        }
        if (i == JavaElementType.IMPORT_STATIC_STATEMENT) {
            return 5;
        }
        if (i == JavaElementType.JAVA_CODE_REFERENCE) {
            int parentKind = ((PsiJavaCodeReferenceElementImpl)treeParent).getKind(containingFile);
            if (parentKind == 1) {
                return 3;
            }
            if (parentKind == 4) {
                return 5;
            }
            return parentKind;
        }
        if (i == JavaElementType.CLASS || i == JavaElementType.PARAMETER_LIST || i == TokenType.ERROR_ELEMENT) {
            return 3;
        }
        if (i == JavaElementType.IMPORT_STATIC_REFERENCE) {
            return 5;
        }
        if (i == JavaDocElementType.DOC_TAG || i == JavaDocElementType.DOC_INLINE_TAG || i == JavaDocElementType.DOC_REFERENCE_HOLDER || i == JavaDocElementType.DOC_TYPE_HOLDER) {
            PsiDocComment docComment = (PsiDocComment)PsiTreeUtil.getParentOfType((PsiElement)this, PsiDocComment.class);
            if (JavaDocUtil.isInsidePackageInfo(docComment)) {
                return 5;
            }
            return 3;
        }
        if (PsiJavaCodeReferenceElementImpl.isCodeFragmentType(i)) {
            PsiJavaCodeReferenceCodeFragment fragment = (PsiJavaCodeReferenceCodeFragment)treeParent.getPsi();
            return fragment.isClassesAccepted() ? 5 : 2;
        }
        if (i == JavaElementType.USES_STATEMENT || i == JavaElementType.PROVIDES_STATEMENT || i == JavaElementType.PROVIDES_WITH_LIST) {
            return 1;
        }
        this.diagnoseUnknownParent();
        return 1;
    }

    private void diagnoseUnknownParent() {
        CompositeElement parent;
        IElementType i = parent.getElementType();
        String message2 = "Unknown parent for java code reference: '" + parent + "'; Type: " + i + ";\n";
        for (parent = this.getTreeParent(); parent != null && parent.getPsi() instanceof PsiExpression; parent = parent.getTreeParent()) {
            message2 = message2 + " Parent: '" + parent + "'; \n";
        }
        if (parent != null) {
            message2 = message2 + DebugUtil.treeToString(parent, false);
        }
        LOG.error(message2);
    }

    private static boolean isCodeFragmentType(IElementType type2) {
        return type2 == TokenType.CODE_FRAGMENT || type2 instanceof ICodeFragmentElementType;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (this.getChildRole(child) == 54) {
            ASTNode dot = this.findChildByType(JavaTokenType.DOT, child);
            assert (dot != null) : this;
            this.deleteChildRange(child.getPsi(), dot.getPsi());
            PsiModifierList modifierList = PsiImplUtil.findNeighbourModifierList((PsiJavaCodeReferenceElement)this);
            if (modifierList != null) {
                ASTNode ref = this.findChildByRole(53);
                assert (ref != null) : this;
                PsiElement lastChild = ref.getPsi().getPrevSibling();
                if (lastChild != null) {
                    modifierList.addRange(this.getFirstChild(), lastChild);
                    this.deleteChildRange(this.getFirstChild(), lastChild);
                }
            }
            return;
        }
        super.deleteChildInternal(child);
    }

    @Override
    public final ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 53: {
                return TreeUtil.findChildBackward(this, JavaTokenType.IDENTIFIER);
            }
            case 246: {
                TreeElement lastChild = this.getLastChildNode();
                return lastChild.getElementType() == JavaElementType.REFERENCE_PARAMETER_LIST ? lastChild : null;
            }
            case 54: {
                return this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
            }
            case 55: {
                return this.findChildByType(JavaTokenType.DOT);
            }
        }
        return null;
    }

    @Override
    public final int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaElementType.REFERENCE_PARAMETER_LIST) {
            return 246;
        }
        if (i == JavaElementType.JAVA_CODE_REFERENCE) {
            return 54;
        }
        if (i == JavaTokenType.DOT) {
            return 55;
        }
        if (i == JavaTokenType.IDENTIFIER) {
            return 53;
        }
        return 0;
    }

    @NotNull
    public String getCanonicalText() {
        return this.getCanonicalText(false, null, this.getContainingFile());
    }

    @NotNull
    public String getCanonicalText(boolean annotated, @Nullable PsiAnnotation[] annotations2) {
        return this.getCanonicalText(annotated, annotations2, this.getContainingFile());
    }

    @NotNull
    private String getCanonicalText(boolean annotated, @Nullable PsiAnnotation[] annotations2, @NotNull PsiFile containingFile) {
        switch (this.getKind(containingFile)) {
            case 1: 
            case 3: 
            case 6: {
                PsiElement target;
                JavaResolveResult[] results = PsiImplUtil.multiResolveImpl(containingFile.getProject(), containingFile, this, false, OurGenericsResolver.INSTANCE);
                PsiElement psiElement = target = results.length == 1 ? results[0].getElement() : null;
                if (target instanceof PsiClass) {
                    StringBuilder buffer = new StringBuilder();
                    PsiClass aClass = (PsiClass)target;
                    PsiElement qualifier = this.getQualifier();
                    String prefix = null;
                    if (qualifier instanceof PsiJavaCodeReferenceElementImpl) {
                        prefix = ((PsiJavaCodeReferenceElementImpl)qualifier).getCanonicalText(annotated, annotations2, containingFile);
                        annotations2 = null;
                    } else {
                        String fqn = aClass.getQualifiedName();
                        if (fqn != null) {
                            prefix = StringUtil.getPackageName((String)fqn);
                        }
                    }
                    if (!StringUtil.isEmpty((String)prefix)) {
                        buffer.append(prefix);
                        buffer.append('.');
                    }
                    if (annotated) {
                        List<PsiAnnotation> list = annotations2 != null ? Arrays.asList(annotations2) : this.getAnnotations();
                        PsiNameHelper.appendAnnotations((StringBuilder)buffer, list, (boolean)true);
                    }
                    buffer.append(aClass.getName());
                    PsiNameHelper.appendTypeArgs((StringBuilder)buffer, (PsiType[])this.getTypeParameters(), (boolean)true, (boolean)annotated);
                    return buffer.toString();
                }
                if (target instanceof PsiPackage) {
                    return ((PsiPackage)target).getQualifiedName();
                }
                LOG.assertTrue(target == null, (Object)target);
                return this.getNormalizedText();
            }
            case 2: 
            case 4: 
            case 5: {
                return this.getNormalizedText();
            }
        }
        LOG.assertTrue(false);
        return null;
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    public final PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        return results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
    }

    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        return PsiImplUtil.multiResolveImpl(this, incompleteCode, OurGenericsResolver.INSTANCE);
    }

    private PsiSubstitutor updateSubstitutor(PsiSubstitutor subst, PsiClass psiClass) {
        PsiType[] parameters2 = this.getTypeParameters();
        if (psiClass != null) {
            subst = subst.putAll(psiClass, parameters2);
        }
        return subst;
    }

    @NotNull
    private JavaResolveResult[] resolve(int kind2, @NotNull PsiFile containingFile) {
        switch (kind2) {
            case 4: {
                String text = this.getNormalizedText();
                if (StringUtil.isEmptyOrSpaces((String)text)) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                PsiClass aClass = JavaPsiFacade.getInstance((Project)containingFile.getProject()).findClass(text, this.getResolveScope());
                if (aClass == null) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                if (!this.isQualified() && text.equals(aClass.getQualifiedName()) && containingFile instanceof PsiJavaFile && !((PsiJavaFile)containingFile).getPackageName().isEmpty()) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                return new JavaResolveResult[]{new CandidateInfo((PsiElement)aClass, this.updateSubstitutor(PsiSubstitutor.EMPTY, aClass), (PsiElement)this, false)};
            }
            case 6: {
                PsiElement parent = this.getParent();
                if (parent instanceof JavaDummyHolder) {
                    parent = parent.getContext();
                }
                if (parent instanceof PsiAnonymousClass) {
                    parent = parent.getParent();
                }
                if (!(parent instanceof PsiNewExpression)) {
                    if (parent instanceof PsiJavaCodeReferenceElement) {
                        return JavaResolveResult.EMPTY_ARRAY;
                    }
                    LOG.error("Invalid java reference!");
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                PsiExpression qualifier = ((PsiNewExpression)parent).getQualifier();
                LOG.assertTrue(qualifier != null);
                PsiType qualifierType = qualifier.getType();
                if (qualifierType == null) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                if (!(qualifierType instanceof PsiClassType)) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                PsiClassType.ClassResolveResult result2 = PsiUtil.resolveGenericsClassInType((PsiType)qualifierType);
                PsiElement resultElement = result2.getElement();
                if (resultElement == null) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                PsiElement classNameElement = this.getReferenceNameElement();
                if (!(classNameElement instanceof PsiIdentifier)) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                String className = classNameElement.getText();
                ClassResolverProcessor processor2 = new ClassResolverProcessor(className, this, containingFile);
                resultElement.processDeclarations((PsiScopeProcessor)processor2, ResolveState.initial().put(PsiSubstitutor.KEY, (Object)result2.getSubstitutor()), (PsiElement)this, (PsiElement)this);
                return processor2.getResult();
            }
            case 1: {
                PsiElement classNameElement = this.getReferenceNameElement();
                if (!(classNameElement instanceof PsiIdentifier)) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                String className = classNameElement.getText();
                ClassResolverProcessor processor3 = new ClassResolverProcessor(className, this, containingFile);
                PsiScopesUtil.resolveAndWalk(processor3, (PsiJavaCodeReferenceElement)this, null);
                return processor3.getResult();
            }
            case 2: {
                String packageName = this.getNormalizedText();
                Project project2 = this.getManager().getProject();
                PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project2).findPackage(packageName);
                if (aPackage == null || !aPackage.isValid()) {
                    return JavaPsiFacade.getInstance((Project)project2).isPartOfPackagePrefix(packageName) ? CandidateInfo.RESOLVE_RESULT_FOR_PACKAGE_PREFIX_PACKAGE : JavaResolveResult.EMPTY_ARRAY;
                }
                return new JavaResolveResult[]{new CandidateInfo((PsiElement)aPackage, PsiSubstitutor.EMPTY)};
            }
            case 3: 
            case 5: {
                int classKind;
                int n = classKind = kind2 == 3 ? 1 : 4;
                if (PsiTreeUtil.getParentOfType((PsiElement)this, PsiImportStatement.class) != null) {
                    JavaResolveResult[] result3 = this.resolve(2, containingFile);
                    return result3.length == 0 ? this.resolve(classKind, containingFile) : result3;
                }
                JavaResolveResult[] result4 = this.resolve(classKind, containingFile);
                if (result4.length == 1 && !result4[0].isAccessible()) {
                    JavaResolveResult[] packageResult = this.resolve(2, containingFile);
                    if (packageResult.length != 0) {
                        result4 = packageResult;
                    }
                } else if (result4.length == 0) {
                    result4 = this.resolve(2, containingFile);
                }
                return result4;
            }
        }
        LOG.error((Object)this);
        return JavaResolveResult.EMPTY_ARRAY;
    }

    public final PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        PsiElement oldIdentifier = this.getReferenceNameElement();
        if (oldIdentifier == null) {
            throw new IncorrectOperationException();
        }
        PsiIdentifier identifier = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createIdentifier(newElementName);
        oldIdentifier.replace((PsiElement)identifier);
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiFile containingFile = this.getContainingFile();
        CheckUtil.checkWritable((PsiElement)containingFile);
        if (this.isReferenceTo(element)) {
            return this;
        }
        switch (this.getKind(containingFile)) {
            case 1: 
            case 4: {
                if (!(element instanceof PsiClass)) {
                    throw PsiJavaCodeReferenceElementImpl.cannotBindError(element);
                }
                return this.bindToClass((PsiClass)element, containingFile);
            }
            case 2: {
                if (!(element instanceof PsiPackage)) {
                    throw PsiJavaCodeReferenceElementImpl.cannotBindError(element);
                }
                return this.bindToPackage((PsiPackage)element);
            }
            case 3: 
            case 5: {
                if (element instanceof PsiClass) {
                    return this.bindToClass((PsiClass)element, containingFile);
                }
                if (element instanceof PsiPackage) {
                    return this.bindToPackage((PsiPackage)element);
                }
                throw PsiJavaCodeReferenceElementImpl.cannotBindError(element);
            }
            case 6: {
                if (element instanceof PsiClass) {
                    PsiClass aClass = (PsiClass)element;
                    String name = aClass.getName();
                    if (name == null) {
                        throw new IncorrectOperationException(aClass.toString());
                    }
                    PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance((Project)containingFile.getProject()).getParserFacade();
                    PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(name, this.getParent());
                    this.getTreeParent().replaceChildInternal(this, (TreeElement)ref.getNode());
                    return ref;
                }
                throw PsiJavaCodeReferenceElementImpl.cannotBindError(element);
            }
        }
        LOG.assertTrue(false);
        return null;
    }

    private static IncorrectOperationException cannotBindError(PsiElement element) {
        return new IncorrectOperationException("Cannot bind to " + element);
    }

    private PsiElement bindToClass(@NotNull PsiClass aClass, @NotNull PsiFile containingFile) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement ref;
        String qName = aClass.getQualifiedName();
        Project project2 = containingFile.getProject();
        boolean preserveQualification = JavaCodeStyleSettingsFacade.getInstance((Project)project2).useFQClassNames() && this.isFullyQualified(containingFile);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
        if (qName == null) {
            qName = aClass.getName();
            assert (qName != null) : aClass;
            PsiClass psiClass = facade.getResolveHelper().resolveReferencedClass(qName, (PsiElement)this);
            if (!this.getManager().areElementsEquivalent((PsiElement)psiClass, (PsiElement)aClass)) {
                throw PsiJavaCodeReferenceElementImpl.cannotBindError((PsiElement)aClass);
            }
        } else if (facade.findClass(qName, this.getResolveScope()) == null && !preserveQualification) {
            return this;
        }
        String text = qName;
        PsiReferenceParameterList parameterList = this.getParameterList();
        if (parameterList != null) {
            text = text + parameterList.getText();
        }
        try {
            ref = facade.getParserFacade().createReferenceFromText(text, this.getParent());
        }
        catch (IncorrectOperationException e) {
            throw new IncorrectOperationException(e.getMessage() + " [qname=" + qName + " class=" + aClass + ";" + aClass.getClass().getName() + "]");
        }
        this.getTreeParent().replaceChildInternal(this, (TreeElement)ref.getNode());
        if (!preserveQualification) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
            ref = (PsiJavaCodeReferenceElement)codeStyleManager.shortenClassReferences((PsiElement)ref, 8192);
        }
        return ref;
    }

    private List<PsiAnnotation> getAnnotations() {
        PsiModifierList modifierList;
        List annotations2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, PsiAnnotation.class);
        if (!this.isQualified() && (modifierList = PsiImplUtil.findNeighbourModifierList((PsiJavaCodeReferenceElement)this)) != null) {
            PsiImplUtil.collectTypeUseAnnotations(modifierList, annotations2);
        }
        return annotations2;
    }

    private boolean isFullyQualified(@NotNull PsiFile containingFile) {
        ASTNode qualifier;
        int kind2 = this.getKind(containingFile);
        switch (kind2) {
            case 3: {
                if (!(this.resolve() instanceof PsiPackage)) break;
                return true;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                return true;
            }
            default: {
                LOG.error((Object)kind2);
                return true;
            }
        }
        if ((qualifier = this.findChildByRole(54)) == null) {
            return false;
        }
        LOG.assertTrue(qualifier.getElementType() == JavaElementType.JAVA_CODE_REFERENCE);
        PsiElement refElement = ((PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeToPsiNotNull(qualifier)).resolve();
        if (refElement instanceof PsiPackage) {
            return true;
        }
        return ((PsiJavaCodeReferenceElementImpl)SourceTreeToPsiMap.treeToPsiNotNull(qualifier)).isFullyQualified(containingFile);
    }

    private PsiElement bindToPackage(@NotNull PsiPackage aPackage) throws IncorrectOperationException {
        String qName = aPackage.getQualifiedName();
        if (qName.isEmpty()) {
            throw new IncorrectOperationException("Cannot bind to default package: " + aPackage);
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance((Project)this.getProject()).getParserFacade();
        PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(qName, this.getParent());
        this.getTreeParent().replaceChildInternal(this, (TreeElement)ref.getNode());
        return ref;
    }

    public boolean isReferenceTo(PsiElement element) {
        PsiFile containingFile = this.getContainingFile();
        return this.isReferenceTo(element, containingFile);
    }

    private boolean isReferenceTo(PsiElement element, @NotNull PsiFile containingFile) {
        switch (this.getKind(containingFile)) {
            case 1: 
            case 6: {
                if (element instanceof PsiClass) break;
                return false;
            }
            case 4: {
                if (!(element instanceof PsiClass)) {
                    return false;
                }
                String qName = ((PsiClass)element).getQualifiedName();
                return qName != null && qName.equals(this.getCanonicalText(false, null, containingFile));
            }
            case 2: {
                if (!(element instanceof PsiPackage)) {
                    return false;
                }
                String qName = ((PsiPackage)element).getQualifiedName();
                return qName.equals(this.getCanonicalText(false, null, containingFile));
            }
            case 3: {
                if (element instanceof PsiPackage) {
                    String qName = ((PsiPackage)element).getQualifiedName();
                    return qName.equals(this.getCanonicalText(false, null, containingFile));
                }
                if (element instanceof PsiClass) {
                    PsiIdentifier nameIdentifier = ((PsiClass)element).getNameIdentifier();
                    if (nameIdentifier == null) {
                        return false;
                    }
                    PsiElement nameElement = this.getReferenceNameElement();
                    return nameElement != null && nameElement.textMatches((PsiElement)nameIdentifier) && containingFile.getManager().areElementsEquivalent(this.resolve(), element);
                }
                return false;
            }
            case 5: {
                String qName;
                if (element instanceof PsiClass && (qName = ((PsiClass)element).getQualifiedName()) != null && qName.equals(this.getCanonicalText(false, null, containingFile))) {
                    return !PsiUtil.isFromDefaultPackage((PsiClass)((PsiClass)element)) || PsiTreeUtil.getParentOfType((PsiElement)this, PsiImportStatementBase.class) == null;
                }
                if (element instanceof PsiPackage) {
                    qName = ((PsiPackage)element).getQualifiedName();
                    return qName.equals(this.getCanonicalText(false, null, containingFile));
                }
                return false;
            }
            default: {
                LOG.assertTrue(false);
                return true;
            }
        }
        ASTNode referenceNameElement = this.getReferenceNameNode();
        if (referenceNameElement == null || referenceNameElement.getElementType() != JavaTokenType.IDENTIFIER) {
            return false;
        }
        String name = ((PsiClass)element).getName();
        return name != null && referenceNameElement.getText().equals(name) && containingFile.getManager().areElementsEquivalent(this.resolve(), element);
    }

    private String getNormalizedText() {
        String whiteSpaceAndComments = this.myCachedNormalizedText;
        if (whiteSpaceAndComments == null) {
            this.myCachedNormalizedText = whiteSpaceAndComments = JavaSourceUtil.getReferenceText((PsiJavaCodeReferenceElement)this);
        }
        return whiteSpaceAndComments;
    }

    @Override
    public String getClassNameText() {
        String cachedQName = this.myCachedQName;
        if (cachedQName == null) {
            this.myCachedQName = cachedQName = PsiNameHelper.getQualifiedClassName((String)this.getNormalizedText(), (boolean)false);
        }
        return cachedQName;
    }

    @Override
    public void fullyQualify(@NotNull PsiClass targetClass) {
        int kind2 = this.getKind(this.getContainingFile());
        if (kind2 != 1 && kind2 != 3 && kind2 != 6) {
            LOG.error("Wrong kind " + kind2);
            return;
        }
        JavaSourceUtil.fullyQualifyReference(this, targetClass);
    }

    @Override
    public boolean isQualified() {
        return this.getQualifier() != null;
    }

    @Override
    public PsiElement getQualifier() {
        return SourceTreeToPsiMap.treeElementToPsi(this.findChildByRole(54));
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedQName = null;
        this.myCachedNormalizedText = null;
    }

    @NotNull
    public Object[] getVariants() {
        Object filter;
        switch (this.getKind(this.getContainingFile())) {
            case 3: {
                filter = new OrFilter();
                ((OrFilter)filter).addFilter(ElementClassFilter.CLASS);
                ((OrFilter)filter).addFilter(ElementClassFilter.PACKAGE_FILTER);
                break;
            }
            case 1: {
                filter = ElementClassFilter.CLASS;
                break;
            }
            case 2: {
                filter = ElementClassFilter.PACKAGE_FILTER;
                break;
            }
            case 4: 
            case 5: {
                filter = new OrFilter();
                ((OrFilter)filter).addFilter(ElementClassFilter.PACKAGE_FILTER);
                if (!this.isQualified()) break;
                ((OrFilter)filter).addFilter(ElementClassFilter.CLASS);
                break;
            }
            case 6: {
                filter = ElementClassFilter.CLASS;
                break;
            }
            default: {
                throw new RuntimeException("Unknown reference type");
            }
        }
        return PsiImplUtil.getReferenceVariantsByFilter((PsiJavaCodeReferenceElement)this, filter);
    }

    public boolean isSoft() {
        return false;
    }

    public void processVariants(@NotNull PsiScopeProcessor processor2) {
        OrFilter filter = new OrFilter();
        if (this.isInCode() && !(this.getParent() instanceof PsiImportStatement) && !(this.getParent() instanceof PsiReferenceList)) {
            filter.addFilter(new AndFilter((ElementFilter)ElementClassFilter.METHOD, (ElementFilter)new NotFilter(new ConstructorFilter())));
            filter.addFilter(ElementClassFilter.VARIABLE);
        }
        switch (this.getKind(this.getContainingFile())) {
            case 3: {
                filter.addFilter(ElementClassFilter.CLASS);
                filter.addFilter(ElementClassFilter.PACKAGE_FILTER);
                break;
            }
            case 1: {
                filter.addFilter(ElementClassFilter.CLASS);
                if (!this.isQualified()) break;
                filter.addFilter(ElementClassFilter.PACKAGE_FILTER);
                break;
            }
            case 2: {
                filter.addFilter(ElementClassFilter.PACKAGE_FILTER);
                break;
            }
            case 4: 
            case 5: {
                filter.addFilter(ElementClassFilter.PACKAGE_FILTER);
                if (!this.isQualified()) break;
                filter.addFilter(ElementClassFilter.CLASS);
                break;
            }
            case 6: {
                PsiElement parent = this.getParent();
                if (parent instanceof PsiNewExpression) {
                    PsiExpression qualifier = ((PsiNewExpression)parent).getQualifier();
                    assert (qualifier != null) : parent;
                    PsiType type2 = qualifier.getType();
                    PsiClass aClass = PsiUtil.resolveClassInType((PsiType)type2);
                    if (aClass != null) {
                        aClass.processDeclarations(new FilterScopeProcessor((ElementFilter)new AndFilter((ElementFilter)ElementClassFilter.CLASS, (ElementFilter)new ModifierFilter("static", false)), processor2), ResolveState.initial(), null, (PsiElement)this);
                    }
                }
                return;
            }
            default: {
                throw new RuntimeException("Unknown reference type");
            }
        }
        FilterScopeProcessor proc = new FilterScopeProcessor((ElementFilter)filter, processor2);
        PsiScopesUtil.resolveAndWalk(proc, (PsiJavaCodeReferenceElement)this, null, true);
    }

    private boolean isInCode() {
        if (PsiJavaCodeReferenceElementImpl.isCodeFragmentType(this.getTreeParent().getElementType()) || this.getParent() instanceof PsiAnnotation) {
            return false;
        }
        for (PsiElement superParent = this.getParent(); superParent != null; superParent = superParent.getParent()) {
            if (superParent instanceof PsiCodeBlock || superParent instanceof PsiLocalVariable) {
                return true;
            }
            if (!(superParent instanceof PsiClass) && !(superParent instanceof PsiCatchSection)) continue;
            return false;
        }
        return false;
    }

    public PsiElement getReferenceNameElement() {
        return SourceTreeToPsiMap.treeElementToPsi(this.getReferenceNameNode());
    }

    @Nullable
    private ASTNode getReferenceNameNode() {
        return this.findChildByRole(53);
    }

    public PsiReferenceParameterList getParameterList() {
        return (PsiReferenceParameterList)this.findChildByRoleAsPsiElement(246);
    }

    public String getQualifiedName() {
        switch (this.getKind(this.getContainingFile())) {
            case 1: 
            case 3: 
            case 6: {
                PsiElement target = this.resolve();
                if (target instanceof PsiClass) {
                    PsiClass aClass = (PsiClass)target;
                    String name = aClass.getQualifiedName();
                    if (name == null) {
                        name = aClass.getName();
                    }
                    return name;
                }
                if (target instanceof PsiPackage) {
                    return ((PsiPackage)target).getQualifiedName();
                }
                LOG.assertTrue(target == null);
                return this.getClassNameText();
            }
            case 2: 
            case 4: 
            case 5: {
                return this.getNormalizedText();
            }
        }
        LOG.assertTrue(false);
        return null;
    }

    public String getReferenceName() {
        ASTNode childByRole = this.getReferenceNameNode();
        if (childByRole == null) {
            return null;
        }
        return childByRole.getText();
    }

    public final TextRange getRangeInElement() {
        TreeElement nameChild = (TreeElement)this.getReferenceNameNode();
        if (nameChild == null) {
            return new TextRange(0, this.getTextLength());
        }
        int startOffset = nameChild.getStartOffsetInParent();
        return new TextRange(startOffset, startOffset + nameChild.getTextLength());
    }

    @NotNull
    public PsiType[] getTypeParameters() {
        PsiReferenceParameterList parameterList = this.getParameterList();
        if (parameterList == null) {
            return PsiType.EMPTY_ARRAY;
        }
        return parameterList.getTypeArguments();
    }

    public final PsiElement getElement() {
        return this;
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceElement((PsiJavaCodeReferenceElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public final String toString() {
        return "PsiJavaCodeReferenceElement:" + this.getText();
    }

    private static final class OurGenericsResolver
    implements ResolveCache.PolyVariantContextResolver<PsiJavaReference> {
        private static final OurGenericsResolver INSTANCE = new OurGenericsResolver();

        private OurGenericsResolver() {
        }

        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull PsiJavaReference ref, @NotNull PsiFile containingFile, boolean incompleteCode) {
            PsiJavaCodeReferenceElementImpl referenceElement = (PsiJavaCodeReferenceElementImpl)ref;
            int kind2 = referenceElement.getKind(containingFile);
            JavaResolveResult[] result2 = referenceElement.resolve(kind2, containingFile);
            if (incompleteCode && result2.length == 0 && kind2 != 4 && kind2 != 5) {
                VariableResolverProcessor processor2 = new VariableResolverProcessor((PsiJavaCodeReferenceElement)referenceElement, containingFile);
                PsiScopesUtil.resolveAndWalk(processor2, (PsiJavaCodeReferenceElement)referenceElement, null, true);
                result2 = processor2.getResult();
                if (result2.length == 0 && kind2 == 1) {
                    result2 = referenceElement.resolve(2, containingFile);
                }
            }
            JavaResolveUtil.substituteResults((PsiJavaCodeReferenceElement)referenceElement, result2);
            return result2;
        }
    }
}

