/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.impl.source.resolve.SymbolCollectingProcessor;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.indexing.IndexingDataKeys;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiJavaFileBaseImpl
extends PsiFileImpl
implements PsiJavaFile {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiJavaFileBaseImpl");
    private static final String[] IMPLICIT_IMPORTS = new String[]{"java.lang"};
    private final CachedValue<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> myResolveCache;
    private volatile String myPackageName;
    private static final NotNullLazyKey<LanguageLevel, PsiJavaFileBaseImpl> LANGUAGE_LEVEL_KEY = NotNullLazyKey.create((String)"LANGUAGE_LEVEL", file2 -> file2.getLanguageLevelInner());

    protected PsiJavaFileBaseImpl(IElementType elementType, IElementType contentElementType, FileViewProvider viewProvider) {
        super(elementType, contentElementType, viewProvider);
        this.myResolveCache = CachedValuesManager.getManager((Project)this.myManager.getProject()).createCachedValue((CachedValueProvider)new MyCacheBuilder(this), false);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myPackageName = null;
    }

    @NotNull
    public PsiClass[] getClasses() {
        StubElement stub = this.getGreenStub();
        if (stub != null) {
            return (PsiClass[])stub.getChildrenByType((IElementType)JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY);
        }
        return (PsiClass[])this.calcTreeElement().getChildrenAsPsiElements(Constants.CLASS_BIT_SET, PsiClass.ARRAY_FACTORY);
    }

    public PsiPackageStatement getPackageStatement() {
        ASTNode node = this.calcTreeElement().findChildByType(JavaElementType.PACKAGE_STATEMENT);
        return node != null ? (PsiPackageStatement)node.getPsi() : null;
    }

    @NotNull
    public String getPackageName() {
        PsiJavaFileStub stub = (PsiJavaFileStub)this.getGreenStub();
        if (stub != null) {
            return stub.getPackageName();
        }
        String name = this.myPackageName;
        if (name == null) {
            PsiPackageStatement statement2 = this.getPackageStatement();
            name = statement2 == null ? "" : statement2.getPackageName();
            this.myPackageName = name;
        }
        return name;
    }

    public void setPackageName(String packageName) throws IncorrectOperationException {
        if (PsiUtil.isModuleFile((PsiFile)this)) {
            throw new IncorrectOperationException("Cannot set package name for module declarations");
        }
        PsiPackageStatement packageStatement = this.getPackageStatement();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
        if (packageStatement != null) {
            if (!packageName.isEmpty()) {
                PsiJavaCodeReferenceElement reference = packageStatement.getPackageReference();
                reference.replace((PsiElement)factory.createReferenceFromText(packageName, (PsiElement)packageStatement));
            } else {
                packageStatement.delete();
            }
        } else if (!packageName.isEmpty()) {
            this.addBefore((PsiElement)factory.createPackageStatement(packageName), this.getFirstChild());
        }
    }

    public PsiImportList getImportList() {
        StubElement stub = this.getGreenStub();
        if (stub != null) {
            PsiImportList[] nodes = (PsiImportList[])stub.getChildrenByType((IElementType)JavaStubElementTypes.IMPORT_LIST, PsiImportList.ARRAY_FACTORY);
            if (nodes.length == 1) {
                return nodes[0];
            }
            if (nodes.length == 0) {
                return null;
            }
            this.reportStubAstMismatch(stub + "; " + stub.getChildrenStubs(), this.getStubTree());
        }
        ASTNode node = this.calcTreeElement().findChildByType(JavaElementType.IMPORT_LIST);
        return (PsiImportList)SourceTreeToPsiMap.treeElementToPsi(node);
    }

    @NotNull
    public PsiElement[] getOnDemandImports(boolean includeImplicit, boolean checkIncludes) {
        PsiImportStatement[] statements;
        PsiImportList importList = this.getImportList();
        if (importList == null) {
            return EMPTY_ARRAY;
        }
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        for (PsiImportStatement statement2 : statements = importList.getImportStatements()) {
            PsiElement resolved;
            if (!statement2.isOnDemand() || (resolved = statement2.resolve()) == null) continue;
            array.add(resolved);
        }
        if (includeImplicit) {
            PsiJavaCodeReferenceElement[] implicitRefs;
            for (PsiJavaCodeReferenceElement implicitRef : implicitRefs = this.getImplicitlyImportedPackageReferences()) {
                PsiElement resolved = implicitRef.resolve();
                if (resolved == null) continue;
                array.add(resolved);
            }
        }
        return PsiUtilCore.toPsiElementArray(array);
    }

    @NotNull
    public PsiClass[] getSingleClassImports(boolean checkIncludes) {
        PsiImportStatement[] statements;
        PsiImportList importList = this.getImportList();
        if (importList == null) {
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList<PsiClass> array = new ArrayList<PsiClass>();
        for (PsiImportStatement statement2 : statements = importList.getImportStatements()) {
            PsiElement ref;
            if (statement2.isOnDemand() || !((ref = statement2.resolve()) instanceof PsiClass)) continue;
            array.add((PsiClass)ref);
        }
        return array.toArray(new PsiClass[array.size()]);
    }

    public PsiJavaCodeReferenceElement findImportReferenceTo(PsiClass aClass) {
        PsiImportList importList = this.getImportList();
        if (importList != null) {
            PsiImportStatement[] statements;
            for (PsiImportStatement statement2 : statements = importList.getImportStatements()) {
                PsiElement ref;
                if (statement2.isOnDemand() || (ref = statement2.resolve()) == null || !this.getManager().areElementsEquivalent(ref, (PsiElement)aClass)) continue;
                return statement2.getImportReference();
            }
        }
        return null;
    }

    @NotNull
    public String[] getImplicitlyImportedPackages() {
        return IMPLICIT_IMPORTS;
    }

    @NotNull
    public PsiJavaCodeReferenceElement[] getImplicitlyImportedPackageReferences() {
        return PsiImplUtil.namesToPackageReferences(this.myManager, IMPLICIT_IMPORTS);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        assert (this.isValid());
        if (processor2 instanceof ClassResolverProcessor && this.isPhysical() && (this.getUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING) == Boolean.TRUE || this.myResolveCache.hasUpToDateValue())) {
            ClassResolverProcessor hint = (ClassResolverProcessor)processor2;
            String name = hint.getName(state);
            MostlySingularMultiMap cache2 = (MostlySingularMultiMap)this.myResolveCache.getValue();
            MyResolveCacheProcessor cacheProcessor = new MyResolveCacheProcessor(processor2, state);
            return name != null ? cache2.processForKey((Object)name, (Processor)cacheProcessor) : cache2.processAllValues((Processor)cacheProcessor);
        }
        return this.processDeclarationsNoGuess(processor2, state, lastParent, place);
    }

    /*
     * WARNING - void declaration
     */
    private boolean processDeclarationsNoGuess(PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, PsiElement place) {
        PsiImportStaticStatement[] importStaticStatements;
        PsiElement resolved;
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        ElementClassHint classHint = (ElementClassHint)processor2.getHint(ElementClassHint.KEY);
        NameHint nameHint = (NameHint)processor2.getHint(NameHint.KEY);
        String name = nameHint != null ? nameHint.getName(state) : null;
        PsiImportList importList = this.getImportList();
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            void var14_21;
            PsiClass[] classes2;
            for (PsiClass aClass : classes2 = this.getClasses()) {
                if (processor2.execute((PsiElement)aClass, state)) continue;
                return false;
            }
            PsiImportStatement[] importStatements = importList != null ? importList.getImportStatements() : PsiImportStatement.EMPTY_ARRAY;
            for (PsiImportStaticStatement psiImportStaticStatement : importStatements) {
                String refText;
                if (psiImportStaticStatement.isOnDemand() || name != null && ((refText = psiImportStaticStatement.getQualifiedName()) == null || !refText.endsWith(name)) || !((resolved = psiImportStaticStatement.resolve()) instanceof PsiClass)) continue;
                processor2.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)psiImportStaticStatement);
                PsiClass containingClass = ((PsiClass)resolved).getContainingClass();
                if (!(containingClass != null && containingClass.hasTypeParameters() ? !processor2.execute(resolved, state.put(PsiSubstitutor.KEY, (Object)PsiJavaFileBaseImpl.createRawSubstitutor(containingClass))) : !processor2.execute(resolved, state))) continue;
                return false;
            }
            processor2.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findPackage(this.getPackageName());
            if (aPackage != null && !PsiJavaFileBaseImpl.processPackageDeclarations(processor2, state, place, aPackage)) {
                return false;
            }
            PsiImportStatement[] psiImportStatementArray = importStatements;
            int n = psiImportStatementArray.length;
            boolean bl = false;
            while (var14_21 < n) {
                PsiElement resolved2;
                PsiImportStatement statement3 = psiImportStatementArray[var14_21];
                if (statement3.isOnDemand() && (resolved2 = statement3.resolve()) != null) {
                    processor2.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)statement3);
                    PsiJavaFileBaseImpl.processOnDemandTarget(resolved2, processor2, state, place);
                }
                ++var14_21;
            }
        }
        PsiImportStaticStatement[] psiImportStaticStatementArray = importStaticStatements = importList != null ? importList.getImportStaticStatements() : PsiImportStaticStatement.EMPTY_ARRAY;
        if (importStaticStatements.length > 0) {
            StaticImportFilteringProcessor staticImportProcessor = new StaticImportFilteringProcessor(processor2);
            for (PsiImportStaticStatement psiImportStaticStatement : importStaticStatements) {
                JavaResolveResult[] results;
                PsiJavaCodeReferenceElement reference;
                if (psiImportStaticStatement.isOnDemand() || (reference = psiImportStaticStatement.getImportReference()) == null || (results = reference.multiResolve(false)).length <= 0) continue;
                staticImportProcessor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, psiImportStaticStatement);
                String referenceName = psiImportStaticStatement.getReferenceName();
                for (JavaResolveResult result2 : results) {
                    staticImportProcessor.registerSingleStaticImportHiding(result2, referenceName);
                    PsiElement element = result2.getElement();
                    if (element == null || staticImportProcessor.execute(element, state)) continue;
                    return false;
                }
            }
            for (PsiImportStaticStatement psiImportStaticStatement : importStaticStatements) {
                PsiClass targetElement;
                if (!psiImportStaticStatement.isOnDemand() || (targetElement = psiImportStaticStatement.resolveTargetClass()) == null) continue;
                staticImportProcessor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, psiImportStaticStatement);
                if (targetElement.processDeclarations((PsiScopeProcessor)staticImportProcessor, state, lastParent, place)) continue;
                return false;
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            processor2.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
            PsiJavaCodeReferenceElement[] implicitlyImported = this.getImplicitlyImportedPackageReferences();
            for (PsiImportStaticStatement psiImportStaticStatement : implicitlyImported) {
                resolved = psiImportStaticStatement.resolve();
                if (resolved == null || PsiJavaFileBaseImpl.processOnDemandTarget(resolved, processor2, state, place)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processPackageDeclarations(PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement place, @NotNull PsiPackage aPackage) {
        if (!aPackage.getQualifiedName().isEmpty()) {
            processor2 = new DelegatingScopeProcessor(processor2){

                @Override
                @Nullable
                public <T> T getHint(@NotNull Key<T> hintKey) {
                    if (hintKey == ElementClassHint.KEY) {
                        return (T)new ElementClassHint(){

                            @Override
                            public boolean shouldProcess(ElementClassHint.DeclarationKind kind2) {
                                return kind2 == ElementClassHint.DeclarationKind.CLASS;
                            }
                        };
                    }
                    return super.getHint(hintKey);
                }
            };
        }
        return aPackage.processDeclarations(processor2, state, null, place);
    }

    @NotNull
    private static PsiSubstitutor createRawSubstitutor(PsiClass containingClass) {
        return JavaPsiFacade.getElementFactory((Project)containingClass.getProject()).createRawSubstitutor((PsiTypeParameterListOwner)containingClass);
    }

    private static boolean processOnDemandTarget(PsiElement target, PsiScopeProcessor processor2, ResolveState substitutor, PsiElement place) {
        if (target instanceof PsiPackage) {
            if (!PsiJavaFileBaseImpl.processPackageDeclarations(processor2, substitutor, place, (PsiPackage)target)) {
                return false;
            }
        } else if (target instanceof PsiClass) {
            PsiClass[] inners = ((PsiClass)target).getInnerClasses();
            if (((PsiClass)target).hasTypeParameters()) {
                substitutor = substitutor.put(PsiSubstitutor.KEY, (Object)PsiJavaFileBaseImpl.createRawSubstitutor((PsiClass)target));
            }
            for (PsiClass inner : inners) {
                if (processor2.execute((PsiElement)inner, substitutor)) continue;
                return false;
            }
        } else {
            LOG.error((Object)target);
        }
        return true;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitJavaFile((PsiJavaFile)this);
        } else {
            visitor.visitFile((PsiFile)this);
        }
    }

    @Override
    @NotNull
    public Language getLanguage() {
        return JavaLanguage.INSTANCE;
    }

    public boolean importClass(PsiClass aClass) {
        return JavaCodeStyleManager.getInstance((Project)this.getProject()).addImport((PsiJavaFile)this, aClass);
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        return (LanguageLevel)LANGUAGE_LEVEL_KEY.getValue((UserDataHolder)this);
    }

    @Nullable
    public PsiJavaModule getModuleDeclaration() {
        return null;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.putUserData((Key)LANGUAGE_LEVEL_KEY, null);
    }

    @Override
    public void setOriginalFile(@NotNull PsiFile originalFile) {
        super.setOriginalFile(originalFile);
        this.clearCaches();
    }

    private LanguageLevel getLanguageLevelInner() {
        if (this.myOriginalFile instanceof PsiJavaFile) {
            return ((PsiJavaFile)this.myOriginalFile).getLanguageLevel();
        }
        LanguageLevel forcedLanguageLevel = (LanguageLevel)this.getUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY);
        if (forcedLanguageLevel != null) {
            return forcedLanguageLevel;
        }
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null) {
            virtualFile = (VirtualFile)this.getUserData(IndexingDataKeys.VIRTUAL_FILE);
        }
        Project project2 = this.getProject();
        if (virtualFile == null) {
            PsiFile originalFile = this.getOriginalFile();
            if (originalFile instanceof PsiJavaFile && originalFile != this) {
                return ((PsiJavaFile)originalFile).getLanguageLevel();
            }
            return LanguageLevel.HIGHEST;
        }
        return JavaPsiImplementationHelper.getInstance(project2).getEffectiveLanguageLevel(virtualFile);
    }

    private static class MyResolveCacheProcessor
    implements Processor<SymbolCollectingProcessor.ResultWithContext> {
        private final PsiScopeProcessor myProcessor;
        private final ResolveState myState;

        public MyResolveCacheProcessor(PsiScopeProcessor processor2, ResolveState state) {
            this.myProcessor = processor2;
            this.myState = state;
        }

        public boolean process(SymbolCollectingProcessor.ResultWithContext result2) {
            PsiClass containingClass;
            PsiElement context = result2.getFileContext();
            this.myProcessor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)context);
            PsiNamedElement element = result2.getElement();
            if (element instanceof PsiClass && context instanceof PsiImportStatement && (containingClass = ((PsiClass)element).getContainingClass()) != null && containingClass.hasTypeParameters()) {
                return this.myProcessor.execute((PsiElement)element, this.myState.put(PsiSubstitutor.KEY, (Object)PsiJavaFileBaseImpl.createRawSubstitutor(containingClass)));
            }
            return this.myProcessor.execute((PsiElement)element, this.myState);
        }
    }

    private static class MyCacheBuilder
    implements CachedValueProvider<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> {
        private final PsiJavaFileBaseImpl myFile;

        public MyCacheBuilder(PsiJavaFileBaseImpl file2) {
            this.myFile = file2;
        }

        public CachedValueProvider.Result<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> compute() {
            SymbolCollectingProcessor p = new SymbolCollectingProcessor();
            this.myFile.processDeclarationsNoGuess(p, ResolveState.initial(), (PsiElement)this.myFile, (PsiElement)this.myFile);
            MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext> results = p.getResults();
            return CachedValueProvider.Result.create(results, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this.myFile});
        }
    }

    private static class StaticImportFilteringProcessor
    implements PsiScopeProcessor {
        private final PsiScopeProcessor myDelegate;
        private boolean myIsProcessingOnDemand;
        private final Collection<String> myHiddenFieldNames = new HashSet();
        private final Collection<String> myHiddenMethodNames = new HashSet();
        private final Collection<String> myHiddenTypeNames = new HashSet();
        private final Collection<PsiElement> myCollectedElements = new HashSet();

        public StaticImportFilteringProcessor(PsiScopeProcessor delegate) {
            this.myDelegate = delegate;
        }

        public <T> T getHint(@NotNull Key<T> hintKey) {
            return (T)this.myDelegate.getHint(hintKey);
        }

        public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
            if (JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT.equals(event) && associated instanceof PsiImportStaticStatement) {
                PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)associated;
                this.myIsProcessingOnDemand = importStaticStatement.isOnDemand();
            }
            this.myDelegate.handleEvent(event, associated);
        }

        private void registerSingleStaticImportHiding(JavaResolveResult result2, String referenceName) {
            this.getHiddenMembers(result2.getElement()).add(referenceName);
        }

        private Collection<String> getHiddenMembers(PsiElement element) {
            if (element instanceof PsiField) {
                return this.myHiddenFieldNames;
            }
            return element instanceof PsiClass ? this.myHiddenTypeNames : this.myHiddenMethodNames;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element instanceof PsiModifierListOwner && ((PsiModifierListOwner)element).hasModifierProperty("static")) {
                if (element instanceof PsiNamedElement && this.myIsProcessingOnDemand) {
                    String name = ((PsiNamedElement)element).getName();
                    if (this.getHiddenMembers(element).contains(name)) {
                        return true;
                    }
                }
                if (this.myCollectedElements.add(element)) {
                    return this.myDelegate.execute(element, state);
                }
            }
            return true;
        }
    }
}

