/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.core.JavaCoreBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiJavaModuleReference
extends PsiReferenceBase.Poly<PsiJavaModuleReferenceElement> {
    private static final Key<CachedValue<Collection<PsiJavaModule>>> K_COMPLETE = Key.create((String)"java.module.ref.text.resolve.complete");
    private static final Key<CachedValue<Collection<PsiJavaModule>>> K_INCOMPLETE = Key.create((String)"java.module.ref.text.resolve.incomplete");

    public PsiJavaModuleReference(@NotNull PsiJavaModuleReferenceElement element) {
        super((PsiElement)element, new TextRange(0, element.getTextLength()), false);
    }

    @NotNull
    public String getCanonicalText() {
        return ((PsiJavaModuleReferenceElement)this.getElement()).getReferenceText();
    }

    @NotNull
    public Object[] getVariants() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        return ResolveCache.getInstance(this.getProject()).resolveWithCaching(this, Resolver.INSTANCE, false, incompleteCode);
    }

    public PsiElement handleElementRename(@NotNull String newName) throws IncorrectOperationException {
        PsiJavaModuleReferenceElement element = (PsiJavaModuleReferenceElement)this.getElement();
        if (element instanceof PsiCompiledElement) {
            throw new IncorrectOperationException(JavaCoreBundle.message((String)"psi.error.attempt.to.edit.class.file", (Object[])new Object[]{element.getContainingFile()}));
        }
        PsiElementFactory factory = PsiElementFactory.SERVICE.getInstance((Project)element.getProject());
        PsiJavaModuleReferenceElement newElement = factory.createModuleFromText("module " + newName + " {}").getNameIdentifier();
        return element.replace((PsiElement)newElement);
    }

    private Project getProject() {
        return ((PsiJavaModuleReferenceElement)this.getElement()).getProject();
    }

    @Nullable
    public static PsiJavaModule resolve(@NotNull PsiElement refOwner, String refText, boolean incompleteCode) {
        Collection<PsiJavaModule> modules = PsiJavaModuleReference.multiResolve(refOwner, refText, incompleteCode);
        return modules.size() == 1 ? modules.iterator().next() : null;
    }

    @NotNull
    public static Collection<PsiJavaModule> multiResolve(@NotNull PsiElement refOwner, String refText, boolean incompleteCode) {
        if (StringUtil.isEmpty((String)refText)) {
            return Collections.emptyList();
        }
        CachedValuesManager manager = CachedValuesManager.getManager((Project)refOwner.getProject());
        Key<CachedValue<Collection<PsiJavaModule>>> key2 = incompleteCode ? K_INCOMPLETE : K_COMPLETE;
        return (Collection)manager.getCachedValue((UserDataHolder)refOwner, key2, () -> {
            Collection modules = Resolver.findModules(refOwner.getContainingFile(), refText, incompleteCode);
            return CachedValueProvider.Result.create((Object)modules, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        }, false);
    }

    private static class Resolver
    implements ResolveCache.PolyVariantResolver<PsiJavaModuleReference> {
        private static final ResolveCache.PolyVariantResolver<PsiJavaModuleReference> INSTANCE = new Resolver();

        private Resolver() {
        }

        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull PsiJavaModuleReference reference, boolean incompleteCode) {
            String moduleName;
            PsiFile file2 = ((PsiJavaModuleReferenceElement)reference.getElement()).getContainingFile();
            Collection<PsiJavaModule> modules = Resolver.findModules(file2, moduleName = reference.getCanonicalText(), incompleteCode);
            if (!modules.isEmpty()) {
                ResolveResult[] result2 = new ResolveResult[modules.size()];
                int i2 = 0;
                for (PsiJavaModule module2 : modules) {
                    result2[i2++] = new PsiElementResolveResult((PsiElement)module2);
                }
                return result2;
            }
            return ResolveResult.EMPTY_ARRAY;
        }

        private static Collection<PsiJavaModule> findModules(PsiFile file2, String moduleName, boolean incompleteCode) {
            Project project2 = file2.getProject();
            GlobalSearchScope scope = incompleteCode ? GlobalSearchScope.allScope((Project)project2) : file2.getResolveScope();
            return JavaFileManager.SERVICE.getInstance(project2).findModules(moduleName, scope);
        }
    }
}

