/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.java.stubs.JavaPackageAccessibilityStatementElementType;
import com.intellij.psi.impl.java.stubs.PsiPackageAccessibilityStatementStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiPackageAccessibilityStatementImpl
extends JavaStubPsiElement<PsiPackageAccessibilityStatementStub>
implements PsiPackageAccessibilityStatement {
    public PsiPackageAccessibilityStatementImpl(@NotNull PsiPackageAccessibilityStatementStub stub) {
        super(stub, stub.getStubType());
    }

    public PsiPackageAccessibilityStatementImpl(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    public PsiPackageAccessibilityStatement.Role getRole() {
        return JavaPackageAccessibilityStatementElementType.typeToRole((IElementType)this.getElementType());
    }

    @Nullable
    public PsiJavaCodeReferenceElement getPackageReference() {
        return (PsiJavaCodeReferenceElement)PsiTreeUtil.getChildOfType((PsiElement)this, PsiJavaCodeReferenceElement.class);
    }

    @Nullable
    public String getPackageName() {
        PsiPackageAccessibilityStatementStub stub = (PsiPackageAccessibilityStatementStub)this.getGreenStub();
        if (stub != null) {
            return StringUtil.nullize((String)stub.getPackageName());
        }
        PsiJavaCodeReferenceElement ref = this.getPackageReference();
        return ref != null ? PsiNameHelper.getQualifiedClassName((String)ref.getText(), (boolean)true) : null;
    }

    @NotNull
    public Iterable<PsiJavaModuleReferenceElement> getModuleReferences() {
        return SyntaxTraverser.psiTraverser().children((Object)this).filter(PsiJavaModuleReferenceElement.class);
    }

    @NotNull
    public List<String> getModuleNames() {
        PsiPackageAccessibilityStatementStub stub = (PsiPackageAccessibilityStatementStub)this.getGreenStub();
        if (stub != null) {
            return stub.getTargets();
        }
        List targets = ContainerUtil.newSmartList();
        for (PsiJavaModuleReferenceElement refElement : this.getModuleReferences()) {
            targets.add(refElement.getReferenceText());
        }
        return targets;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitPackageAccessibilityStatement((PsiPackageAccessibilityStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiPackageAccessibilityStatement";
    }
}

