/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.io.IOException;
import java.io.InputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public class CodeStyleSettingsLoader {
    public CodeStyleSettings loadSettings(@NotNull VirtualFile file2) throws SchemeImportException {
        Element rootElement = CodeStyleSettingsLoader.loadSchemeDom(file2);
        CodeStyleSettings settings = new CodeStyleSettings();
        this.loadSettings(rootElement, settings);
        return settings;
    }

    @NotNull
    protected static Element loadSchemeDom(@NotNull VirtualFile file2) throws SchemeImportException {
        InputStream inputStream = null;
        try {
            inputStream = file2.getInputStream();
            Document document = JDOMUtil.loadDocument((InputStream)inputStream);
            Element root = document.getRootElement();
            inputStream.close();
            Element element = root;
            return element;
        }
        catch (IOException | JDOMException e) {
            throw new SchemeImportException(CodeStyleSettingsLoader.getErrorMessage((Exception)e, file2));
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getErrorMessage(@NotNull Exception e, @NotNull VirtualFile file2) {
        return "Can't read from" + file2.getName() + ", " + e.getMessage();
    }

    protected void loadSettings(@NotNull Element rootElement, @NotNull CodeStyleSettings settings) throws SchemeImportException {
        try {
            settings.readExternal(rootElement);
        }
        catch (InvalidDataException e) {
            throw new SchemeImportException(ApplicationBundle.message((String)"settings.code.style.import.xml.error.can.not.load", (Object[])new Object[]{e.getMessage()}));
        }
    }
}

