/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostFormatProcessorHelper {
    private final CommonCodeStyleSettings mySettings;
    private TextRange myResultTextRange;

    public PostFormatProcessorHelper(CommonCodeStyleSettings settings) {
        this.mySettings = settings;
    }

    public CommonCodeStyleSettings getSettings() {
        return this.mySettings;
    }

    public void updateResultRange(int oldTextLength, int newTextLength) {
        if (this.myResultTextRange == null) {
            return;
        }
        this.myResultTextRange = new TextRange(this.myResultTextRange.getStartOffset(), this.myResultTextRange.getEndOffset() - oldTextLength + newTextLength);
    }

    public boolean isElementPartlyInRange(@NotNull PsiElement element) {
        if (this.myResultTextRange == null) {
            return true;
        }
        TextRange elementRange = element.getTextRange();
        if (elementRange.getEndOffset() < this.myResultTextRange.getStartOffset()) {
            return false;
        }
        return elementRange.getStartOffset() <= this.myResultTextRange.getEndOffset();
    }

    public boolean isElementFullyInRange(PsiElement element) {
        if (this.myResultTextRange == null) {
            return true;
        }
        TextRange elementRange = element.getTextRange();
        return elementRange.getStartOffset() >= this.myResultTextRange.getStartOffset() && elementRange.getEndOffset() <= this.myResultTextRange.getEndOffset();
    }

    public static boolean isMultiline(@Nullable PsiElement statement2) {
        if (statement2 == null) {
            return false;
        }
        return statement2.textContains('\n');
    }

    public void setResultTextRange(TextRange resultTextRange) {
        this.myResultTextRange = resultTextRange;
    }

    public TextRange getResultTextRange() {
        return this.myResultTextRange;
    }
}

