/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabPostFormatProcessor
implements PostFormatProcessor {
    @Override
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        TabPostFormatProcessor.doProcess(source, TextRange.from((int)source.getTextRange().getStartOffset(), (int)source.getTextLength()), settings);
        return source;
    }

    @Override
    @NotNull
    public TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        return TabPostFormatProcessor.doProcess((PsiElement)source, rangeToReformat, settings);
    }

    @NotNull
    private static TextRange doProcess(@NotNull PsiElement source, @NotNull TextRange range, @NotNull CodeStyleSettings settings) {
        ASTNode node = source.getNode();
        if (node == null) {
            return range;
        }
        Language language = source.getLanguage();
        if (language != JavaLanguage.INSTANCE) {
            return range;
        }
        if (!source.isValid()) {
            return range;
        }
        PsiFile file2 = source.getContainingFile();
        CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptionsByFile(file2, range);
        boolean useTabs = indentOptions.USE_TAB_CHARACTER;
        boolean smartTabs = indentOptions.SMART_TABS;
        int tabWidth = indentOptions.TAB_SIZE;
        return TabPostFormatProcessor.processViaPsi(node, range, new TreeHelperImpl(), useTabs, smartTabs, tabWidth);
    }

    @NotNull
    static TextRange processViaPsi(@NotNull ASTNode node, @NotNull TextRange range, @NotNull TreeHelper treeHelper, boolean useTabs, boolean smartTabs, int tabWidth) {
        AstHelper helper = new AstHelper(node, treeHelper);
        do {
            if (useTabs) {
                if (smartTabs) {
                    range = TabPostFormatProcessor.processSmartTabs(helper, range, tabWidth);
                    continue;
                }
                range = TabPostFormatProcessor.processTabs(helper, range, tabWidth);
                continue;
            }
            range = TabPostFormatProcessor.processSpaces(helper, range, tabWidth);
        } while (helper.nextLine());
        return range;
    }

    @NotNull
    static TextRange processViaDocument(@NotNull Document document, @NotNull TextRange range, boolean useTabs, boolean useSmartTabs, int tabWidth) {
        TextRange result2 = range;
        int startLine = document.getLineNumber(Math.min(document.getTextLength(), range.getStartOffset()));
        int endLine = document.getLineNumber(Math.max(0, Math.min(document.getTextLength(), range.getEndOffset()) - 1));
        DocumentHelper helper = new DocumentHelper(document, startLine);
        for (int line = startLine; line <= endLine; ++line) {
            helper.setLine(line);
            if (useTabs) {
                if (useSmartTabs) {
                    result2 = TabPostFormatProcessor.processSmartTabs(helper, result2, tabWidth);
                    continue;
                }
                result2 = TabPostFormatProcessor.processTabs(helper, result2, tabWidth);
                continue;
            }
            result2 = TabPostFormatProcessor.processSpaces(helper, result2, tabWidth);
        }
        return result2;
    }

    @NotNull
    private static TextRange processSpaces(@NotNull Helper helper, @NotNull TextRange range, int tabWidth) {
        CharSequence indent = helper.getCurrentLineIndent();
        int start = Math.max(0, range.getStartOffset() - helper.getCurrentLineStartOffset());
        int end = Math.min(indent.length(), range.getEndOffset() - helper.getCurrentLineStartOffset());
        int tabsNumber = 0;
        int indentOffset = end;
        for (int i2 = start; i2 < end; ++i2) {
            char c = indent.charAt(i2);
            if (c == '\t') {
                ++tabsNumber;
                continue;
            }
            if (c == ' ') continue;
            indentOffset = i2;
            break;
        }
        if (tabsNumber > 0) {
            helper.replace(start, indentOffset, StringUtil.repeat((String)" ", (int)(indentOffset - start - tabsNumber + tabsNumber * tabWidth)));
            return TextRange.create((int)range.getStartOffset(), (int)(range.getEndOffset() - tabsNumber + tabsNumber * tabWidth));
        }
        return range;
    }

    @NotNull
    private static TextRange processTabs(@NotNull Helper helper, @NotNull TextRange range, int tabWidth) {
        int tabsNumber;
        CharSequence indent = helper.getCurrentLineIndent();
        int start = Math.max(0, range.getStartOffset() - helper.getCurrentLineStartOffset());
        int end = Math.min(indent.length(), range.getEndOffset() - helper.getCurrentLineStartOffset());
        int replacementsNumber = 0;
        int consecutiveSpaces = 0;
        for (int i2 = start; i2 < end; ++i2) {
            char c = indent.charAt(i2);
            if (c == ' ') {
                ++consecutiveSpaces;
                continue;
            }
            int tabsNumber2 = consecutiveSpaces / tabWidth;
            if (tabsNumber2 > 0) {
                helper.replace(i2 - consecutiveSpaces, i2 - consecutiveSpaces + tabsNumber2 * tabWidth, StringUtil.repeat((String)"\t", (int)tabsNumber2));
                ++replacementsNumber;
                consecutiveSpaces = 0;
            }
            if (c != '\t') break;
        }
        if ((tabsNumber = consecutiveSpaces / tabWidth) > 0) {
            helper.replace(end - consecutiveSpaces, end - consecutiveSpaces + tabsNumber * tabWidth, StringUtil.repeat((String)"\t", (int)tabsNumber));
        }
        if (replacementsNumber > 0) {
            return TextRange.create((int)range.getStartOffset(), (int)(range.getEndOffset() - replacementsNumber * (tabWidth - 1)));
        }
        return range;
    }

    @NotNull
    private static TextRange processSmartTabs(@NotNull Helper helper, @NotNull TextRange range, int tabWidth) {
        CharSequence prevLineIndent = helper.getPrevLineIndent();
        if (prevLineIndent == null) {
            return TabPostFormatProcessor.processTabs(helper, range, tabWidth);
        }
        CharSequence currentLineIndent = helper.getCurrentLineIndent();
        int lineStart = 0;
        int start = Math.max(0, range.getStartOffset() - helper.getCurrentLineStartOffset());
        int end = Math.min(currentLineIndent.length(), range.getEndOffset() - helper.getCurrentLineStartOffset());
        int indentOffset = 0;
        int tabsReplaced = 0;
        for (int i2 = lineStart; i2 < end && indentOffset < prevLineIndent.length(); ++i2, ++indentOffset) {
            char c = currentLineIndent.charAt(i2);
            if (prevLineIndent.charAt(indentOffset) == ' ') {
                if (c != ' ') break;
                continue;
            }
            if (c == '\t') continue;
            if (end - i2 < tabWidth) break;
            boolean canReplace = true;
            int max = Math.min(end, i2 + tabWidth);
            for (int j = i2 + 1; j < max; ++j) {
                if (currentLineIndent.charAt(j) == ' ') continue;
                canReplace = false;
                break;
            }
            if (!canReplace) break;
            if (i2 < start) {
                i2 += tabWidth - 1;
                continue;
            }
            helper.replace(i2, i2 + tabWidth, "\t");
            ++tabsReplaced;
            end -= tabWidth - 1;
        }
        return tabsReplaced > 0 ? TextRange.create((int)range.getStartOffset(), (int)(range.getEndOffset() - tabsReplaced * (tabWidth - 1))) : range;
    }

    private static class TreeHelperImpl
    implements TreeHelper {
        private TreeHelperImpl() {
        }

        @Override
        public ASTNode prevLeaf(@NotNull ASTNode current) {
            return TreeUtil.prevLeaf(current);
        }

        @Override
        @Nullable
        public ASTNode nextLeaf(@NotNull ASTNode current) {
            return TreeUtil.nextLeaf(current);
        }

        @Override
        @Nullable
        public ASTNode firstLeaf(@NotNull ASTNode startNode) {
            return TreeUtil.findFirstLeaf(startNode);
        }

        @Override
        public void replace(@NotNull String newText, @NotNull TextRange range, @NotNull ASTNode leaf) {
            FormatterUtil.replaceInnerWhiteSpace(newText, leaf, range);
        }
    }

    static interface TreeHelper {
        @Nullable
        public ASTNode prevLeaf(@NotNull ASTNode var1);

        @Nullable
        public ASTNode nextLeaf(@NotNull ASTNode var1);

        @Nullable
        public ASTNode firstLeaf(@NotNull ASTNode var1);

        public void replace(@NotNull String var1, @NotNull TextRange var2, @NotNull ASTNode var3);
    }

    private static class AstHelper
    implements Helper {
        @NotNull
        private final TreeHelper myHelper;
        @Nullable
        private ASTNode myCurrentIndentHolder;
        private int myLineStartOffset;

        AstHelper(@NotNull ASTNode startNode, @NotNull TreeHelper helper) {
            this.myHelper = helper;
            this.myCurrentIndentHolder = this.myHelper.firstLeaf(startNode);
            if (startNode.getStartOffset() <= 0) {
                return;
            }
            this.nextLine();
        }

        @Override
        public CharSequence getPrevLineIndent() {
            if (this.myCurrentIndentHolder == null) {
                return null;
            }
            int end = this.myLineStartOffset - 1;
            CharSequence text = this.myCurrentIndentHolder.getChars();
            for (int i2 = end - 1; i2 >= 0; --i2) {
                if (text.charAt(i2) != '\n') continue;
                return text.subSequence(i2 + 1, end);
            }
            ASTNode prev = this.prevIndentNode(this.myCurrentIndentHolder);
            if (prev != null) {
                CharSequence chars = prev.getChars();
                for (int i3 = chars.length() - 1; i3 >= 0; --i3) {
                    if (chars.charAt(i3) != '\n') continue;
                    return chars.subSequence(i3 + 1, chars.length());
                }
                return chars;
            }
            return null;
        }

        @Override
        public int getCurrentLineStartOffset() {
            ASTNode whiteSpace = this.myCurrentIndentHolder;
            return whiteSpace == null ? 0 : whiteSpace.getStartOffset() + this.myLineStartOffset;
        }

        @Override
        @NotNull
        public CharSequence getCurrentLineIndent() {
            if (this.myCurrentIndentHolder == null || this.myLineStartOffset < 0) {
                return "";
            }
            CharSequence text = this.myCurrentIndentHolder.getChars();
            for (int i2 = this.myLineStartOffset; i2 < text.length(); ++i2) {
                char c = text.charAt(i2);
                if (c != '\n' && (c == ' ' || c == '\t')) continue;
                return text.subSequence(this.myLineStartOffset, i2);
            }
            return text.subSequence(this.myLineStartOffset, text.length());
        }

        @Override
        public void replace(int start, int end, @NotNull String newText) {
            if (this.myCurrentIndentHolder != null) {
                this.myHelper.replace(newText, TextRange.create((int)start, (int)end).shiftRight(this.getCurrentLineStartOffset()), this.myCurrentIndentHolder);
            }
        }

        public boolean nextLine() {
            if (this.myCurrentIndentHolder == null) {
                return false;
            }
            ASTNode node = this.myHelper.nextLeaf(this.myCurrentIndentHolder);
            while (node != null) {
                if (this.myCurrentIndentHolder.getTextLength() > 0) {
                    CharSequence text = node.getChars();
                    this.myLineStartOffset = 0;
                    while (this.myLineStartOffset < text.length()) {
                        char c = text.charAt(this.myLineStartOffset);
                        if (c == '\n' && this.myLineStartOffset < text.length() - 1) {
                            this.myCurrentIndentHolder = node;
                            ++this.myLineStartOffset;
                            return true;
                        }
                        ++this.myLineStartOffset;
                    }
                }
                node = this.myHelper.nextLeaf(node);
            }
            this.myCurrentIndentHolder = null;
            return false;
        }

        @Nullable
        private ASTNode prevIndentNode(@NotNull ASTNode current) {
            ASTNode candidate = this.myHelper.prevLeaf(current);
            while (candidate != null) {
                if (candidate.getStartOffset() <= 0 || StringUtil.contains((CharSequence)candidate.getChars(), (int)0, (int)candidate.getTextLength(), (char)'\n')) {
                    return candidate;
                }
                candidate = this.myHelper.prevLeaf(candidate);
            }
            return null;
        }
    }

    private static class DocumentHelper
    implements Helper {
        @NotNull
        private final Document myDocument;
        private int myLine;
        private int myLineStartOffset;

        DocumentHelper(@NotNull Document document, int line) {
            this.myDocument = document;
            this.setLine(line);
        }

        @Override
        @Nullable
        public CharSequence getPrevLineIndent() {
            int prevLineStart;
            char c;
            int prevLineIndentEnd;
            if (this.myLine <= 0) {
                return null;
            }
            int prevLineEnd = this.myDocument.getLineEndOffset(this.myLine - 1);
            CharSequence text = this.myDocument.getCharsSequence();
            for (prevLineIndentEnd = prevLineStart = this.myDocument.getLineStartOffset(this.myLine - 1); prevLineIndentEnd < prevLineEnd && ((c = text.charAt(prevLineIndentEnd)) == '\t' || c == ' '); ++prevLineIndentEnd) {
            }
            return text.subSequence(prevLineStart, prevLineIndentEnd);
        }

        @Override
        public int getCurrentLineStartOffset() {
            return this.myLineStartOffset;
        }

        @Override
        @NotNull
        public CharSequence getCurrentLineIndent() {
            int end = this.myDocument.getLineEndOffset(this.myLine);
            CharSequence text = this.myDocument.getCharsSequence();
            for (int i2 = this.myLineStartOffset; i2 < end; ++i2) {
                char c = text.charAt(i2);
                if (c == ' ' || c == '\t') continue;
                return text.subSequence(this.myLineStartOffset, i2);
            }
            return text.subSequence(this.myLineStartOffset, end);
        }

        @Override
        public void replace(int start, int end, @NotNull String newText) {
            this.myDocument.replaceString(this.myLineStartOffset + start, this.myLineStartOffset + end, (CharSequence)newText);
        }

        public void setLine(int line) {
            this.myLine = line;
            this.myLineStartOffset = this.myDocument.getLineStartOffset(line);
        }
    }

    static interface Helper {
        @Nullable
        public CharSequence getPrevLineIndent();

        public int getCurrentLineStartOffset();

        @NotNull
        public CharSequence getCurrentLineIndent();

        public void replace(int var1, int var2, @NotNull String var3);
    }
}

