/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.psi.impl.source.codeStyle.javadoc.CommentFormatter;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDParamListOwnerComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDTag;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDClassComment
extends JDParamListOwnerComment {
    private List<String> myAuthorsList;
    private String myVersion;

    public JDClassComment(@NotNull CommentFormatter formatter) {
        super(formatter);
    }

    @Override
    protected void generateSpecial(@NotNull String prefix, @NotNull StringBuilder sb) {
        JDTag tag;
        super.generateSpecial(prefix, sb);
        if (!JDClassComment.isNull(this.myAuthorsList)) {
            tag = JDTag.AUTHOR;
            for (String author : this.myAuthorsList) {
                sb.append(prefix);
                sb.append(tag.getWithEndWhitespace());
                sb.append((CharSequence)this.myFormatter.getParser().formatJDTagDescription(author, tag.getDescriptionPrefix(prefix)));
            }
        }
        if (!JDClassComment.isNull(this.myVersion)) {
            sb.append(prefix);
            tag = JDTag.VERSION;
            sb.append(tag.getWithEndWhitespace());
            sb.append((CharSequence)this.myFormatter.getParser().formatJDTagDescription(this.myVersion, tag.getDescriptionPrefix(prefix)));
        }
    }

    public void addAuthor(@NotNull String author) {
        if (this.myAuthorsList == null) {
            this.myAuthorsList = ContainerUtilRt.newArrayList();
        }
        this.myAuthorsList.add(author);
    }

    @Nullable
    public String getVersion() {
        return this.myVersion;
    }

    public void setVersion(@NotNull String version) {
        this.myVersion = version;
    }
}

