/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.psi.impl.source.codeStyle.javadoc.CommentFormatter;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDParamListOwnerComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDTag;
import com.intellij.psi.impl.source.codeStyle.javadoc.NameDesc;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDMethodComment
extends JDParamListOwnerComment {
    private String myReturnTag;
    private List<NameDesc> myThrowsList;

    public JDMethodComment(@NotNull CommentFormatter formatter) {
        super(formatter);
    }

    @Override
    protected void generateSpecial(@NotNull String prefix, @NotNull StringBuilder sb) {
        JDTag tag;
        super.generateSpecial(prefix, sb);
        if (this.myReturnTag != null && (this.myFormatter.getSettings().JD_KEEP_EMPTY_RETURN || !this.myReturnTag.trim().isEmpty())) {
            tag = JDTag.RETURN;
            sb.append(prefix);
            sb.append(tag.getWithEndWhitespace());
            sb.append((CharSequence)this.myFormatter.getParser().formatJDTagDescription(this.myReturnTag, prefix, true, tag.getDescriptionPrefix(prefix).length()));
            if (this.myFormatter.getSettings().JD_ADD_BLANK_AFTER_RETURN) {
                sb.append(prefix);
                sb.append('\n');
            }
        }
        if (this.myThrowsList != null) {
            tag = this.myFormatter.getSettings().JD_USE_THROWS_NOT_EXCEPTION ? JDTag.THROWS : JDTag.EXCEPTION;
            this.generateList(prefix, sb, this.myThrowsList, tag.getWithEndWhitespace(), this.myFormatter.getSettings().JD_ALIGN_EXCEPTION_COMMENTS, this.myFormatter.getSettings().JD_KEEP_EMPTY_EXCEPTION, this.myFormatter.getSettings().JD_PARAM_DESCRIPTION_ON_NEW_LINE);
        }
    }

    public void setReturnTag(@NotNull String returnTag) {
        this.myReturnTag = returnTag;
    }

    public void addThrow(@NotNull String className, @Nullable String description) {
        if (this.myThrowsList == null) {
            this.myThrowsList = ContainerUtilRt.newArrayList();
        }
        this.myThrowsList.add(new NameDesc(className, description));
    }
}

