/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.lineIndent;

import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentInfo;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndentCalculator {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private BaseLineOffsetCalculator myBaseLineOffsetCalculator;
    @NotNull
    private final Indent.Type myIndentType;
    public static final BaseLineOffsetCalculator LINE_BEFORE = new BaseLineOffsetCalculator(){

        @Override
        public int getOffsetInBaseIndentLine(@NotNull SemanticEditorPosition currPosition) {
            return CharArrayUtil.shiftBackward((CharSequence)currPosition.getChars(), (int)currPosition.getStartOffset(), (String)" \t\n\r");
        }
    };
    public static final BaseLineOffsetCalculator LINE_AFTER = new BaseLineOffsetCalculator(){

        @Override
        public int getOffsetInBaseIndentLine(@NotNull SemanticEditorPosition currPosition) {
            return CharArrayUtil.shiftForward((CharSequence)currPosition.getChars(), (int)currPosition.getStartOffset(), (String)" \t\n\r");
        }
    };

    public IndentCalculator(@NotNull Project project2, @NotNull Editor editor, @NotNull BaseLineOffsetCalculator baseLineOffsetCalculator, @NotNull Indent.Type type2) {
        this.myProject = project2;
        this.myEditor = editor;
        this.myBaseLineOffsetCalculator = baseLineOffsetCalculator;
        this.myIndentType = type2;
    }

    @Nullable
    String getIndentString(@Nullable Language language, @NotNull SemanticEditorPosition currPosition) {
        String baseIndent = this.getBaseIndent(currPosition);
        Document document = this.myEditor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (file2 != null) {
            CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)this.myProject);
            CommonCodeStyleSettings.IndentOptions options = language != null && !language.is(file2.getLanguage()) && !language.is(Language.ANY) ? codeStyleSettings.getCommonSettings(language).getIndentOptions() : codeStyleSettings.getIndentOptionsByFile(file2);
            return baseIndent + new IndentInfo(0, IndentCalculator.indentTypeToSize(this.myIndentType, options), 0, false).generateNewWhiteSpace(options);
        }
        return null;
    }

    @NotNull
    private String getBaseIndent(@NotNull SemanticEditorPosition currPosition) {
        int indentEnd;
        int indentStart;
        int indentLineOffset;
        CharSequence docChars = this.myEditor.getDocument().getCharsSequence();
        int offset = currPosition.getStartOffset();
        if (offset > 0 && (indentLineOffset = this.myBaseLineOffsetCalculator.getOffsetInBaseIndentLine(currPosition)) > 0 && (indentStart = CharArrayUtil.shiftBackwardUntil((CharSequence)docChars, (int)indentLineOffset, (String)"\n") + 1) >= 0 && (indentEnd = CharArrayUtil.shiftForward((CharSequence)docChars, (int)indentStart, (String)" \t")) > indentStart) {
            return docChars.subSequence(indentStart, indentEnd).toString();
        }
        return "";
    }

    private static int indentTypeToSize(@NotNull Indent.Type indentType, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (indentType == Indent.Type.NORMAL) {
            return options.INDENT_SIZE;
        }
        if (indentType == Indent.Type.CONTINUATION) {
            return options.CONTINUATION_INDENT_SIZE;
        }
        return 0;
    }

    public static interface BaseLineOffsetCalculator {
        public int getOffsetInBaseIndentLine(@NotNull SemanticEditorPosition var1);
    }
}

