/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolveCache {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.resolve.ResolveCache");
    private final ConcurrentMap[] myMaps = new ConcurrentMap[8];
    private final RecursionGuard myGuard = RecursionManager.createGuard((String)"resolveCache");
    private static final Object NULL_RESULT = new Object();
    private static final StrongValueReference NULL_VALUE_REFERENCE = new StrongValueReference(NULL_RESULT);
    private static final StrongValueReference EMPTY_RESOLVE_RESULT = new StrongValueReference(ResolveResult.EMPTY_ARRAY);

    public static ResolveCache getInstance(Project project2) {
        ProgressIndicatorProvider.checkCanceled();
        return (ResolveCache)ServiceManager.getService((Project)project2, ResolveCache.class);
    }

    public ResolveCache(@NotNull MessageBus messageBus) {
        for (int i = 0; i < this.myMaps.length; ++i) {
            this.myMaps[i] = ResolveCache.createWeakMap();
        }
        messageBus.connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, (Object)new AnyPsiChangeListener.Adapter(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                ResolveCache.this.clearCache(isPhysical);
            }
        });
    }

    @NotNull
    private static <K, V> ConcurrentMap<K, V> createWeakMap() {
        return new ConcurrentWeakKeySoftValueHashMap<K, V>(100, 0.75f, Runtime.getRuntime().availableProcessors(), ContainerUtil.canonicalStrategy()){

            @NotNull
            protected ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> createValueReference(@NotNull V value2, @NotNull ReferenceQueue<V> queue) {
                StrongValueReference result2 = value2 == NULL_RESULT || value2 instanceof Object[] && ((Object[])value2).length == 0 ? ResolveCache.createStrongReference(value2) : super.createValueReference(value2, queue);
                return result2;
            }

            public V get(@NotNull Object key2) {
                Object v = super.get(key2);
                return v == NULL_RESULT ? null : v;
            }
        };
    }

    public void clearCache(boolean isPhysical) {
        int startIndex;
        for (int i = startIndex = isPhysical ? 0 : 1; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    this.myMaps[i * 4 + j * 2 + k].clear();
                }
            }
        }
    }

    @Nullable
    private <TRef extends PsiReference, TResult> TResult resolve(@NotNull TRef ref, @NotNull AbstractResolver<TRef, TResult> resolver, boolean needToPreventRecursion, boolean incompleteCode, boolean isPoly, boolean isPhysical) {
        int index;
        ConcurrentMap<TRef, TResult> map2;
        Object result2;
        ProgressIndicatorProvider.checkCanceled();
        if (isPhysical) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        if ((result2 = (map2 = this.getMap(index = ResolveCache.getIndex(isPhysical, incompleteCode, isPoly))).get(ref)) != null) {
            return (TResult)result2;
        }
        RecursionGuard.StackStamp stamp = this.myGuard.markStack();
        result2 = needToPreventRecursion ? this.myGuard.doPreventingRecursion((Object)Trinity.create(ref, (Object)incompleteCode, (Object)isPoly), true, () -> resolver.resolve(ref, incompleteCode)) : resolver.resolve(ref, incompleteCode);
        PsiElement element = result2 instanceof ResolveResult ? ((ResolveResult)result2).getElement() : null;
        LOG.assertTrue(element == null || element.isValid(), result2);
        if (stamp.mayCacheNow()) {
            ResolveCache.cache(ref, map2, result2);
        }
        return (TResult)result2;
    }

    @NotNull
    public <T extends PsiPolyVariantReference> ResolveResult[] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode) {
        return this.resolveWithCaching(ref, resolver, needToPreventRecursion, incompleteCode, ref.getElement().getContainingFile());
    }

    @NotNull
    public <T extends PsiPolyVariantReference> ResolveResult[] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode, @NotNull PsiFile containingFile) {
        ResolveResult[] result2 = (ResolveResult[])this.resolve((PsiReference)ref, (AbstractResolver)resolver, needToPreventRecursion, incompleteCode, true, containingFile.isPhysical());
        return result2 == null ? ResolveResult.EMPTY_ARRAY : result2;
    }

    @NotNull
    public <T extends PsiPolyVariantReference> ResolveResult[] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantContextResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode, @NotNull PsiFile containingFile) {
        ProgressIndicatorProvider.checkCanceled();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int index = ResolveCache.getIndex(containingFile.isPhysical(), incompleteCode, true);
        ConcurrentMap map2 = this.getMap(index);
        ResolveResult[] result2 = (ResolveResult[])map2.get(ref);
        if (result2 != null) {
            return result2;
        }
        RecursionGuard.StackStamp stamp = this.myGuard.markStack();
        ResolveResult[] resolveResultArray = result2 = needToPreventRecursion ? (ResolveResult[])this.myGuard.doPreventingRecursion((Object)Pair.create(ref, (Object)incompleteCode), true, () -> resolver.resolve(ref, containingFile, incompleteCode)) : resolver.resolve(ref, containingFile, incompleteCode);
        if (stamp.mayCacheNow()) {
            ResolveCache.cache(ref, map2, result2);
        }
        return result2 == null ? ResolveResult.EMPTY_ARRAY : result2;
    }

    @Nullable
    public <T extends PsiPolyVariantReference> ResolveResult[] getCachedResults(@NotNull T ref, boolean physical, boolean incompleteCode, boolean isPoly) {
        ConcurrentMap map2 = this.getMap(ResolveCache.getIndex(physical, incompleteCode, isPoly));
        return (ResolveResult[])map2.get(ref);
    }

    @Nullable
    public <TRef extends PsiReference, TResult> TResult resolveWithCaching(@NotNull TRef ref, @NotNull AbstractResolver<TRef, TResult> resolver, boolean needToPreventRecursion, boolean incompleteCode) {
        return this.resolve(ref, resolver, needToPreventRecursion, incompleteCode, false, ref.getElement().isPhysical());
    }

    @NotNull
    private <TRef extends PsiReference, TResult> ConcurrentMap<TRef, TResult> getMap(int index) {
        return this.myMaps[index];
    }

    private static int getIndex(boolean physical, boolean incompleteCode, boolean isPoly) {
        return (physical ? 0 : 1) * 4 + (incompleteCode ? 0 : 1) * 2 + (isPoly ? 0 : 1);
    }

    private static <TRef extends PsiReference, TResult> void cache(@NotNull TRef ref, @NotNull ConcurrentMap<TRef, TResult> map2, TResult result2) {
        Object cached = map2.get(ref);
        if (cached != null && cached == result2) {
            return;
        }
        cached = result2 == null ? NULL_RESULT : result2;
        map2.put(ref, cached);
    }

    @NotNull
    private static <K, V> StrongValueReference<K, V> createStrongReference(@NotNull V value2) {
        return value2 == NULL_RESULT ? NULL_VALUE_REFERENCE : (value2 == ResolveResult.EMPTY_ARRAY ? EMPTY_RESOLVE_RESULT : new StrongValueReference(value2));
    }

    private static class StrongValueReference<K, V>
    implements ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> {
        private final V myValue;

        public StrongValueReference(@NotNull V value2) {
            this.myValue = value2;
        }

        @NotNull
        public ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> getKeyReference() {
            throw new UnsupportedOperationException();
        }

        public V get() {
            return this.myValue;
        }
    }

    public static interface Resolver
    extends AbstractResolver<PsiReference, PsiElement> {
    }

    public static interface PolyVariantContextResolver<T extends PsiPolyVariantReference> {
        @NotNull
        public ResolveResult[] resolve(@NotNull T var1, @NotNull PsiFile var2, boolean var3);
    }

    public static interface PolyVariantResolver<T extends PsiPolyVariantReference>
    extends AbstractResolver<T, ResolveResult[]> {
        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull T var1, boolean var2);
    }

    public static interface AbstractResolver<TRef extends PsiReference, TResult> {
        public TResult resolve(@NotNull TRef var1, boolean var2);
    }
}

