/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.MostlySingularMultiMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SymbolCollectingProcessor
extends BaseScopeProcessor
implements ElementClassHint {
    private final MostlySingularMultiMap<String, ResultWithContext> myResult = new MostlySingularMultiMap();
    private PsiElement myCurrentFileContext;

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        return null;
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT) {
            this.myCurrentFileContext = (PsiElement)associated;
        }
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        PsiNamedElement named;
        String name;
        if (element instanceof PsiNamedElement && element.isValid() && (name = (named = (PsiNamedElement)element).getName()) != null) {
            this.myResult.add((Object)name, (Object)new ResultWithContext(named, this.myCurrentFileContext));
        }
        return true;
    }

    @Override
    public boolean shouldProcess(ElementClassHint.DeclarationKind kind2) {
        return kind2 == ElementClassHint.DeclarationKind.CLASS || kind2 == ElementClassHint.DeclarationKind.PACKAGE || kind2 == ElementClassHint.DeclarationKind.METHOD || kind2 == ElementClassHint.DeclarationKind.FIELD;
    }

    public MostlySingularMultiMap<String, ResultWithContext> getResults() {
        return this.myResult;
    }

    public static class ResultWithContext {
        private final PsiNamedElement myElement;
        private final PsiElement myFileContext;

        public ResultWithContext(@NotNull PsiNamedElement element, @Nullable PsiElement fileContext) {
            this.myElement = element;
            this.myFileContext = fileContext;
        }

        @NotNull
        public PsiNamedElement getElement() {
            return this.myElement;
        }

        public PsiElement getFileContext() {
            return this.myFileContext;
        }

        public String toString() {
            return this.myElement.toString();
        }
    }
}

