/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.augment.TypeAnnotationModifier;
import com.intellij.psi.impl.light.LightTypeParameter;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceIncorporationPhase;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceVariable
extends LightTypeParameter {
    private final PsiElement myContext;
    private boolean myThrownBound;
    private final Map<InferenceBound, List<PsiType>> myBounds = new HashMap<InferenceBound, List<PsiType>>();
    private final String myName;
    private PsiType myInstantiation = PsiType.NULL;

    public PsiTypeParameter getParameter() {
        return this.getDelegate();
    }

    InferenceVariable(PsiElement context, PsiTypeParameter parameter, String name) {
        super(parameter);
        this.myName = name;
        this.myContext = context;
        TypeConversionUtil.markAsFreshVariable((PsiTypeParameter)this, (PsiElement)context);
    }

    public PsiType getInstantiation() {
        return this.myInstantiation;
    }

    public void setInstantiation(PsiType instantiation) {
        this.myInstantiation = instantiation;
    }

    @Override
    @NotNull
    public PsiClassType[] getExtendsListTypes() {
        ArrayList<PsiClassType> result2 = new ArrayList<PsiClassType>();
        for (PsiType type2 : this.getBounds(InferenceBound.UPPER)) {
            if (!(type2 instanceof PsiClassType)) continue;
            result2.add((PsiClassType)type2);
        }
        return result2.toArray(new PsiClassType[result2.size()]);
    }

    public static void addBound(PsiType inferenceVariableType, PsiType boundType, InferenceBound inferenceBound, InferenceSession session2) {
        InferenceVariable variable = session2.getInferenceVariable(inferenceVariableType);
        if (variable != null) {
            for (TypeAnnotationModifier modifier : (TypeAnnotationModifier[])TypeAnnotationModifier.EP_NAME.getExtensions()) {
                TypeAnnotationProvider annotationProvider;
                if (!(boundType instanceof PsiClassType) || (annotationProvider = modifier.modifyAnnotations(inferenceVariableType, (PsiClassType)boundType)) == null) continue;
                boundType = boundType.annotate(annotationProvider);
            }
            variable.addBound(boundType, inferenceBound, session2.myIncorporationPhase);
        }
    }

    public boolean addBound(PsiType classType, InferenceBound inferenceBound, @Nullable InferenceIncorporationPhase incorporationPhase) {
        if (inferenceBound == InferenceBound.EQ && PsiUtil.resolveClassInClassTypeOnly((PsiType)classType) == this) {
            return false;
        }
        List<PsiType> bounds = this.myBounds.get((Object)inferenceBound);
        if (bounds == null) {
            bounds = new ArrayList<PsiType>();
            this.myBounds.put(inferenceBound, bounds);
        }
        if (classType == null) {
            classType = PsiType.NULL;
        }
        if (incorporationPhase == null || !bounds.contains(classType)) {
            bounds.add(classType);
            if (incorporationPhase != null) {
                incorporationPhase.addBound(this, classType, inferenceBound);
            }
            return true;
        }
        return false;
    }

    public List<PsiType> getBounds(InferenceBound inferenceBound) {
        List<PsiType> bounds = this.myBounds.get((Object)inferenceBound);
        return bounds != null ? new ArrayList<PsiType>(bounds) : Collections.emptyList();
    }

    public List<PsiType> getReadOnlyBounds(InferenceBound inferenceBound) {
        List<PsiType> bounds = this.myBounds.get((Object)inferenceBound);
        return bounds != null ? bounds : Collections.emptyList();
    }

    public Set<InferenceVariable> getDependencies(InferenceSession session2) {
        LinkedHashSet<InferenceVariable> dependencies = new LinkedHashSet<InferenceVariable>();
        this.collectBoundDependencies(session2, dependencies);
        this.collectTransitiveDependencies(session2, dependencies, dependencies);
        if (!session2.hasCapture(this) && dependencies.isEmpty()) {
            return dependencies;
        }
        if (!session2.hasCapture(this)) {
            return dependencies;
        }
        Iterator iterator = dependencies.iterator();
        while (iterator.hasNext()) {
            if (session2.hasCapture((InferenceVariable)((Object)iterator.next()))) continue;
            iterator.remove();
        }
        session2.collectCaptureDependencies(this, dependencies);
        return dependencies;
    }

    private void collectTransitiveDependencies(InferenceSession session2, Set<InferenceVariable> dependencies, Set<InferenceVariable> rootDependencies) {
        LinkedHashSet<InferenceVariable> newDependencies = new LinkedHashSet<InferenceVariable>();
        for (InferenceVariable dependency : dependencies) {
            dependency.collectBoundDependencies(session2, newDependencies);
        }
        newDependencies.removeAll(rootDependencies);
        newDependencies.remove((Object)this);
        if (!newDependencies.isEmpty()) {
            rootDependencies.addAll(newDependencies);
            this.collectTransitiveDependencies(session2, newDependencies, rootDependencies);
        }
    }

    private void collectBoundDependencies(InferenceSession session2, Set<InferenceVariable> dependencies) {
        for (Collection collection : this.myBounds.values()) {
            if (collection == null) continue;
            for (PsiType bound : collection) {
                session2.collectDependencies(bound, dependencies);
            }
        }
    }

    public boolean isThrownBound() {
        return this.myThrownBound;
    }

    public void setThrownBound() {
        this.myThrownBound = true;
    }

    @Override
    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        for (PsiType type2 : this.getBounds(InferenceBound.UPPER)) {
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
            if (psiClass == null) continue;
            if (this.getManager().areElementsEquivalent((PsiElement)baseClass, (PsiElement)psiClass)) {
                return true;
            }
            if (!checkDeep || !psiClass.isInheritor(baseClass, true)) continue;
            return true;
        }
        return super.isInheritor(baseClass, checkDeep);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }

    @Override
    public boolean useDelegateToSubstitute() {
        return false;
    }

    @Override
    public String toString() {
        return this.getDelegate().toString();
    }

    @Override
    public PsiTypeParameterListOwner getOwner() {
        return null;
    }

    @Override
    @Nullable
    public String getName() {
        return this.myName;
    }

    public PsiElement getCallContext() {
        return this.myContext;
    }
}

