/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInferenceHelper;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSessionContainer;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiGraphInferenceHelper
implements PsiInferenceHelper {
    private final PsiManager myManager;

    public PsiGraphInferenceHelper(PsiManager manager) {
        this.myManager = manager;
    }

    public PsiType inferTypeForMethodTypeParameter(@NotNull PsiTypeParameter typeParameter, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor partialSubstitutor, @Nullable PsiElement parent, @NotNull ParameterTypeInferencePolicy policy) {
        PsiSubstitutor substitutor;
        if (parent != null) {
            substitutor = this.inferTypeArguments(new PsiTypeParameter[]{typeParameter}, parameters2, arguments, partialSubstitutor, parent, policy, PsiUtil.getLanguageLevel((PsiElement)parent));
        } else {
            InferenceSession inferenceSession = new InferenceSession(new PsiTypeParameter[]{typeParameter}, partialSubstitutor, this.myManager, null);
            inferenceSession.initExpressionConstraints(parameters2, arguments, null);
            substitutor = inferenceSession.infer();
        }
        return substitutor.substitute(typeParameter);
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent, @NotNull ParameterTypeInferencePolicy policy, @NotNull LanguageLevel languageLevel) {
        if (typeParameters.length == 0) {
            return partialSubstitutor;
        }
        return InferenceSessionContainer.infer(typeParameters, parameters2, arguments, partialSubstitutor, parent, policy);
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiType[] leftTypes, @NotNull PsiType[] rightTypes, @NotNull LanguageLevel languageLevel) {
        if (typeParameters.length == 0) {
            return PsiSubstitutor.EMPTY;
        }
        InferenceSession session2 = new InferenceSession(typeParameters, leftTypes, rightTypes, PsiSubstitutor.EMPTY, this.myManager, null);
        for (PsiType leftType : leftTypes) {
            if (session2.isProperType(session2.substituteWithInferenceVariables(leftType))) continue;
            return session2.infer();
        }
        for (PsiType rightType : rightTypes) {
            if (session2.isProperType(session2.substituteWithInferenceVariables(rightType))) continue;
            return session2.infer();
        }
        return PsiSubstitutor.EMPTY;
    }

    public PsiType getSubstitutionForTypeParameter(PsiTypeParameter typeParam, PsiType param, PsiType arg, boolean isContraVariantPosition, LanguageLevel languageLevel) {
        PsiTypeParameter[] psiTypeParameterArray;
        PsiType[] rightTypes;
        PsiType[] leftTypes;
        if (PsiType.VOID.equals((Object)arg) || PsiType.VOID.equals((Object)param)) {
            return PsiType.NULL;
        }
        if (param instanceof PsiArrayType && arg instanceof PsiArrayType) {
            return this.getSubstitutionForTypeParameter(typeParam, ((PsiArrayType)param).getComponentType(), ((PsiArrayType)arg).getComponentType(), isContraVariantPosition, languageLevel);
        }
        if (!(param instanceof PsiClassType)) {
            return PsiType.NULL;
        }
        if (arg == null) {
            return PsiType.NULL;
        }
        if (isContraVariantPosition) {
            leftTypes = new PsiType[]{param};
            rightTypes = new PsiType[]{arg};
        } else {
            leftTypes = new PsiType[]{arg};
            rightTypes = new PsiType[]{param};
        }
        PsiTypeParameterListOwner owner = typeParam.getOwner();
        if (owner != null) {
            psiTypeParameterArray = owner.getTypeParameters();
        } else {
            PsiTypeParameter[] psiTypeParameterArray2 = new PsiTypeParameter[1];
            psiTypeParameterArray = psiTypeParameterArray2;
            psiTypeParameterArray2[0] = typeParam;
        }
        PsiTypeParameter[] typeParams = psiTypeParameterArray;
        InferenceSession inferenceSession = new InferenceSession(typeParams, leftTypes, rightTypes, PsiSubstitutor.EMPTY, this.myManager, null);
        if (inferenceSession.isProperType(inferenceSession.substituteWithInferenceVariables(param)) && inferenceSession.isProperType(inferenceSession.substituteWithInferenceVariables(arg))) {
            boolean proceed = false;
            for (PsiClassType classType : typeParam.getExtendsListTypes()) {
                if (inferenceSession.isProperType(inferenceSession.substituteWithInferenceVariables((PsiType)classType))) continue;
                proceed = true;
                break;
            }
            if (!proceed) {
                return PsiType.NULL;
            }
        }
        PsiSubstitutor substitutor = inferenceSession.infer();
        return substitutor.substitute(typeParam);
    }
}

