/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMethodReferenceCompatibilityConstraint
implements ConstraintFormula {
    private static final Logger LOG = Logger.getInstance((String)("#" + PsiMethodReferenceCompatibilityConstraint.class.getName()));
    private final PsiMethodReferenceExpression myExpression;
    private PsiType myT;

    public PsiMethodReferenceCompatibilityConstraint(PsiMethodReferenceExpression expression2, PsiType t) {
        this.myExpression = expression2;
        this.myT = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reduce(InferenceSession session2, List<ConstraintFormula> constraints) {
        JavaResolveResult resolve2;
        if (!LambdaUtil.isFunctionalType((PsiType)this.myT)) {
            session2.registerIncompatibleErrorMessage(session2.getPresentableText(this.myT) + " is not a functional interface");
            return false;
        }
        PsiType groundTargetType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(this.myT);
        PsiClassType.ClassResolveResult classResolveResult = PsiUtil.resolveGenericsClassInType((PsiType)groundTargetType);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)classResolveResult);
        if (interfaceMethod == null) {
            session2.registerIncompatibleErrorMessage("No valid function type can be found for " + session2.getPresentableText(this.myT));
            return false;
        }
        PsiSubstitutor substitutor = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)classResolveResult);
        MethodSignature signature = interfaceMethod.getSignature(substitutor);
        PsiParameter[] targetParameters = interfaceMethod.getParameterList().getParameters();
        PsiType interfaceMethodReturnType = interfaceMethod.getReturnType();
        PsiType returnType = substitutor.substitute(interfaceMethodReturnType);
        PsiType[] typeParameters = this.myExpression.getTypeParameters();
        PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult((PsiMethodReferenceExpression)this.myExpression);
        if (this.myExpression.isExact()) {
            PsiParameter[] parameters2;
            PsiMember applicableMember = this.myExpression.getPotentiallyApplicableMember();
            LOG.assertTrue(applicableMember != null);
            PsiClass applicableMemberContainingClass = applicableMember.getContainingClass();
            PsiClass containingClass = qualifierResolveResult.getContainingClass();
            PsiSubstitutor psiSubstitutor = PsiMethodReferenceCompatibilityConstraint.getSubstitutor(signature, qualifierResolveResult, applicableMember, applicableMemberContainingClass, this.myExpression);
            int idx = 0;
            for (PsiTypeParameter param : ((PsiTypeParameterListOwner)applicableMember).getTypeParameters()) {
                if (idx >= typeParameters.length) continue;
                psiSubstitutor = psiSubstitutor.put(param, typeParameters[idx++]);
            }
            PsiParameter[] psiParameterArray = parameters2 = applicableMember instanceof PsiMethod ? ((PsiMethod)applicableMember).getParameterList().getParameters() : PsiParameter.EMPTY_ARRAY;
            if (targetParameters.length == parameters2.length + 1) {
                PsiType qualifierType = PsiMethodReferenceUtil.getQualifierType((PsiMethodReferenceExpression)this.myExpression);
                PsiClass qualifierClass = PsiUtil.resolveClassInType((PsiType)qualifierType);
                if (qualifierClass != null) {
                    PsiType pType = signature.getParameterTypes()[0];
                    constraints.add(new StrictSubtypingConstraint(session2.substituteWithInferenceVariables(qualifierType), pType));
                }
                for (int i2 = 1; i2 < targetParameters.length; ++i2) {
                    constraints.add(new TypeCompatibilityConstraint(session2.substituteWithInferenceVariables(psiSubstitutor.substitute(parameters2[i2 - 1].getType())), PsiUtil.captureToplevelWildcards((PsiType)signature.getParameterTypes()[i2], (PsiElement)this.myExpression)));
                }
            } else if (targetParameters.length == parameters2.length) {
                for (int i3 = 0; i3 < targetParameters.length; ++i3) {
                    constraints.add(new TypeCompatibilityConstraint(session2.substituteWithInferenceVariables(psiSubstitutor.substitute(parameters2[i3].getType())), PsiUtil.captureToplevelWildcards((PsiType)signature.getParameterTypes()[i3], (PsiElement)this.myExpression)));
                }
            } else {
                session2.registerIncompatibleErrorMessage("Incompatible parameter types in method reference expression");
                return false;
            }
            if (!PsiType.VOID.equals((Object)returnType) && returnType != null) {
                PsiType applicableMethodReturnType = null;
                if (applicableMember instanceof PsiMethod) {
                    PsiType getClassReturnType = PsiTypesUtil.patchMethodGetClassReturnType((PsiMethodReferenceExpression)this.myExpression, (PsiMethod)((PsiMethod)applicableMember));
                    PsiType psiType = applicableMethodReturnType = getClassReturnType != null ? getClassReturnType : ((PsiMethod)applicableMember).getReturnType();
                }
                if (PsiType.VOID.equals(applicableMethodReturnType)) {
                    session2.registerIncompatibleErrorMessage("Incompatible types: expected not void but compile-time declaration for the method reference has void return type");
                    return false;
                }
                if (applicableMethodReturnType == null && (applicableMember instanceof PsiClass || applicableMember instanceof PsiMethod && ((PsiMethod)applicableMember).isConstructor()) && containingClass != null) {
                    applicableMethodReturnType = JavaPsiFacade.getElementFactory((Project)applicableMember.getProject()).createType(containingClass, PsiSubstitutor.EMPTY);
                }
                if (applicableMethodReturnType != null) {
                    PsiType capturedReturnType = PsiUtil.captureToplevelWildcards((PsiType)psiSubstitutor.substitute(applicableMethodReturnType), (PsiElement)this.myExpression);
                    constraints.add(new TypeCompatibilityConstraint(returnType, session2.substituteWithInferenceVariables(capturedReturnType)));
                }
            }
            return true;
        }
        for (PsiType paramType : signature.getParameterTypes()) {
            if (session2.isProperType(paramType)) continue;
            return false;
        }
        Map map2 = LambdaUtil.getFunctionalTypeMap();
        PsiType added = map2.put(this.myExpression, session2.startWithFreshVars(groundTargetType));
        try {
            resolve2 = this.myExpression.advancedResolve(true);
        }
        finally {
            if (added == null) {
                map2.remove(this.myExpression);
            }
        }
        PsiElement element = resolve2.getElement();
        if (element == null || resolve2 instanceof MethodCandidateInfo && !((MethodCandidateInfo)resolve2).isApplicable()) {
            session2.registerIncompatibleErrorMessage("No compile-time declaration for the method reference is found");
            return false;
        }
        if (PsiType.VOID.equals((Object)returnType) || returnType == null) {
            return true;
        }
        if (element instanceof PsiMethod) {
            PsiType getClassReturnType;
            PsiMethod method2 = (PsiMethod)element;
            PsiClass containingClass = method2.getContainingClass();
            LOG.assertTrue(containingClass != null, (Object)method2);
            PsiSubstitutor psiSubstitutor = PsiMethodReferenceCompatibilityConstraint.getSubstitutor(signature, qualifierResolveResult, (PsiMember)method2, containingClass, this.myExpression);
            Object referencedMethodReturnType = method2.isConstructor() ? JavaPsiFacade.getElementFactory((Project)method2.getProject()).createType(containingClass, PsiSubstitutor.EMPTY) : ((getClassReturnType = PsiTypesUtil.patchMethodGetClassReturnType((PsiMethodReferenceExpression)this.myExpression, (PsiMethod)method2)) != null ? getClassReturnType : method2.getReturnType());
            LOG.assertTrue(referencedMethodReturnType != null, (Object)method2);
            if (typeParameters.length == 0 && method2.getTypeParameters().length > 0) {
                PsiClass interfaceClass = classResolveResult.getElement();
                LOG.assertTrue(interfaceClass != null);
                if (PsiPolyExpressionUtil.mentionsTypeParameters((PsiType)referencedMethodReturnType, (Set)ContainerUtil.newHashSet((Object[])method2.getTypeParameters())).booleanValue()) {
                    session2.initBounds((PsiElement)this.myExpression, psiSubstitutor, method2.getTypeParameters());
                    session2.collectApplicabilityConstraints(this.myExpression, (MethodCandidateInfo)resolve2, groundTargetType);
                    session2.registerReturnTypeConstraints(psiSubstitutor.substitute((PsiType)referencedMethodReturnType), returnType);
                    return true;
                }
            }
            if (PsiType.VOID.equals(referencedMethodReturnType)) {
                session2.registerIncompatibleErrorMessage("Incompatible types: expected not void but compile-time declaration for the method reference has void return type");
                return false;
            }
            int idx = 0;
            for (PsiTypeParameter param : method2.getTypeParameters()) {
                if (idx >= typeParameters.length) continue;
                psiSubstitutor = psiSubstitutor.put(param, typeParameters[idx++]);
            }
            if (this.myExpression.isConstructor() && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)qualifierResolveResult.getSubstitutor())) {
                session2.initBounds((PsiElement)this.myExpression, containingClass.getTypeParameters());
            }
            PsiType capturedReturnType = PsiUtil.captureToplevelWildcards((PsiType)psiSubstitutor.substitute((PsiType)referencedMethodReturnType), (PsiElement)this.myExpression);
            constraints.add(new TypeCompatibilityConstraint(returnType, session2.substituteWithInferenceVariables(capturedReturnType)));
        }
        return true;
    }

    public static PsiSubstitutor getSubstitutor(MethodSignature signature, PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, PsiMember member, @Nullable PsiClass containingClass, PsiMethodReferenceExpression methodReferenceExpression) {
        PsiClass qContainingClass = qualifierResolveResult.getContainingClass();
        PsiSubstitutor psiSubstitutor = qualifierResolveResult.getSubstitutor();
        if (qContainingClass != null && containingClass != null) {
            if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)qContainingClass, (PsiSubstitutor)psiSubstitutor)) {
                if (member instanceof PsiMethod && PsiMethodReferenceUtil.isSecondSearchPossible((PsiType[])signature.getParameterTypes(), (PsiMethodReferenceUtil.QualifierResolveResult)qualifierResolveResult, (PsiMethodReferenceExpression)methodReferenceExpression)) {
                    PsiType pType = PsiUtil.captureToplevelWildcards((PsiType)signature.getParameterTypes()[0], (PsiElement)methodReferenceExpression);
                    psiSubstitutor = PsiMethodReferenceCompatibilityConstraint.getParameterizedTypeSubstitutor(qContainingClass, pType);
                } else if (member instanceof PsiMethod && ((PsiMethod)member).isConstructor() || member instanceof PsiClass) {
                    PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)methodReferenceExpression.getProject()).getResolveHelper();
                    PsiType[] paramTypes = member instanceof PsiMethod ? ((PsiMethod)member).getSignature(PsiSubstitutor.EMPTY).getParameterTypes() : PsiType.EMPTY_ARRAY;
                    LOG.assertTrue(paramTypes.length == signature.getParameterTypes().length, (Object)("expr: " + methodReferenceExpression + "; " + paramTypes.length + "; " + Arrays.toString(signature.getParameterTypes())));
                    psiSubstitutor = helper.inferTypeArguments(qContainingClass.getTypeParameters(), paramTypes, signature.getParameterTypes(), PsiUtil.getLanguageLevel((PsiElement)methodReferenceExpression));
                } else {
                    psiSubstitutor = PsiSubstitutor.EMPTY;
                }
            }
            if (qContainingClass.isInheritor(containingClass, true)) {
                LOG.assertTrue((psiSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)containingClass, (PsiClass)qContainingClass, (PsiSubstitutor)psiSubstitutor)) != null);
            }
        }
        return psiSubstitutor;
    }

    public static PsiSubstitutor getParameterizedTypeSubstitutor(PsiClass qContainingClass, @NotNull PsiType pType) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiClass paramClass;
        if (pType instanceof PsiIntersectionType) {
            for (PsiType type2 : ((PsiIntersectionType)pType).getConjuncts()) {
                PsiClassType.ClassResolveResult resolveResult2 = PsiUtil.resolveGenericsClassInType((PsiType)type2);
                if (!InheritanceUtil.isInheritorOrSelf((PsiClass)resolveResult2.getElement(), (PsiClass)qContainingClass, (boolean)true)) continue;
                return PsiMethodReferenceCompatibilityConstraint.getParameterizedTypeSubstitutor(qContainingClass, type2);
            }
        } else if (pType instanceof PsiCapturedWildcardType) {
            pType = ((PsiCapturedWildcardType)pType).getUpperBound();
        }
        LOG.assertTrue((paramClass = (resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)pType)).getElement()) != null, (Object)pType.getCanonicalText());
        PsiSubstitutor psiSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)qContainingClass, (PsiClass)paramClass, (PsiSubstitutor)resolveResult.getSubstitutor());
        LOG.assertTrue(psiSubstitutor != null);
        return psiSubstitutor;
    }

    @Override
    public void apply(PsiSubstitutor substitutor, boolean cache2) {
        this.myT = substitutor.substitute(this.myT);
    }

    public String toString() {
        return this.myExpression.getText() + " -> " + this.myT.getPresentableText();
    }
}

