/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

public class JavaReflectionCompletionContributor
extends CompletionContributor {
    private static final String CONSTRUCTOR = "getConstructor";
    private static final String DECLARED_CONSTRUCTOR = "getDeclaredConstructor";
    private static final String ANNOTATION = "getAnnotation";
    private static final String DECLARED_ANNOTATION = "getDeclaredAnnotation";
    private static final String ANNOTATIONS_BY_TYPE = "getAnnotationsByType";
    private static final String DECLARED_ANNOTATIONS_BY_TYPE = "getDeclaredAnnotationsByType";
    private static final String ANNOTATED_ELEMENT = "java.lang.reflect.AnnotatedElement";
    private static final Set<String> DECLARED_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"getDeclaredConstructor", "getDeclaredAnnotation", "getDeclaredAnnotationsByType"});
    private static final ElementPattern<? extends PsiElement> CONSTRUCTOR_ARGUMENTS = PsiJavaPatterns.psiElement(PsiExpressionList.class).withParent((ElementPattern)PsiJavaPatterns.psiExpression().methodCall((ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName(new String[]{"getConstructor", "getDeclaredConstructor"})).definedInClass("java.lang.Class")));
    private static final ElementPattern<? extends PsiElement> ANNOTATION_ARGUMENTS = PsiJavaPatterns.psiElement(PsiExpressionList.class).withParent((ElementPattern)PsiJavaPatterns.psiExpression().methodCall((ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName(new String[]{"getAnnotation", "getDeclaredAnnotation", "getAnnotationsByType", "getDeclaredAnnotationsByType"})).with((PatternCondition)new MethodDefinedInInterfacePatternCondition("java.lang.reflect.AnnotatedElement"))));
    private static final ElementPattern<PsiElement> BEGINNING_OF_CONSTRUCTOR_ARGUMENTS = JavaReflectionCompletionContributor.beginningOfArguments(CONSTRUCTOR_ARGUMENTS);
    private static final ElementPattern<PsiElement> BEGINNING_OF_ANNOTATION_ARGUMENTS = JavaReflectionCompletionContributor.beginningOfArguments(ANNOTATION_ARGUMENTS);

    private static ElementPattern<PsiElement> beginningOfArguments(ElementPattern<? extends PsiElement> argumentsPattern) {
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"("})).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiExpression().withParent(argumentsPattern), ((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent(PsiTypeElement.class)).withSuperParent(2, PsiClassObjectAccessExpression.class)).withSuperParent(3, argumentsPattern)}));
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        if (parameters2.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        PsiElement position = parameters2.getPosition();
        if (!JavaCompletionContributor.isInJavaContext(position)) {
            return;
        }
        if (BEGINNING_OF_ANNOTATION_ARGUMENTS.accepts((Object)position)) {
            JavaReflectionCompletionContributor.addVariants(position, (psiClass, isDeclared) -> JavaReflectionCompletionContributor.addAnnotationClasses(psiClass, isDeclared, result2));
        } else if (BEGINNING_OF_CONSTRUCTOR_ARGUMENTS.accepts((Object)position)) {
            JavaReflectionCompletionContributor.addVariants(position, (psiClass, isDeclared) -> JavaReflectionCompletionContributor.addConstructorParameterTypes(psiClass, isDeclared, result2));
        }
    }

    private static void addVariants(PsiElement position, BiConsumer<PsiClass, Boolean> variantAdder) {
        String methodName;
        PsiClass psiClass;
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiMethodCallExpression.class);
        if (methodCall != null && (psiClass = JavaReflectionReferenceUtil.getReflectiveClass(methodCall.getMethodExpression().getQualifierExpression())) != null && (methodName = methodCall.getMethodExpression().getReferenceName()) != null) {
            variantAdder.accept(psiClass, DECLARED_NAMES.contains(methodName));
        }
    }

    private static void addAnnotationClasses(@NotNull PsiClass psiClass, boolean isDeclared, @NotNull CompletionResultSet result2) {
        PsiAnnotation[] annotations2;
        Set declaredAnnotations = isDeclared ? ContainerUtil.set((Object[])AnnotationUtil.getAllAnnotations((PsiModifierListOwner)psiClass, (boolean)false, null, (boolean)false)) : null;
        for (PsiAnnotation annotation : annotations2 = AnnotationUtil.getAllAnnotations((PsiModifierListOwner)psiClass, (boolean)true, null, (boolean)false)) {
            PsiClass annotationClass;
            String className;
            PsiElement resolved;
            PsiJavaCodeReferenceElement referenceElement = annotation.getNameReferenceElement();
            if (referenceElement == null || !((resolved = referenceElement.resolve()) instanceof PsiClass) || (className = (annotationClass = (PsiClass)resolved).getName()) == null) continue;
            LookupElementBuilder lookupElement = LookupElementBuilder.createWithIcon((PsiNamedElement)annotationClass).withPresentableText(className + ".class").withInsertHandler(JavaReflectionCompletionContributor::handleAnnotationClassInsertion);
            if (isDeclared) {
                lookupElement = JavaReflectionReferenceUtil.withPriority((LookupElement)lookupElement, declaredAnnotations.contains(annotation));
            }
            result2.addElement((LookupElement)lookupElement);
        }
    }

    private static void addConstructorParameterTypes(@NotNull PsiClass psiClass, boolean isDeclared, @NotNull CompletionResultSet result2) {
        PsiMethod[] constructors;
        for (PsiMethod constructor : constructors = psiClass.getConstructors()) {
            LookupElementBuilder lookupElement = JavaLookupElementBuilder.forMethod(constructor, PsiSubstitutor.EMPTY).withInsertHandler(JavaReflectionCompletionContributor::handleConstructorSignatureInsertion);
            if (isDeclared) {
                lookupElement = JavaReflectionReferenceUtil.withPriority((LookupElement)lookupElement, JavaReflectionReferenceUtil.isPublic((PsiMember)constructor));
            }
            result2.addElement((LookupElement)lookupElement);
        }
    }

    private static void handleAnnotationClassInsertion(@NotNull InsertionContext context, @NotNull LookupElement item) {
        String className;
        Object object = item.getObject();
        if (object instanceof PsiClass && (className = ((PsiClass)object).getQualifiedName()) != null) {
            JavaReflectionCompletionContributor.handleParametersInsertion(context, className + ".class");
        }
    }

    private static void handleConstructorSignatureInsertion(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Object object = item.getObject();
        if (object instanceof PsiMethod) {
            JavaReflectionCompletionContributor.handleParametersInsertion(context, JavaReflectionReferenceUtil.getParameterTypesText((PsiMethod)object));
        }
    }

    private static void handleParametersInsertion(@NotNull InsertionContext context, @NotNull String text) {
        PsiElement newElement = PsiUtilCore.getElementAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset());
        PsiExpressionList parameterList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)newElement, PsiExpressionList.class);
        if (parameterList != null) {
            TextRange range = parameterList.getTextRange();
            context.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)("(" + text + ")"));
            context.commitDocument();
            JavaReflectionReferenceUtil.shortenArgumentsClassReferences(context);
        }
    }

    private static class MethodDefinedInInterfacePatternCondition
    extends PatternCondition<PsiMethod> {
        private final String myInterfaceName;

        public MethodDefinedInInterfacePatternCondition(@NotNull String interfaceName) {
            super("definedInInterface");
            this.myInterfaceName = interfaceName;
        }

        public boolean accepts(@NotNull PsiMethod method2, ProcessingContext context) {
            PsiClass containingClass = method2.getContainingClass();
            return InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)false, (String)this.myInterfaceName);
        }
    }
}

