/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaReflectionReferenceUtil {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard((String)"JavaLangClassMemberReference");

    JavaReflectionReferenceUtil() {
    }

    @Nullable
    static PsiClass getReflectiveClass(PsiExpression context) {
        PsiExpression definition;
        PsiElement resolved;
        PsiType type2;
        if ((context = ParenthesesUtils.stripParentheses(context)) instanceof PsiClassObjectAccessExpression) {
            PsiTypeElement operand2 = ((PsiClassObjectAccessExpression)context).getOperand();
            return PsiTypesUtil.getPsiClass((PsiType)operand2.getType());
        }
        if (context instanceof PsiMethodCallExpression) {
            PsiMethod method2;
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)context;
            String methodReferenceName = methodCall.getMethodExpression().getReferenceName();
            if ("forName".equals(methodReferenceName)) {
                PsiExpression[] expressions2;
                method2 = methodCall.resolveMethod();
                if (method2 != null && JavaReflectionReferenceUtil.isJavaLangClass(method2.getContainingClass()) && (expressions2 = methodCall.getArgumentList().getExpressions()).length == 1) {
                    Object value2;
                    PsiExpression argument = ParenthesesUtils.stripParentheses(expressions2[0]);
                    if (argument instanceof PsiReferenceExpression) {
                        argument = JavaReflectionReferenceUtil.findVariableDefinition((PsiReferenceExpression)argument);
                    }
                    if ((value2 = JavaConstantExpressionEvaluator.computeConstantExpression(argument, false)) instanceof String) {
                        Project project2 = context.getProject();
                        return JavaPsiFacade.getInstance((Project)project2).findClass((String)value2, GlobalSearchScope.allScope((Project)project2));
                    }
                }
            } else if ("getClass".equals(methodReferenceName) && methodCall.getArgumentList().getExpressions().length == 0 && (method2 = methodCall.resolveMethod()) != null && JavaReflectionReferenceUtil.isJavaLangObject(method2.getContainingClass())) {
                PsiClass actualClass;
                PsiExpression definition2;
                PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodCall.getMethodExpression().getQualifierExpression());
                if (qualifier instanceof PsiReferenceExpression && (definition2 = JavaReflectionReferenceUtil.findVariableDefinition((PsiReferenceExpression)qualifier)) != null && (actualClass = PsiTypesUtil.getPsiClass((PsiType)definition2.getType())) != null) {
                    return actualClass;
                }
                if (qualifier != null) {
                    return PsiTypesUtil.getPsiClass((PsiType)qualifier.getType());
                }
            }
        }
        if ((type2 = context.getType()) instanceof PsiClassType) {
            PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)type2).resolveGenerics();
            if (!JavaReflectionReferenceUtil.isJavaLangClass(resolveResult.getElement())) {
                return null;
            }
            PsiTypeParameter[] parameters2 = resolveResult.getElement().getTypeParameters();
            if (parameters2.length == 1) {
                PsiClass argumentClass;
                PsiType typeArgument = resolveResult.getSubstitutor().substitute(parameters2[0]);
                if (typeArgument instanceof PsiCapturedWildcardType) {
                    typeArgument = ((PsiCapturedWildcardType)typeArgument).getUpperBound();
                }
                if ((argumentClass = PsiTypesUtil.getPsiClass((PsiType)typeArgument)) != null && !JavaReflectionReferenceUtil.isJavaLangObject(argumentClass)) {
                    return argumentClass;
                }
            }
        }
        if (context instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)context).resolve()) instanceof PsiVariable && (definition = JavaReflectionReferenceUtil.findVariableDefinition((PsiReferenceExpression)context, (PsiVariable)resolved)) != null) {
            return (PsiClass)ourGuard.doPreventingRecursion((Object)resolved, false, () -> JavaReflectionReferenceUtil.getReflectiveClass(definition));
        }
        return null;
    }

    private static PsiExpression findVariableDefinition(@NotNull PsiReferenceExpression referenceExpression) {
        PsiElement resolved = referenceExpression.resolve();
        return resolved instanceof PsiVariable ? JavaReflectionReferenceUtil.findVariableDefinition(referenceExpression, (PsiVariable)resolved) : null;
    }

    private static PsiExpression findVariableDefinition(@NotNull PsiReferenceExpression referenceExpression, @NotNull PsiVariable variable) {
        PsiExpression initializer;
        if (variable.hasModifierProperty("final") && (initializer = variable.getInitializer()) != null) {
            return initializer;
        }
        return DeclarationSearchUtils.findDefinition(referenceExpression, variable);
    }

    static boolean isJavaLangClass(PsiClass aClass) {
        return aClass != null && "java.lang.Class".equals(aClass.getQualifiedName());
    }

    static boolean isJavaLangObject(PsiClass aClass) {
        return aClass != null && "java.lang.Object".equals(aClass.getQualifiedName());
    }

    @Contract(value="null -> false")
    static boolean isRegularMethod(PsiMethod method2) {
        return method2 != null && !method2.isConstructor();
    }

    @Contract(value="null, _ -> false")
    static boolean isPotentiallyAccessible(PsiMember member, PsiClass psiClass) {
        return member != null && (member.getContainingClass() == psiClass || JavaReflectionReferenceUtil.isPublic(member));
    }

    static boolean isPublic(@NotNull PsiMember member) {
        return member.hasModifierProperty("public");
    }

    @NotNull
    static String getParameterTypesText(@NotNull PsiMethod method2) {
        return Arrays.stream(method2.getParameterList().getParameters()).map(parameter -> TypeConversionUtil.erasure((PsiType)parameter.getType())).map(type2 -> type2 instanceof PsiEllipsisType ? new PsiArrayType(((PsiEllipsisType)type2).getComponentType()) : type2).map(type2 -> type2.getPresentableText() + ".class").collect(Collectors.joining(", "));
    }

    static void shortenArgumentsClassReferences(@NotNull InsertionContext context) {
        PsiElement firstParam = PsiUtilCore.getElementAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset());
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)firstParam, PsiMethodCallExpression.class);
        if (methodCall != null) {
            JavaCodeStyleManager.getInstance((Project)context.getProject()).shortenClassReferences((PsiElement)methodCall.getArgumentList());
        }
    }

    @NotNull
    static LookupElement withPriority(LookupElement lookupElement, boolean hasPriority) {
        return hasPriority ? lookupElement : PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)-1.0);
    }

    @NotNull
    static LookupElement withPriority(LookupElement lookupElement, int priority) {
        return priority == 0 ? lookupElement : PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)priority);
    }
}

