/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiCommentManipulator
extends AbstractElementManipulator<PsiComment> {
    public PsiComment handleContentChange(@NotNull PsiComment psiComment, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        String oldText = psiComment.getText();
        String newText = oldText.substring(0, range.getStartOffset()) + newContent + oldText.substring(range.getEndOffset());
        FileType type2 = psiComment.getContainingFile().getFileType();
        PsiFile fromText = PsiFileFactory.getInstance((Project)psiComment.getProject()).createFileFromText("__." + type2.getDefaultExtension(), type2, (CharSequence)newText);
        PsiComment newElement = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)fromText.findElementAt(0), psiComment.getClass(), (boolean)false);
        assert (newElement != null) : type2 + " " + type2.getDefaultExtension() + " " + newText;
        return (PsiComment)psiComment.replace((PsiElement)newElement);
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull PsiComment element) {
        String text = element.getText();
        if (text.startsWith("//")) {
            return new TextRange(2, element.getTextLength());
        }
        int length = text.length();
        if (length > 4 && text.startsWith("/**") && text.endsWith("*/")) {
            return new TextRange(3, element.getTextLength() - 2);
        }
        if (length > 3 && text.startsWith("/*") && text.endsWith("*/")) {
            return new TextRange(2, element.getTextLength() - 2);
        }
        if (length > 6 && text.startsWith("<!--") && text.endsWith("-->")) {
            return new TextRange(4, element.getTextLength() - 3);
        }
        if (text.startsWith("--")) {
            return new TextRange(2, element.getTextLength());
        }
        if (text.startsWith("#")) {
            return new TextRange(1, element.getTextLength());
        }
        return super.getRangeInElement((PsiElement)element);
    }
}

