/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiDocTagValueManipulator
extends AbstractElementManipulator<PsiDocTag> {
    public PsiDocTag handleContentChange(@NotNull PsiDocTag tag, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        StringBuilder replacement = new StringBuilder(tag.getText());
        replacement.replace(range.getStartOffset(), range.getEndOffset(), newContent);
        return (PsiDocTag)tag.replace((PsiElement)JavaPsiFacade.getInstance((Project)tag.getProject()).getElementFactory().createDocTagFromText(replacement.toString()));
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull PsiDocTag tag) {
        PsiElement[] elements = tag.getDataElements();
        if (elements.length == 0) {
            PsiElement name = tag.getNameElement();
            int offset = name.getStartOffsetInParent() + name.getTextLength();
            return new TextRange(offset, offset);
        }
        PsiElement first = elements[0];
        PsiElement last = elements[elements.length - 1];
        return new TextRange(first.getStartOffsetInParent(), last.getStartOffsetInParent() + last.getTextLength());
    }
}

