/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class XmlAttributeManipulator
extends AbstractElementManipulator<XmlAttribute> {
    private static final Logger LOG = Logger.getInstance(XmlAttributeManipulator.class);

    public XmlAttribute handleContentChange(@NotNull XmlAttribute attribute, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        String attr = attribute.getText();
        ASTNode astNode = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(attribute.getNode());
        assert (astNode != null);
        PsiElement namePsi = astNode.getPsi();
        int startOffsetInParent = namePsi.getStartOffsetInParent();
        TextRange nameRange = new TextRange(startOffsetInParent, startOffsetInParent + namePsi.getTextLength());
        if (nameRange.contains(range)) {
            String content = attr.substring(0, range.getStartOffset()) + newContent + attr.substring(range.getEndOffset(), nameRange.getEndOffset());
            attribute.setName(content);
        } else {
            XmlAttributeValue value2 = attribute.getValueElement();
            if (value2 == null) {
                assert (range.getStartOffset() == 0 && range.getEndOffset() == 0);
                attribute.setValue(newContent);
                return attribute;
            }
            StringBuilder replacement = new StringBuilder(value2.getText());
            int offset = value2.getTextRange().getStartOffset() - attribute.getTextRange().getStartOffset();
            replacement.replace(range.getStartOffset() - offset, range.getEndOffset() - offset, newContent);
            attribute.setValue(replacement.toString());
        }
        return attribute;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull XmlAttribute attribute) {
        XmlAttributeValue value2 = attribute.getValueElement();
        if (value2 == null) {
            return TextRange.from((int)0, (int)0);
        }
        TextRange range = attribute.getValueTextRange();
        if (range == null) {
            LOG.error("Null range in " + attribute + " '" + attribute.getText() + "'");
        }
        return range.shiftRight(value2.getStartOffsetInParent());
    }
}

