/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class XmlTagManipulator
extends AbstractElementManipulator<XmlTag> {
    public XmlTag handleContentChange(@NotNull XmlTag tag, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        StringBuilder replacement = new StringBuilder(tag.getValue().getText());
        int valueOffset = tag.getValue().getTextRange().getStartOffset() - tag.getTextOffset();
        replacement.replace(range.getStartOffset() - valueOffset, range.getEndOffset() - valueOffset, newContent);
        tag.getValue().setEscapedText(replacement.toString());
        return tag;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull XmlTag tag) {
        if (tag.getSubTags().length > 0) {
            return TextRange.EMPTY_RANGE;
        }
        XmlTagValue value2 = tag.getValue();
        XmlText[] texts = value2.getTextElements();
        switch (texts.length) {
            case 0: {
                return value2.getTextRange().shiftRight(-tag.getTextOffset());
            }
            case 1: {
                return XmlTagManipulator.getValueRange(texts[0]);
            }
        }
        return TextRange.EMPTY_RANGE;
    }

    private static TextRange getValueRange(XmlText xmlText) {
        int offset = xmlText.getStartOffsetInParent();
        String value2 = xmlText.getValue();
        String trimmed = value2.trim();
        int i2 = value2.indexOf(trimmed);
        int start = xmlText.displayToPhysical(i2) + offset;
        return trimmed.isEmpty() ? new TextRange(start, start) : new TextRange(start, xmlText.displayToPhysical(i2 + trimmed.length() - 1) + offset + 1);
    }

    public static TextRange[] getValueRanges(@NotNull XmlTag tag) {
        XmlTagValue value2 = tag.getValue();
        XmlText[] texts = value2.getTextElements();
        if (texts.length == 0) {
            return new TextRange[]{value2.getTextRange().shiftRight(-tag.getTextOffset())};
        }
        TextRange[] ranges = new TextRange[texts.length];
        for (int i2 = 0; i2 < texts.length; ++i2) {
            ranges[i2] = XmlTagManipulator.getValueRange(texts[i2]);
        }
        return ranges;
    }
}

