/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class XmlTextManipulator
extends AbstractElementManipulator<XmlText> {
    public XmlText handleContentChange(@NotNull XmlText text, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        String newValue;
        String value2 = text.getValue();
        if (range.equals((Object)this.getRangeInElement(text))) {
            newValue = newContent;
        } else {
            StringBuilder replacement = new StringBuilder(value2);
            replacement.replace(range.getStartOffset(), range.getEndOffset(), newContent);
            newValue = replacement.toString();
        }
        if (Comparing.equal((String)value2, (String)newValue)) {
            return text;
        }
        if (!newValue.isEmpty()) {
            text.setValue(newValue);
        } else {
            text.deleteChildRange(text.getFirstChild(), text.getLastChild());
        }
        return text;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull XmlText text) {
        return XmlTextManipulator.getValueRange(text);
    }

    private static TextRange getValueRange(XmlText xmlText) {
        String value2 = xmlText.getValue();
        int i2 = value2.indexOf(value2);
        int start = xmlText.displayToPhysical(i2);
        return value2.isEmpty() ? new TextRange(start, start) : new TextRange(start, xmlText.displayToPhysical(i2 + value2.length() - 1) + 1);
    }
}

