/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class BasicAttributeValueReference
implements PsiReference {
    protected final PsiElement myElement;
    protected final TextRange myRange;

    public BasicAttributeValueReference(PsiElement element) {
        this(element, ElementManipulators.getValueTextRange((PsiElement)element));
    }

    public BasicAttributeValueReference(PsiElement element, int offset) {
        this(element, new TextRange(offset, element.getTextLength() - offset));
    }

    public BasicAttributeValueReference(PsiElement element, TextRange range) {
        this.myElement = element;
        this.myRange = range;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return this.myRange;
    }

    @NotNull
    public String getCanonicalText() {
        String s = this.myElement.getText();
        if (this.myRange.getStartOffset() < s.length() && this.myRange.getEndOffset() <= s.length()) {
            return this.myRange.substring(s);
        }
        return "";
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return ElementManipulators.getManipulator((PsiElement)this.myElement).handleContentChange(this.myElement, this.getRangeInElement(), newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.myElement.getManager().areElementsEquivalent(element, this.resolve());
    }
}

