/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import com.intellij.util.ProcessingContext;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomizingReferenceProvider
extends PsiReferenceProvider
implements CustomizableReferenceProvider {
    private final CustomizableReferenceProvider myProvider;
    @Nullable
    private Map<CustomizableReferenceProvider.CustomizationKey, Object> myOptions;

    public CustomizingReferenceProvider(@NotNull CustomizableReferenceProvider provider2) {
        this.myProvider = provider2;
    }

    public <Option> void addCustomization(CustomizableReferenceProvider.CustomizationKey<Option> key2, Option value2) {
        if (this.myOptions == null) {
            this.myOptions = new HashMap<CustomizableReferenceProvider.CustomizationKey, Object>(5);
        }
        this.myOptions.put(key2, value2);
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        this.myProvider.setOptions(this.myOptions);
        PsiReference[] referencesByElement = this.myProvider.getReferencesByElement(element, context);
        this.myProvider.setOptions(null);
        return referencesByElement;
    }

    @Override
    public void setOptions(@Nullable Map<CustomizableReferenceProvider.CustomizationKey, Object> options) {
        this.myOptions = options;
    }

    @Override
    @Nullable
    public Map<CustomizableReferenceProvider.CustomizationKey, Object> getOptions() {
        return this.myOptions;
    }
}

