/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaClassReferenceSet {
    public static final char DOT = '.';
    public static final char DOLLAR = '$';
    private static final char LT = '<';
    private static final char COMMA = ',';
    private JavaClassReference[] myReferences;
    private List<JavaClassReferenceSet> myNestedGenericParameterReferences;
    private JavaClassReferenceSet myContext;
    private PsiElement myElement;
    private final int myStartInElement;
    private final JavaClassReferenceProvider myProvider;

    public JavaClassReferenceSet(@NotNull String str, @NotNull PsiElement element, int startInElement, boolean isStatic, @NotNull JavaClassReferenceProvider provider2) {
        this(str, element, startInElement, isStatic, provider2, null);
    }

    private JavaClassReferenceSet(@NotNull String str, @NotNull PsiElement element, int startInElement, boolean isStatic, @NotNull JavaClassReferenceProvider provider2, JavaClassReferenceSet context) {
        this.myStartInElement = startInElement;
        this.myProvider = provider2;
        this.reparse(str, element, isStatic, context);
    }

    @NotNull
    public JavaClassReferenceProvider getProvider() {
        return this.myProvider;
    }

    @NotNull
    public TextRange getRangeInElement() {
        PsiReference[] references = this.getReferences();
        return new TextRange(references[0].getRangeInElement().getStartOffset(), references[references.length - 1].getRangeInElement().getEndOffset());
    }

    private void reparse(@NotNull String str, @NotNull PsiElement element, boolean isStaticImport, JavaClassReferenceSet context) {
        this.myElement = element;
        this.myContext = context;
        ArrayList<JavaClassReference> referencesList = new ArrayList<JavaClassReference>();
        int currentDot = -1;
        int referenceIndex = 0;
        boolean allowDollarInNames = this.isAllowDollarInNames();
        boolean allowGenerics = false;
        boolean allowGenericsCalculated = false;
        boolean parsingClassNames = true;
        while (parsingClassNames) {
            int beginIndex;
            char ch;
            int nextDotOrDollar = -1;
            for (int curIndex = currentDot + 1; curIndex < str.length(); ++curIndex) {
                ch = str.charAt(curIndex);
                if (ch == '.' || ch == '$' && allowDollarInNames) {
                    nextDotOrDollar = curIndex;
                    break;
                }
                if (ch != '<' && ch != ',') continue;
                if (!allowGenericsCalculated) {
                    allowGenerics = !isStaticImport && PsiUtil.isLanguageLevel5OrHigher((PsiElement)element);
                    allowGenericsCalculated = true;
                }
                if (!allowGenerics) continue;
                nextDotOrDollar = curIndex;
                break;
            }
            if (nextDotOrDollar == -1) {
                int j;
                for (int i2 = nextDotOrDollar = currentDot + 1; i2 < str.length() && Character.isJavaIdentifierPart(str.charAt(i2)); ++i2) {
                    ++nextDotOrDollar;
                }
                parsingClassNames = false;
                for (j = nextDotOrDollar; j < str.length() && Character.isWhitespace(str.charAt(j)); ++j) {
                }
                if (j < str.length()) {
                    Boolean aBoolean;
                    ch = str.charAt(j);
                    boolean recognized = false;
                    if (ch == '[') {
                        ++j;
                        while (j < str.length() && Character.isWhitespace(str.charAt(j))) {
                            ++j;
                        }
                        if (j < str.length() && (ch = str.charAt(j)) == ']') {
                            ++j;
                            while (j < str.length() && Character.isWhitespace(str.charAt(j))) {
                                ++j;
                            }
                            boolean bl = recognized = j == str.length();
                        }
                    }
                    if (!((aBoolean = JavaClassReferenceProvider.JVM_FORMAT.getValue(this.getOptions())) != null && aBoolean.booleanValue() || recognized)) {
                        nextDotOrDollar = -1;
                    }
                }
            }
            if (nextDotOrDollar != -1 && nextDotOrDollar < str.length()) {
                char c = str.charAt(nextDotOrDollar);
                if (c == '<') {
                    int end = str.lastIndexOf(62);
                    if (end != -1 && end > nextDotOrDollar) {
                        if (this.myNestedGenericParameterReferences == null) {
                            this.myNestedGenericParameterReferences = new ArrayList<JavaClassReferenceSet>(1);
                        }
                        this.myNestedGenericParameterReferences.add(new JavaClassReferenceSet(str.substring(nextDotOrDollar + 1, end), this.myElement, this.myStartInElement + nextDotOrDollar + 1, isStaticImport, this.myProvider, this));
                        parsingClassNames = false;
                    } else {
                        nextDotOrDollar = -1;
                    }
                } else if (',' == c && this.myContext != null) {
                    if (this.myContext.myNestedGenericParameterReferences == null) {
                        this.myContext.myNestedGenericParameterReferences = new ArrayList<JavaClassReferenceSet>(1);
                    }
                    this.myContext.myNestedGenericParameterReferences.add(new JavaClassReferenceSet(str.substring(nextDotOrDollar + 1), this.myElement, this.myStartInElement + nextDotOrDollar + 1, isStaticImport, this.myProvider, this));
                    parsingClassNames = false;
                }
            }
            for (beginIndex = currentDot + 1; beginIndex < nextDotOrDollar && Character.isWhitespace(str.charAt(beginIndex)); ++beginIndex) {
            }
            String subreferenceText = nextDotOrDollar > 0 ? str.substring(beginIndex, nextDotOrDollar) : str.substring(beginIndex);
            TextRange textRange = new TextRange(this.myStartInElement + beginIndex, this.myStartInElement + (nextDotOrDollar > 0 ? nextDotOrDollar : str.length()));
            JavaClassReference currentContextRef = this.createReference(referenceIndex, subreferenceText, textRange, isStaticImport);
            ++referenceIndex;
            referencesList.add(currentContextRef);
            currentDot = nextDotOrDollar;
            if (currentDot >= 0) continue;
            break;
        }
        this.myReferences = referencesList.toArray(new JavaClassReference[referencesList.size()]);
    }

    @NotNull
    protected JavaClassReference createReference(int referenceIndex, @NotNull String subreferenceText, @NotNull TextRange textRange, boolean staticImport) {
        return new JavaClassReference(this, textRange, referenceIndex, subreferenceText, staticImport);
    }

    public boolean isAllowDollarInNames() {
        Boolean aBoolean = this.myProvider.getOption(JavaClassReferenceProvider.ALLOW_DOLLAR_NAMES);
        return !Boolean.FALSE.equals(aBoolean) && this.myElement.getLanguage() instanceof XMLLanguage;
    }

    protected boolean isStaticSeparator(char c, boolean strict) {
        return this.isAllowDollarInNames() ? c == '$' : c == '.';
    }

    public void reparse(@NotNull PsiElement element, @NotNull TextRange range) {
        String text = range.substring(element.getText());
        this.reparse(text, element, false, this.myContext);
    }

    public JavaClassReference getReference(int index) {
        return this.myReferences[index];
    }

    @NotNull
    public JavaClassReference[] getAllReferences() {
        Object[] result2 = this.myReferences;
        if (this.myNestedGenericParameterReferences != null) {
            for (JavaClassReferenceSet set2 : this.myNestedGenericParameterReferences) {
                result2 = (JavaClassReference[])ArrayUtil.mergeArrays((Object[])result2, (Object[])set2.getAllReferences());
            }
        }
        return result2;
    }

    public boolean canReferencePackage(int index) {
        if (index == this.myReferences.length - 1) {
            return false;
        }
        String text = this.getElement().getText();
        return text.charAt(this.myReferences[index].getRangeInElement().getEndOffset()) != '$';
    }

    public boolean isSoft() {
        return this.myProvider.isSoft();
    }

    @NotNull
    public PsiElement getElement() {
        return this.myElement;
    }

    @NotNull
    public PsiReference[] getReferences() {
        return this.myReferences;
    }

    @Nullable
    public Map<CustomizableReferenceProvider.CustomizationKey, Object> getOptions() {
        return this.myProvider.getOptions();
    }

    @NotNull
    public String getUnresolvedMessagePattern(int index) {
        if (this.canReferencePackage(index)) {
            return JavaErrorMessages.message("error.cannot.resolve.class.or.package", new Object[0]);
        }
        return JavaErrorMessages.message("error.cannot.resolve.class", new Object[0]);
    }
}

