/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.StringFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFileSystemItemUtil {
    @Nullable
    static PsiFileSystemItem getCommonAncestor(PsiFileSystemItem file1, PsiFileSystemItem file2) {
        PsiFileSystemItem parent1;
        if (file1 == file2) {
            return file1;
        }
        int depth1 = PsiFileSystemItemUtil.getDepth(file1);
        int depth2 = PsiFileSystemItemUtil.getDepth(file2);
        PsiFileSystemItem parent2 = file2;
        for (parent1 = file1; depth1 > depth2 && parent1 != null; parent1 = parent1.getParent(), --depth1) {
        }
        while (depth2 > depth1 && parent2 != null) {
            parent2 = parent2.getParent();
            --depth2;
        }
        while (parent1 != null && parent2 != null && !parent1.equals(parent2)) {
            parent1 = parent1.getParent();
            parent2 = parent2.getParent();
        }
        return parent1;
    }

    private static int getDepth(PsiFileSystemItem file2) {
        int depth = 0;
        while (file2 != null) {
            ++depth;
            file2 = file2.getParent();
        }
        return depth;
    }

    @NotNull
    public static String getNotNullRelativePath(PsiFileSystemItem src, PsiFileSystemItem dst) throws IncorrectOperationException {
        String s = PsiFileSystemItemUtil.getRelativePath(src, dst);
        if (s == null) {
            throw new IncorrectOperationException("Cannot find path between files; src = " + src.getVirtualFile().getPresentableUrl() + "; dst = " + dst.getVirtualFile().getPresentableUrl());
        }
        return s;
    }

    @Nullable
    public static String getRelativePath(PsiFileSystemItem src, PsiFileSystemItem dst) {
        PsiFileSystemItem commonAncestor = PsiFileSystemItemUtil.getCommonAncestor(src, dst);
        if (commonAncestor != null) {
            StringBuilder buffer = new StringBuilder();
            if (!src.equals(commonAncestor)) {
                while (!commonAncestor.equals(src.getParent())) {
                    buffer.append("..").append('/');
                    src = src.getParent();
                    assert (src != null);
                }
            }
            buffer.append(PsiFileSystemItemUtil.getRelativePathFromAncestor(dst, commonAncestor));
            return buffer.toString();
        }
        return null;
    }

    @Nullable
    public static String getRelativePathFromAncestor(PsiFileSystemItem file2, PsiFileSystemItem ancestor) {
        int length = 0;
        PsiFileSystemItem parent = file2;
        while (true) {
            String name;
            if (parent == null) {
                return null;
            }
            if (parent.equals(ancestor)) break;
            if (length > 0) {
                ++length;
            }
            if ((name = parent.getName()) == null) {
                throw new AssertionError((Object)("Null name for " + parent + " of " + parent.getClass()));
            }
            length += name.length();
            parent = parent.getParent();
        }
        char[] chars = new char[length];
        int index = chars.length;
        parent = file2;
        while (!parent.equals(ancestor)) {
            if (index < length) {
                chars[--index] = 47;
            }
            String name = parent.getName();
            for (int i2 = name.length() - 1; i2 >= 0; --i2) {
                chars[--index] = name.charAt(i2);
            }
            parent = parent.getParent();
        }
        return StringFactory.createShared((char[])chars);
    }
}

