/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.SchemaReferencesProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.ComplexTypeDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeOrElementOrAttributeReference
implements PsiReference {
    @NonNls
    private static final String TARGET_NAMESPACE = "targetNamespace";
    private final PsiElement myElement;
    private TextRange myRange;
    private String nsPrefix;
    @Nullable
    private final ReferenceType myType;

    @Nullable
    public ReferenceType getType() {
        return this.myType;
    }

    public void setNamespacePrefix(String prefix) {
        this.nsPrefix = prefix;
    }

    protected TypeOrElementOrAttributeReference(PsiElement element, TextRange range, @Nullable ReferenceType type2) {
        this.myElement = element;
        this.myRange = range;
        assert (this.myRange.getLength() >= 0);
        this.myType = type2;
    }

    TypeOrElementOrAttributeReference(PsiElement element, TextRange range) {
        this(element, range, TypeOrElementOrAttributeReference.determineReferenceType(element));
    }

    @Nullable
    private static ReferenceType determineReferenceType(PsiElement element) {
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class);
        if (attribute == null) {
            return null;
        }
        XmlTag tag = attribute.getParent();
        String localName = tag.getLocalName();
        String attributeLocalName = attribute.getLocalName();
        if ("ref".equals(attributeLocalName) || "substitutionGroup".equals(attributeLocalName)) {
            if (localName.equals("group")) {
                return ReferenceType.GroupReference;
            }
            if (localName.equals("attributeGroup")) {
                return ReferenceType.AttributeGroupReference;
            }
            if ("element".equals(localName)) {
                return ReferenceType.ElementReference;
            }
            if ("attribute".equals(localName)) {
                return ReferenceType.AttributeReference;
            }
        } else if ("type".equals(attributeLocalName) || "base".equals(attributeLocalName) || "memberTypes".equals(attributeLocalName) || "itemType".equals(attributeLocalName)) {
            return ReferenceType.TypeReference;
        }
        return null;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return this.myRange;
    }

    @Nullable
    public PsiElement resolve() {
        PsiElement psiElement = ResolveCache.getInstance(this.getElement().getProject()).resolveWithCaching(this, MyResolver.INSTANCE, false, false);
        return psiElement != PsiUtilCore.NULL_PSI_ELEMENT ? psiElement : null;
    }

    private PsiElement resolveInner() {
        XmlTag tag = (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)this.myElement, XmlTag.class, (boolean)false);
        if (tag == null) {
            return PsiUtilCore.NULL_PSI_ELEMENT;
        }
        String canonicalText = this.getCanonicalText();
        boolean[] redefined = new boolean[1];
        XmlNSDescriptorImpl nsDescriptor = this.getDescriptor(tag, canonicalText, redefined);
        if (this.myType != null && nsDescriptor != null && nsDescriptor.getTag() != null) {
            switch (this.myType) {
                case GroupReference: {
                    return nsDescriptor.findGroup(canonicalText);
                }
                case AttributeGroupReference: {
                    return nsDescriptor.findAttributeGroup(canonicalText);
                }
                case ElementReference: {
                    XmlElementDescriptor descriptor = nsDescriptor.getElementDescriptor(XmlUtil.findLocalNameByQualifiedName(canonicalText), TypeOrElementOrAttributeReference.getNamespace(tag, canonicalText), new HashSet<XmlNSDescriptorImpl>(), true);
                    return descriptor != null ? descriptor.getDeclaration() : PsiUtilCore.NULL_PSI_ELEMENT;
                }
                case AttributeReference: {
                    String localNameByQualifiedName = XmlUtil.findLocalNameByQualifiedName(canonicalText);
                    XmlAttributeDescriptor descriptor = nsDescriptor.getAttribute(localNameByQualifiedName, TypeOrElementOrAttributeReference.getNamespace(tag, canonicalText), tag);
                    if (descriptor != null) {
                        return descriptor.getDeclaration();
                    }
                    return PsiUtilCore.NULL_PSI_ELEMENT;
                }
                case TypeReference: {
                    TypeDescriptor typeDescriptor;
                    TypeDescriptor typeDescriptor2 = typeDescriptor = redefined[0] ? nsDescriptor.findTypeDescriptor(XmlUtil.findLocalNameByQualifiedName(canonicalText), "") : nsDescriptor.getTypeDescriptor(canonicalText, tag);
                    if (typeDescriptor instanceof ComplexTypeDescriptor) {
                        return typeDescriptor.getDeclaration();
                    }
                    if (typeDescriptor == null) break;
                    return this.myElement;
                }
            }
        }
        return PsiUtilCore.NULL_PSI_ELEMENT;
    }

    XmlNSDescriptorImpl getDescriptor(XmlTag tag, String text, boolean[] redefined) {
        if (this.myType != ReferenceType.ElementReference && this.myType != ReferenceType.AttributeReference) {
            XmlNSDescriptorImpl redefinedDescriptor;
            PsiElement parentElement = this.myElement.getContext();
            PsiElement grandParentElement = parentElement != null ? parentElement.getParent() : null;
            boolean doRedefineCheck = false;
            if (parentElement instanceof XmlAttribute && grandParentElement instanceof XmlTag) {
                String attrName = ((XmlAttribute)parentElement).getName();
                String tagLocalName = ((XmlTag)grandParentElement).getLocalName();
                boolean bl = doRedefineCheck = "ref".equals(attrName) && ("group".equals(tagLocalName) || "attributeGroup".equals(tagLocalName)) || "base".equals(attrName) || "memberTypes".equals(attrName);
            }
            if (doRedefineCheck && (redefinedDescriptor = SchemaReferencesProvider.findRedefinedDescriptor(tag, text)) != null) {
                redefined[0] = true;
                return redefinedDescriptor;
            }
        }
        String namespace = TypeOrElementOrAttributeReference.getNamespace(tag, text);
        XmlNSDescriptor nsDescriptor = tag.getNSDescriptor(namespace, true);
        PsiFile file2 = tag.getContainingFile();
        if (!(file2 instanceof XmlFile)) {
            return null;
        }
        XmlDocument document = ((XmlFile)file2).getDocument();
        if (nsDescriptor == null) {
            nsDescriptor = (XmlNSDescriptor)document.getMetaData();
        }
        if (nsDescriptor == null) {
            XmlNSDescriptor[] descrs = new XmlNSDescriptor[1];
            URLReference.processWsdlSchemas(document.getRootTag(), (Processor<XmlTag>)((Processor)xmlTag -> {
                if (namespace.equals(xmlTag.getAttributeValue(TARGET_NAMESPACE))) {
                    descrs[0] = (XmlNSDescriptor)xmlTag.getMetaData();
                    return false;
                }
                return true;
            }));
            if (descrs[0] instanceof XmlNSDescriptorImpl) {
                return (XmlNSDescriptorImpl)descrs[0];
            }
        }
        return nsDescriptor instanceof XmlNSDescriptorImpl ? (XmlNSDescriptorImpl)nsDescriptor : null;
    }

    private static String getNamespace(XmlTag tag, String text) {
        String targetNsPrefix;
        String targetNS;
        String namespacePrefix = XmlUtil.findPrefixByQualifiedName(text);
        String namespaceByPrefix = tag.getNamespaceByPrefix(namespacePrefix);
        if (!namespaceByPrefix.isEmpty()) {
            return namespaceByPrefix;
        }
        XmlTag rootTag = ((XmlFile)tag.getContainingFile()).getRootTag();
        if (rootTag != null && "schema".equals(rootTag.getLocalName()) && XmlUtil.ourSchemaUrisList.indexOf(rootTag.getNamespace()) != -1 && (targetNS = rootTag.getAttributeValue(TARGET_NAMESPACE)) != null && (namespacePrefix.equals(targetNsPrefix = rootTag.getPrefixByNamespace(targetNS)) || namespaceByPrefix.isEmpty() && targetNsPrefix == null)) {
            return targetNS;
        }
        return namespaceByPrefix;
    }

    @NotNull
    public String getCanonicalText() {
        String name;
        String text = this.myElement.getText();
        String string = name = this.myRange.getEndOffset() <= text.length() ? this.myRange.substring(text) : "";
        if (!name.isEmpty() && this.nsPrefix != null && !this.nsPrefix.isEmpty()) {
            name = this.nsPrefix + ":" + name;
        }
        return name;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        String canonicalText = this.getCanonicalText();
        PsiElement element = ElementManipulators.getManipulator((PsiElement)this.myElement).handleContentChange(this.myElement, this.getRangeInElement(), newElementName);
        this.myRange = new TextRange(this.myRange.getStartOffset(), this.myRange.getEndOffset() - (canonicalText.length() - newElementName.length()));
        return element;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.myElement.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @NotNull
    public Object[] getVariants() {
        XmlTag tag = (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)this.myElement, XmlTag.class, (boolean)true);
        if (tag == null || this.myType == null) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        return TypeOrElementOrAttributeReference.getVariants(tag, this.myType, this.nsPrefix);
    }

    public static Object[] getVariants(XmlTag tag, ReferenceType type2, String prefix) {
        String ourNamespace;
        String[] tagNames = null;
        switch (type2) {
            case GroupReference: {
                tagNames = new String[]{"group"};
                break;
            }
            case AttributeGroupReference: {
                tagNames = new String[]{"attributeGroup"};
                break;
            }
            case AttributeReference: {
                tagNames = new String[]{"attribute"};
                break;
            }
            case ElementReference: {
                tagNames = new String[]{"element"};
                break;
            }
            case TypeReference: {
                tagNames = new String[]{"simpleType", "complexType"};
            }
        }
        XmlDocument document = ((XmlFile)tag.getContainingFile()).getDocument();
        if (document == null) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        XmlTag rootTag = document.getRootTag();
        String string = ourNamespace = rootTag != null ? rootTag.getAttributeValue(TARGET_NAMESPACE) : "";
        if (ourNamespace == null) {
            ourNamespace = "";
        }
        CompletionProcessor processor2 = new CompletionProcessor(tag, prefix);
        for (String namespace : tag.knownNamespaces()) {
            XmlNSDescriptor nsDescriptor;
            if (ourNamespace.equals(namespace) || !((nsDescriptor = tag.getNSDescriptor(namespace, true)) instanceof XmlNSDescriptorImpl)) continue;
            TypeOrElementOrAttributeReference.processNamespace(namespace, processor2, (XmlNSDescriptorImpl)nsDescriptor, tagNames);
        }
        XmlNSDescriptor nsDescriptor = (XmlNSDescriptor)document.getMetaData();
        if (nsDescriptor instanceof XmlNSDescriptorImpl) {
            TypeOrElementOrAttributeReference.processNamespace(ourNamespace, processor2, (XmlNSDescriptorImpl)nsDescriptor, tagNames);
        }
        return ArrayUtil.toStringArray(processor2.myElements);
    }

    private static void processNamespace(String namespace, CompletionProcessor processor2, XmlNSDescriptorImpl nsDescriptor, String[] tagNames) {
        processor2.namespace = namespace;
        XmlNSDescriptorImpl.processTagsInNamespace(nsDescriptor.getTag(), tagNames, processor2);
    }

    public boolean isSoft() {
        return false;
    }

    private static class CompletionProcessor
    implements PsiElementProcessor<XmlTag> {
        final List<String> myElements = new ArrayList<String>(1);
        String namespace;
        final XmlTag tag;
        private final String prefix;

        CompletionProcessor(XmlTag tag, String prefix) {
            this.tag = tag;
            this.prefix = prefix;
        }

        public boolean execute(@NotNull XmlTag element) {
            String name = element.getAttributeValue("name");
            String prefixByNamespace = this.tag.getPrefixByNamespace(this.namespace);
            if (prefixByNamespace != null && !prefixByNamespace.isEmpty() && this.prefix == null) {
                name = prefixByNamespace + ":" + name;
            }
            this.myElements.add(name);
            return true;
        }
    }

    private static class MyResolver
    implements ResolveCache.Resolver {
        static final MyResolver INSTANCE = new MyResolver();

        private MyResolver() {
        }

        @Override
        public PsiElement resolve(@NotNull PsiReference ref, boolean incompleteCode) {
            return ((TypeOrElementOrAttributeReference)ref).resolveInner();
        }
    }

    public static enum ReferenceType {
        ElementReference,
        AttributeReference,
        GroupReference,
        AttributeGroupReference,
        TypeReference;

    }
}

