/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URIReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class XmlBaseReferenceProvider
extends PsiReferenceProvider {
    private final boolean myAcceptSelf;

    public XmlBaseReferenceProvider(boolean acceptSelf) {
        this.myAcceptSelf = acceptSelf;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference reference = URIReferenceProvider.getUrlReference(element, ElementManipulators.getValueText((PsiElement)element));
        if (reference != null) {
            return new PsiReference[]{reference};
        }
        FileReferenceSet referenceSet = FileReferenceSet.createSet(element, false, false, false);
        referenceSet.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, file2 -> this.getContext(element, (PsiFile)file2));
        return referenceSet.getAllReferences();
    }

    private Collection<PsiFileSystemItem> getContext(PsiElement element, PsiFile file2) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (!this.myAcceptSelf && tag != null) {
            tag = tag.getParentTag();
        }
        while (tag != null) {
            PsiReference reference;
            XmlAttributeValue value2;
            XmlAttribute base = tag.getAttribute("base", "http://www.w3.org/XML/1998/namespace");
            if (base != null && (value2 = base.getValueElement()) != null && (reference = value2.getReference()) instanceof PsiPolyVariantReference) {
                Object[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
                return ContainerUtil.map((Object[])results, result2 -> (PsiFileSystemItem)result2.getElement());
            }
            tag = tag.getParentTag();
        }
        PsiDirectory directory = file2.getContainingDirectory();
        return directory == null ? Collections.emptyList() : Collections.singletonList(directory);
    }
}

