/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class XmlValueReference
implements PsiReference {
    protected final XmlTag myTag;
    protected TextRange myRange;

    protected XmlValueReference(XmlTag tag) {
        this.myTag = tag;
        this.myRange = ElementManipulators.getValueTextRange((PsiElement)tag);
    }

    public PsiElement getElement() {
        return this.myTag;
    }

    public TextRange getRangeInElement() {
        return this.myRange;
    }

    @NotNull
    public String getCanonicalText() {
        return this.myRange.substring(this.myTag.getText());
    }

    protected void replaceContent(String str) throws IncorrectOperationException {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myTag);
        manipulator.handleContentChange((PsiElement)this.myTag, this.myRange, str);
        this.myRange = manipulator.getRangeInElement((PsiElement)this.myTag);
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.myTag.getManager().areElementsEquivalent(element, this.resolve());
    }

    public boolean isSoft() {
        return false;
    }
}

