/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.text;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.text.ASTDiffBuilder;
import com.intellij.psi.impl.source.text.BlockSupportImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.util.diff.DiffTreeChangeBuilder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DiffLog
implements DiffTreeChangeBuilder<ASTNode, ASTNode> {
    private final List<LogEntry> myEntries = new ArrayList<LogEntry>();

    @NotNull
    public TreeChangeEventImpl performActualPsiChange(@NotNull PsiFile file2) {
        ASTDiffBuilder astDiffBuilder = new ASTDiffBuilder((PsiFileImpl)file2);
        for (LogEntry entry : this.myEntries) {
            entry.doActualPsiChange(file2, astDiffBuilder);
        }
        file2.subtreeChanged();
        return astDiffBuilder.getEvent();
    }

    public void nodeReplaced(@NotNull ASTNode oldNode, @NotNull ASTNode newNode) {
        if (oldNode instanceof FileElement && newNode instanceof FileElement) {
            this.appendReplaceFileElement((FileElement)oldNode, (FileElement)newNode);
        } else {
            this.myEntries.add(new ReplaceEntry(oldNode, newNode));
        }
    }

    void appendReplaceElementWithEvents(@NotNull CompositeElement oldRoot, @NotNull CompositeElement newRoot) {
        this.myEntries.add(new ReplaceElementWithEvents(oldRoot, newRoot));
    }

    void appendReplaceFileElement(@NotNull FileElement oldNode, @NotNull FileElement newNode) {
        this.myEntries.add(new ReplaceFileElement(oldNode, newNode));
    }

    public void nodeDeleted(@NotNull ASTNode oldParent, @NotNull ASTNode oldNode) {
        this.myEntries.add(new DeleteEntry(oldParent, oldNode));
    }

    public void nodeInserted(@NotNull ASTNode oldParent, @NotNull ASTNode newNode, int pos) {
        this.myEntries.add(new InsertEntry(oldParent, newNode, pos));
    }

    private static PsiElement getPsi(ASTNode node, PsiFile file2) {
        node.putUserData(TreeUtil.CONTAINING_FILE_KEY_AFTER_REPARSE, (Object)((PsiFileImpl)file2).getTreeElement());
        PsiElement psiChild = file2.isPhysical() ? node.getPsi() : null;
        node.putUserData(TreeUtil.CONTAINING_FILE_KEY_AFTER_REPARSE, null);
        return psiChild;
    }

    private static class ReplaceElementWithEvents
    extends LogEntry {
        @NotNull
        private final CompositeElement myOldRoot;
        @NotNull
        private final CompositeElement myNewRoot;

        private ReplaceElementWithEvents(@NotNull CompositeElement oldRoot, @NotNull CompositeElement newRoot) {
            this.myOldRoot = oldRoot;
            this.myNewRoot = newRoot;
            TreeUtil.ensureParsed(this.myOldRoot.getFirstChildNode());
            TreeUtil.ensureParsed(this.myNewRoot.getFirstChildNode());
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file2, @NotNull ASTDiffBuilder astDiffBuilder) {
            this.myOldRoot.replaceAllChildrenToChildrenOf(this.myNewRoot);
        }
    }

    private static class ReplaceFileElement
    extends LogEntry {
        @NotNull
        private final FileElement myOldNode;
        @NotNull
        private final FileElement myNewNode;

        private ReplaceFileElement(@NotNull FileElement oldNode, @NotNull FileElement newNode) {
            this.myOldNode = oldNode;
            this.myNewNode = newNode;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file2, @NotNull ASTDiffBuilder astDiffBuilder) {
            TreeElement firstChildNode;
            PsiFileImpl fileImpl = (PsiFileImpl)file2;
            int oldLength = this.myOldNode.getTextLength();
            PsiManagerImpl manager = (PsiManagerImpl)fileImpl.getManager();
            BlockSupportImpl.sendBeforeChildrenChangeEvent(manager, (PsiElement)fileImpl, false);
            if (this.myOldNode.getFirstChildNode() != null) {
                this.myOldNode.rawRemoveAllChildren();
            }
            if ((firstChildNode = this.myNewNode.getFirstChildNode()) != null) {
                this.myOldNode.rawAddChildren(firstChildNode);
            }
            fileImpl.getTreeElement().setCharTable(this.myNewNode.getCharTable());
            this.myOldNode.subtreeChanged();
            BlockSupportImpl.sendAfterChildrenChangedEvent(manager, fileImpl, oldLength, false);
        }
    }

    private static class InsertEntry
    extends LogEntry {
        @NotNull
        private final ASTNode myOldParent;
        @NotNull
        private final ASTNode myNewNode;
        private final int myPos;

        private InsertEntry(@NotNull ASTNode oldParent, @NotNull ASTNode newNode, int pos) {
            assert (oldParent instanceof CompositeElement) : oldParent;
            assert (pos >= 0) : pos;
            this.myOldParent = oldParent;
            this.myNewNode = newNode;
            this.myPos = pos;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file2, @NotNull ASTDiffBuilder astDiffBuilder) {
            ASTNode anchor = null;
            ASTNode firstChildNode = this.myOldParent.getFirstChildNode();
            for (int i2 = 0; i2 < this.myPos; ++i2) {
                anchor = anchor == null ? firstChildNode : anchor.getTreeNext();
            }
            PsiElement psiParent = this.myOldParent.getPsi();
            PsiElement psiChild = DiffLog.getPsi(this.myNewNode, file2);
            if (psiParent != null && psiChild != null) {
                PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(file2.getManager());
                event.setParent(psiParent);
                event.setChild(psiChild);
                event.setFile(file2);
                ((PsiManagerEx)file2.getManager()).beforeChildAddition(event);
            }
            ((TreeElement)this.myNewNode).rawRemove();
            if (anchor != null) {
                ((TreeElement)anchor).rawInsertAfterMe((TreeElement)this.myNewNode);
            } else if (firstChildNode != null) {
                ((TreeElement)firstChildNode).rawInsertBeforeMe((TreeElement)this.myNewNode);
            } else {
                ((CompositeElement)this.myOldParent).rawAddChildren((TreeElement)this.myNewNode);
            }
            astDiffBuilder.nodeInserted(this.myOldParent, this.myNewNode, this.myPos);
            ((TreeElement)this.myNewNode).clearCaches();
            ((CompositeElement)this.myOldParent).subtreeChanged();
            DebugUtil.checkTreeStructure(this.myOldParent);
        }
    }

    private static class DeleteEntry
    extends LogEntry {
        @NotNull
        private final ASTNode myOldParent;
        @NotNull
        private final ASTNode myOldNode;

        private DeleteEntry(@NotNull ASTNode oldParent, @NotNull ASTNode oldNode) {
            this.myOldParent = oldParent;
            this.myOldNode = oldNode;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file2, @NotNull ASTDiffBuilder astDiffBuilder) {
            PsiElement psiChild;
            ASTNode child = this.myOldNode;
            ASTNode parent = this.myOldParent;
            PsiElement psiParent = parent.getPsi();
            PsiElement psiElement = psiChild = file2.isPhysical() ? child.getPsi() : null;
            if (psiParent != null && psiChild != null) {
                PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(file2.getManager());
                event.setParent(psiParent);
                event.setChild(psiChild);
                event.setFile(file2);
                ((PsiManagerEx)file2.getManager()).beforeChildRemoval(event);
            }
            astDiffBuilder.nodeDeleted(parent, child);
            ((TreeElement)child).rawRemove();
            ((CompositeElement)parent).subtreeChanged();
            DebugUtil.checkTreeStructure(parent);
        }
    }

    private static class ReplaceEntry
    extends LogEntry {
        private final ASTNode myOldChild;
        private final ASTNode myNewChild;

        private ReplaceEntry(@NotNull ASTNode oldNode, @NotNull ASTNode newNode) {
            this.myOldChild = oldNode;
            this.myNewChild = newNode;
            ASTNode parent = oldNode.getTreeParent();
            assert (parent != null) : "old:" + oldNode + " new:" + newNode;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file2, @NotNull ASTDiffBuilder astDiffBuilder) {
            PsiElement psiOldChild;
            ASTNode oldNode = this.myOldChild;
            ASTNode newNode = this.myNewChild;
            ASTNode parent = oldNode.getTreeParent();
            assert (parent != null) : "old:" + oldNode + " new:" + newNode;
            PsiElement psiParent = parent.getPsi();
            PsiElement psiElement = psiOldChild = file2.isPhysical() ? oldNode.getPsi() : null;
            if (psiParent != null && psiOldChild != null) {
                PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(file2.getManager());
                event.setParent(psiParent);
                event.setFile(file2);
                event.setOldChild(psiOldChild);
                PsiElement psiNewChild = DiffLog.getPsi(newNode, file2);
                event.setNewChild(psiNewChild);
                ((PsiManagerEx)file2.getManager()).beforeChildReplacement(event);
            }
            ((TreeElement)newNode).rawRemove();
            ((TreeElement)oldNode).rawReplaceWithList((TreeElement)newNode);
            astDiffBuilder.nodeReplaced(oldNode, newNode);
            ((TreeElement)newNode).clearCaches();
            if (!(newNode instanceof FileElement)) {
                ((CompositeElement)newNode.getTreeParent()).subtreeChanged();
            }
            DebugUtil.checkTreeStructure(parent);
        }
    }

    private static abstract class LogEntry {
        protected LogEntry() {
            ProgressIndicatorProvider.checkCanceled();
        }

        abstract void doActualPsiChange(@NotNull PsiFile var1, @NotNull ASTDiffBuilder var2);
    }
}

