/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSharedImplUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.JavaSharedImplUtil");
    private static final TokenSet BRACKETS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.LBRACKET, JavaTokenType.RBRACKET});

    private JavaSharedImplUtil() {
    }

    public static PsiType getType(@NotNull PsiTypeElement typeElement, @NotNull PsiElement anchor) {
        return JavaSharedImplUtil.getType(typeElement, anchor, null);
    }

    public static PsiType getType(@NotNull PsiTypeElement typeElement, @NotNull PsiElement anchor, @Nullable PsiAnnotation stopAt) {
        PsiType type2 = typeElement.getType();
        List<PsiAnnotation[]> allAnnotations = JavaSharedImplUtil.collectAnnotations(anchor, stopAt);
        if (allAnnotations == null) {
            return null;
        }
        for (PsiAnnotation[] annotations2 : allAnnotations) {
            type2 = type2.createArrayType().annotate(TypeAnnotationProvider.Static.create((PsiAnnotation[])annotations2));
        }
        return type2;
    }

    private static List<PsiAnnotation[]> collectAnnotations(PsiElement anchor, PsiAnnotation stopAt) {
        List annotations2 = ContainerUtil.newSmartList();
        List current = null;
        boolean found = stopAt == null;
        boolean stop2 = false;
        for (PsiElement child = anchor.getNextSibling(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiComment || child instanceof PsiWhiteSpace) continue;
            if (child instanceof PsiAnnotation) {
                if (current == null) {
                    current = ContainerUtil.newSmartList();
                }
                current.add((PsiAnnotation)child);
                if (child != stopAt) continue;
                stop2 = true;
                found = true;
                continue;
            }
            if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.LBRACKET)) {
                annotations2.add(ContainerUtil.toArray((Collection)current, (ArrayFactory)PsiAnnotation.ARRAY_FACTORY));
                current = null;
                if (!stop2) continue;
                return annotations2;
            }
            if (!PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.RBRACKET)) break;
        }
        return !found || stop2 ? null : annotations2;
    }

    @NotNull
    public static PsiType applyAnnotations(@NotNull PsiType type2, @Nullable PsiModifierList modifierList) {
        PsiAnnotation[] annotations2;
        if (modifierList != null && (annotations2 = modifierList.getAnnotations()).length > 0) {
            TypeAnnotationProvider original = modifierList.getParent() instanceof PsiMethod ? type2.getAnnotationProvider() : TypeAnnotationProvider.EMPTY;
            FilteringTypeAnnotationProvider provider2 = new FilteringTypeAnnotationProvider(annotations2, original);
            if (type2 instanceof PsiArrayType) {
                Stack types = new Stack();
                do {
                    types.push((Object)((PsiArrayType)type2));
                } while ((type2 = ((PsiArrayType)type2).getComponentType()) instanceof PsiArrayType);
                type2 = type2.annotate((TypeAnnotationProvider)provider2);
                while (!types.isEmpty()) {
                    PsiArrayType t = (PsiArrayType)types.pop();
                    type2 = t instanceof PsiEllipsisType ? new PsiEllipsisType(type2, t.getAnnotations()) : new PsiArrayType(type2, t.getAnnotations());
                }
                return type2;
            }
            if (type2 instanceof PsiDisjunctionType) {
                ArrayList components = ContainerUtil.newArrayList((Iterable)((PsiDisjunctionType)type2).getDisjunctions());
                components.set(0, ((PsiType)components.get(0)).annotate((TypeAnnotationProvider)provider2));
                return ((PsiDisjunctionType)type2).newDisjunctionType((List)components);
            }
            return type2.annotate((TypeAnnotationProvider)provider2);
        }
        return type2;
    }

    public static void normalizeBrackets(@NotNull PsiVariable variable) {
        CompositeElement variableElement = (CompositeElement)variable.getNode();
        PsiTypeElement typeElement = variable.getTypeElement();
        PsiIdentifier nameElement = variable.getNameIdentifier();
        LOG.assertTrue(typeElement != null && nameElement != null);
        ASTNode type2 = typeElement.getNode();
        ASTNode name = nameElement.getNode();
        ASTNode firstBracket = null;
        ASTNode lastBracket = null;
        int arrayCount = 0;
        ASTNode element = name;
        while (element != null && (element = PsiImplUtil.skipWhitespaceAndComments(element.getTreeNext())) != null && element.getElementType() == JavaTokenType.LBRACKET) {
            if (firstBracket == null) {
                firstBracket = element;
            }
            lastBracket = element;
            ++arrayCount;
            if ((element = PsiImplUtil.skipWhitespaceAndComments(element.getTreeNext())) == null || element.getElementType() != JavaTokenType.RBRACKET) break;
            lastBracket = element;
        }
        if (firstBracket != null) {
            element = firstBracket;
            while (true) {
                ASTNode next = element.getTreeNext();
                variableElement.removeChild(element);
                if (element == lastBracket) break;
                element = next;
            }
            CompositeElement newType = (CompositeElement)type2.clone();
            for (int i = 0; i < arrayCount; ++i) {
                CompositeElement newType1 = ASTFactory.composite(JavaElementType.TYPE);
                newType1.rawAddChildren(newType);
                newType1.rawAddChildren(ASTFactory.leaf(JavaTokenType.LBRACKET, "["));
                newType1.rawAddChildren(ASTFactory.leaf(JavaTokenType.RBRACKET, "]"));
                newType = newType1;
                newType.acceptTree(new GeneratedMarkerVisitor());
            }
            newType.putUserData(CharTable.CHAR_TABLE_KEY, SharedImplUtil.findCharTableByTree(type2));
            variableElement.replaceChild(type2, newType);
        }
    }

    public static void setInitializer(PsiVariable variable, PsiExpression initializer) throws IncorrectOperationException {
        PsiExpression oldInitializer = variable.getInitializer();
        if (oldInitializer != null) {
            oldInitializer.delete();
        }
        if (initializer == null) {
            return;
        }
        CompositeElement variableElement = (CompositeElement)variable.getNode();
        ASTNode eq = variableElement.findChildByRole(20);
        if (eq == null) {
            CharTable charTable = SharedImplUtil.findCharTableByTree(variableElement);
            eq = Factory.createSingleLeafElement(JavaTokenType.EQ, "=", 0, 1, charTable, variable.getManager());
            PsiIdentifier identifier = variable.getNameIdentifier();
            assert (identifier != null) : variable;
            ASTNode node = PsiImplUtil.skipWhitespaceCommentsAndTokens(identifier.getNode().getTreeNext(), BRACKETS);
            variableElement.addInternal((TreeElement)eq, eq, node, Boolean.TRUE);
            eq = variableElement.findChildByRole(20);
            assert (eq != null) : variable;
        }
        variable.addAfter((PsiElement)initializer, eq.getPsi());
    }

    private static class FilteringTypeAnnotationProvider
    implements TypeAnnotationProvider {
        private final PsiAnnotation[] myCandidates;
        private final TypeAnnotationProvider myOriginalProvider;
        private volatile PsiAnnotation[] myCache;

        private FilteringTypeAnnotationProvider(PsiAnnotation[] candidates, TypeAnnotationProvider originalProvider) {
            this.myCandidates = candidates;
            this.myOriginalProvider = originalProvider;
        }

        @NotNull
        public PsiAnnotation[] getAnnotations() {
            PsiAnnotation[] result2 = this.myCache;
            if (result2 == null) {
                List filtered = JBIterable.of((Object[])this.myCandidates).filter(annotation -> AnnotationTargetUtil.isTypeAnnotation((PsiAnnotation)annotation)).append((Object[])this.myOriginalProvider.getAnnotations()).toList();
                result2 = filtered.isEmpty() ? PsiAnnotation.EMPTY_ARRAY : filtered.toArray(new PsiAnnotation[filtered.size()]);
                this.myCache = result2;
            }
            return result2;
        }
    }
}

