/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightTreeUtil {
    @Nullable
    public static LighterASTNode firstChildOfType(@NotNull LighterAST tree, @Nullable LighterASTNode node, @NotNull IElementType type2) {
        if (node == null) {
            return null;
        }
        List children2 = tree.getChildren(node);
        for (int i2 = 0; i2 < children2.size(); ++i2) {
            LighterASTNode child = (LighterASTNode)children2.get(i2);
            if (child.getTokenType() != type2) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static LighterASTNode firstChildOfType(@NotNull LighterAST tree, @Nullable LighterASTNode node, @NotNull TokenSet types) {
        if (node == null) {
            return null;
        }
        List children2 = tree.getChildren(node);
        for (int i2 = 0; i2 < children2.size(); ++i2) {
            LighterASTNode child = (LighterASTNode)children2.get(i2);
            if (!types.contains(child.getTokenType())) continue;
            return child;
        }
        return null;
    }

    @NotNull
    public static LighterASTNode requiredChildOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull IElementType type2) {
        LighterASTNode child = LightTreeUtil.firstChildOfType(tree, node, type2);
        assert (child != null) : "Required child " + type2 + " not found in " + node.getTokenType() + ": " + tree.getChildren(node);
        return child;
    }

    @NotNull
    public static LighterASTNode requiredChildOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull TokenSet types) {
        LighterASTNode child = LightTreeUtil.firstChildOfType(tree, node, types);
        assert (child != null) : "Required child " + types + " not found in " + node.getTokenType() + ": " + tree.getChildren(node);
        return child;
    }

    @NotNull
    public static List<LighterASTNode> getChildrenOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull IElementType type2) {
        SmartList result2 = null;
        List children2 = tree.getChildren(node);
        int size = children2.size();
        for (int i2 = 0; i2 < size; ++i2) {
            LighterASTNode child = (LighterASTNode)children2.get(i2);
            if (child.getTokenType() != type2) continue;
            if (result2 == null) {
                result2 = new SmartList();
            }
            result2.add((LighterASTNode)child);
        }
        return result2 != null ? result2 : Collections.emptyList();
    }

    @NotNull
    public static List<LighterASTNode> getChildrenOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull TokenSet types) {
        List children2 = tree.getChildren(node);
        SmartList result2 = null;
        int size = children2.size();
        for (int i2 = 0; i2 < size; ++i2) {
            LighterASTNode child = (LighterASTNode)children2.get(i2);
            if (!types.contains(child.getTokenType())) continue;
            if (result2 == null) {
                result2 = new SmartList();
            }
            result2.add((LighterASTNode)child);
        }
        return result2 != null ? result2 : Collections.emptyList();
    }

    @NotNull
    public static String toFilteredString(@NotNull LighterAST tree, @NotNull LighterASTNode node, @Nullable TokenSet skipTypes) {
        int length = node.getEndOffset() - node.getStartOffset();
        if (length < 0) {
            length = 0;
            Logger.getInstance(LightTreeUtil.class).error("tree=" + tree + " node=" + node);
        }
        StringBuilder buffer = new StringBuilder(length);
        LightTreeUtil.toBuffer(tree, node, buffer, skipTypes);
        return buffer.toString();
    }

    public static void toBuffer(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StringBuilder buffer, @Nullable TokenSet skipTypes) {
        if (skipTypes != null && skipTypes.contains(node.getTokenType())) {
            return;
        }
        if (node instanceof LighterASTTokenNode) {
            buffer.append(((LighterASTTokenNode)node).getText());
            return;
        }
        if (node instanceof LighterLazyParseableNode) {
            buffer.append(((LighterLazyParseableNode)node).getText());
            return;
        }
        List children2 = tree.getChildren(node);
        int size = children2.size();
        for (int i2 = 0; i2 < size; ++i2) {
            LightTreeUtil.toBuffer(tree, (LighterASTNode)children2.get(i2), buffer, skipTypes);
        }
    }

    @Nullable
    public static LighterASTNode getParentOfType(@NotNull LighterAST tree, @Nullable LighterASTNode node, @NotNull TokenSet types, @NotNull TokenSet stopAt) {
        if (node == null) {
            return null;
        }
        node = tree.getParent(node);
        while (node != null) {
            IElementType type2 = node.getTokenType();
            if (types.contains(type2)) {
                return node;
            }
            if (stopAt.contains(type2)) {
                return null;
            }
            node = tree.getParent(node);
        }
        return null;
    }

    @Nullable
    public static LighterASTNode findLeafElementAt(@NotNull LighterAST tree, int offset) {
        LighterASTNode eachNode = tree.getRoot();
        if (!LightTreeUtil.containsOffset(eachNode, offset)) {
            return null;
        }
        while (eachNode != null) {
            List children2 = tree.getChildren(eachNode);
            if (children2.isEmpty()) {
                return eachNode;
            }
            eachNode = LightTreeUtil.findChildAtOffset(offset, children2);
        }
        return null;
    }

    private static LighterASTNode findChildAtOffset(int offset, List<LighterASTNode> children2) {
        return (LighterASTNode)ContainerUtil.find(children2, node -> LightTreeUtil.containsOffset(node, offset));
    }

    private static boolean containsOffset(LighterASTNode node, int offset) {
        return node.getStartOffset() <= offset && node.getEndOffset() > offset;
    }
}

