/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.psi.impl.source.tree.LighterASTNodeVisitor;
import com.intellij.util.WalkingState;
import com.intellij.util.containers.Stack;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class RecursiveLighterASTNodeWalkingVisitor
extends LighterASTNodeVisitor {
    @NotNull
    private final LighterAST ast;
    private final Stack<IndexedLighterASTNode[]> childrenStack = new Stack();
    private final Stack<IndexedLighterASTNode> parentStack = new Stack();
    private final WalkingState<IndexedLighterASTNode> myWalkingState;

    protected RecursiveLighterASTNodeWalkingVisitor(@NotNull LighterAST ast) {
        this.ast = ast;
        this.myWalkingState = new WalkingState<IndexedLighterASTNode>((WalkingState.TreeGuide)new LighterASTGuide()){

            public void elementFinished(@NotNull IndexedLighterASTNode element) {
                RecursiveLighterASTNodeWalkingVisitor.this.elementFinished(element.node);
                if (RecursiveLighterASTNodeWalkingVisitor.this.parentStack.peek() == element) {
                    RecursiveLighterASTNodeWalkingVisitor.this.childrenStack.pop();
                    RecursiveLighterASTNodeWalkingVisitor.this.parentStack.pop();
                }
            }

            public void visit(@NotNull IndexedLighterASTNode iNode) {
                LighterASTNode element = iNode.node;
                RecursiveLighterASTNodeWalkingVisitor visitor = RecursiveLighterASTNodeWalkingVisitor.this;
                if (element instanceof LighterLazyParseableNode) {
                    visitor.visitLazyParseableNode((LighterLazyParseableNode)element);
                } else if (element instanceof LighterASTTokenNode) {
                    visitor.visitTokenNode((LighterASTTokenNode)element);
                } else {
                    visitor.visitNode(element);
                }
            }
        };
    }

    protected void elementFinished(@NotNull LighterASTNode element) {
    }

    @Override
    public void visitNode(@NotNull LighterASTNode element) {
        this.myWalkingState.elementStarted((Object)new IndexedLighterASTNode(element, null));
    }

    public void stopWalking() {
        this.myWalkingState.stopWalking();
    }

    private class LighterASTGuide
    implements WalkingState.TreeGuide<IndexedLighterASTNode> {
        private LighterASTGuide() {
        }

        public IndexedLighterASTNode getNextSibling(@NotNull IndexedLighterASTNode element) {
            return element.next;
        }

        public IndexedLighterASTNode getPrevSibling(@NotNull IndexedLighterASTNode element) {
            return element.prev;
        }

        public IndexedLighterASTNode getFirstChild(@NotNull IndexedLighterASTNode element) {
            List children2 = RecursiveLighterASTNodeWalkingVisitor.this.ast.getChildren(element.node);
            IndexedLighterASTNode[] indexedChildren = children2.isEmpty() ? IndexedLighterASTNode.EMPTY_ARRAY : new IndexedLighterASTNode[children2.size()];
            for (int i2 = 0; i2 < children2.size(); ++i2) {
                IndexedLighterASTNode indexedNode;
                LighterASTNode child = (LighterASTNode)children2.get(i2);
                indexedChildren[i2] = indexedNode = new IndexedLighterASTNode(child, i2 == 0 ? null : indexedChildren[i2 - 1]);
                if (i2 == 0) continue;
                indexedChildren[i2 - 1].next = indexedNode;
            }
            RecursiveLighterASTNodeWalkingVisitor.this.childrenStack.push((Object)indexedChildren);
            RecursiveLighterASTNodeWalkingVisitor.this.parentStack.push((Object)element);
            return children2.isEmpty() ? null : indexedChildren[0];
        }

        public IndexedLighterASTNode getParent(@NotNull IndexedLighterASTNode element) {
            return (IndexedLighterASTNode)RecursiveLighterASTNodeWalkingVisitor.this.parentStack.peek();
        }
    }

    private static class IndexedLighterASTNode {
        private static final IndexedLighterASTNode[] EMPTY_ARRAY = new IndexedLighterASTNode[0];
        private final LighterASTNode node;
        private final IndexedLighterASTNode prev;
        private IndexedLighterASTNode next;

        IndexedLighterASTNode(@NotNull LighterASTNode node, IndexedLighterASTNode prev) {
            this.node = node;
            this.prev = prev;
        }
    }
}

