/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionStub;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiLambdaExpressionImpl
extends JavaStubPsiElement<FunctionalExpressionStub<PsiLambdaExpression>>
implements PsiLambdaExpression {
    private static final ControlFlowPolicy ourPolicy = new ControlFlowPolicy(){

        @Override
        @Nullable
        public PsiVariable getUsedVariable(@NotNull PsiReferenceExpression refExpr) {
            return null;
        }

        @Override
        public boolean isParameterAccepted(@NotNull PsiParameter psiParameter) {
            return true;
        }

        @Override
        public boolean isLocalVariableAccepted(@NotNull PsiLocalVariable psiVariable) {
            return true;
        }
    };

    public PsiLambdaExpressionImpl(@NotNull FunctionalExpressionStub<PsiLambdaExpression> stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.LAMBDA_EXPRESSION);
    }

    public PsiLambdaExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    public PsiParameterList getParameterList() {
        return (PsiParameterList)PsiTreeUtil.getRequiredChildOfType((PsiElement)this, PsiParameterList.class);
    }

    public PsiElement getBody() {
        PsiElement element = this.getLastChild();
        return element instanceof PsiExpression || element instanceof PsiCodeBlock ? element : null;
    }

    @Nullable
    public PsiType getFunctionalInterfaceType() {
        return FunctionalInterfaceParameterizationUtil.getGroundTargetType(LambdaUtil.getFunctionalInterfaceType((PsiElement)this, (boolean)true), this);
    }

    public boolean isVoidCompatible() {
        PsiElement body2 = this.getBody();
        if (body2 instanceof PsiCodeBlock) {
            for (PsiReturnStatement statement2 : PsiUtil.findReturnStatements((PsiCodeBlock)((PsiCodeBlock)body2))) {
                if (statement2.getReturnValue() == null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isValueCompatible() {
        Boolean result2 = (Boolean)MethodCandidateInfo.ourOverloadGuard.doPreventingRecursion((Object)this, false, () -> this.isValueCompatibleNoCache());
        return result2 != null && result2 != false;
    }

    private boolean isValueCompatibleNoCache() {
        PsiElement body2 = this.getBody();
        if (body2 instanceof PsiCodeBlock) {
            try {
                ControlFlow controlFlow = ControlFlowFactory.getInstance(this.getProject()).getControlFlow(body2, ourPolicy, false, false);
                int startOffset = controlFlow.getStartOffset(body2);
                int endOffset = controlFlow.getEndOffset(body2);
                if (startOffset != -1 && endOffset != -1 && ControlFlowUtil.canCompleteNormally(controlFlow, startOffset, endOffset)) {
                    return false;
                }
            }
            catch (AnalysisCanceledException analysisCanceledException) {
                // empty catch block
            }
            for (PsiReturnStatement statement2 : PsiUtil.findReturnStatements((PsiCodeBlock)((PsiCodeBlock)body2))) {
                if (statement2.getReturnValue() != null) continue;
                return false;
            }
        }
        return true;
    }

    public PsiType getType() {
        return new PsiLambdaExpressionType((PsiLambdaExpression)this);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitLambdaExpression((PsiLambdaExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        return PsiImplUtil.processDeclarationsInLambda(this, processor2, state, lastParent, place);
    }

    public String toString() {
        return "PsiLambdaExpression";
    }

    public boolean hasFormalParameterTypes() {
        PsiParameter[] parameters2;
        for (PsiParameter parameter : parameters2 = this.getParameterList().getParameters()) {
            if (parameter.getTypeElement() != null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAcceptable(PsiType leftType) {
        PsiType methodReturnType;
        MethodCandidateInfo.CurrentCandidateProperties candidateProperties;
        if (leftType instanceof PsiIntersectionType) {
            for (PsiType conjunctType : ((PsiIntersectionType)leftType).getConjuncts()) {
                if (!this.isAcceptable(conjunctType)) continue;
                return true;
            }
            return false;
        }
        PsiExpressionList argsList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)this, PsiExpressionList.class);
        if (MethodCandidateInfo.ourOverloadGuard.currentStack().contains(argsList) && (candidateProperties = MethodCandidateInfo.getCurrentMethod((PsiElement)argsList)) != null) {
            PsiMethod method2 = candidateProperties.getMethod();
            if (this.hasFormalParameterTypes() && !InferenceSession.isPertinentToApplicability((PsiExpression)this, method2)) {
                return true;
            }
            if (LambdaUtil.isPotentiallyCompatibleWithTypeParameter((PsiFunctionalExpression)this, (PsiExpressionList)argsList, (PsiMethod)method2)) {
                return true;
            }
        }
        if (!this.isPotentiallyCompatible(leftType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(leftType, this))) {
            return false;
        }
        if (MethodCandidateInfo.ourOverloadGuard.currentStack().contains(argsList) && !this.hasFormalParameterTypes()) {
            return true;
        }
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)leftType);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)resolveResult);
        if (interfaceMethod == null) {
            return false;
        }
        if (interfaceMethod.hasTypeParameters()) {
            return false;
        }
        PsiSubstitutor substitutor = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)resolveResult);
        if (this.hasFormalParameterTypes()) {
            PsiParameter[] lambdaParameters = this.getParameterList().getParameters();
            PsiType[] parameterTypes = interfaceMethod.getSignature(substitutor).getParameterTypes();
            int length = lambdaParameters.length;
            for (int lambdaParamIdx = 0; lambdaParamIdx < length; ++lambdaParamIdx) {
                PsiType methodParameterType;
                PsiType lambdaFormalType;
                PsiParameter parameter = lambdaParameters[lambdaParamIdx];
                PsiTypeElement typeElement = parameter.getTypeElement();
                if (typeElement == null || (lambdaFormalType = PsiLambdaExpressionImpl.toArray(parameter.getType())).equals(methodParameterType = PsiLambdaExpressionImpl.toArray(parameterTypes[lambdaParamIdx]))) continue;
                return false;
            }
        }
        if ((methodReturnType = interfaceMethod.getReturnType()) != null && !PsiType.VOID.equals((Object)methodReturnType)) {
            Map map2 = LambdaUtil.getFunctionalTypeMap();
            try {
                boolean bl;
                if (map2.put(this, leftType) != null) {
                    bl = false;
                    return bl;
                }
                bl = LambdaUtil.checkReturnTypeCompatible((PsiLambdaExpression)this, (PsiType)substitutor.substitute(methodReturnType)) == null;
                return bl;
            }
            finally {
                map2.remove((Object)this);
            }
        }
        return true;
    }

    public boolean isPotentiallyCompatible(PsiType left) {
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)left);
        if (interfaceMethod == null) {
            return false;
        }
        if (this.getParameterList().getParametersCount() != interfaceMethod.getParameterList().getParametersCount()) {
            return false;
        }
        PsiType methodReturnType = interfaceMethod.getReturnType();
        PsiElement body2 = this.getBody();
        if (PsiType.VOID.equals((Object)methodReturnType)) {
            if (body2 instanceof PsiCodeBlock) {
                return this.isVoidCompatible();
            }
            return LambdaUtil.isExpressionStatementExpression((PsiElement)body2);
        }
        return body2 instanceof PsiCodeBlock && this.isValueCompatible() || body2 instanceof PsiExpression;
    }

    private static PsiType toArray(PsiType paramType) {
        if (paramType instanceof PsiEllipsisType) {
            return ((PsiEllipsisType)paramType).toArrayType();
        }
        return paramType;
    }

    @Nullable
    public Icon getIcon(int flags) {
        return AllIcons.Nodes.Function;
    }
}

