/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.xml.XmlElementChangeUtil;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementContentSpec;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;

public class XmlElementDeclImpl
extends XmlElementImpl
implements XmlElementDecl,
XmlElementType {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.xml.XmlElementDeclImpl");

    public XmlElementDeclImpl() {
        super(XML_ELEMENT_DECL);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i2 = child.getElementType();
        if (i2 == XML_NAME) {
            return 229;
        }
        if (i2 == XML_ELEMENT_CONTENT_SPEC) {
            return 230;
        }
        return 0;
    }

    @Override
    public int getTextOffset() {
        XmlElement name = this.getNameElement();
        return name != null ? name.getTextOffset() : super.getTextOffset();
    }

    public XmlElement getNameElement() {
        return (XmlElement)this.findChildByRoleAsPsiElement(229);
    }

    public XmlElementContentSpec getContentSpecElement() {
        return (XmlElementContentSpec)this.findChildByRoleAsPsiElement(230);
    }

    public PsiMetaData getMetaData() {
        return MetaRegistry.getMeta(this);
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        XmlElementChangeUtil.doNameReplacement((PsiNamedElement)this, this.getNameElement(), name);
        return null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        return ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, XmlElementDecl.class);
    }

    @Override
    public PsiElement getOriginalElement() {
        if (this.isPhysical()) {
            return super.getOriginalElement();
        }
        PsiNamedElement element = XmlUtil.findRealNamedElement((PsiNamedElement)this);
        if (element != null) {
            return element;
        }
        return this;
    }

    @Override
    public boolean canNavigate() {
        if (!this.isPhysical()) {
            return this.getOriginalElement() != this;
        }
        return super.canNavigate();
    }

    @Override
    public void navigate(boolean requestFocus) {
        PsiElement element;
        if (!this.isPhysical() && (element = this.getOriginalElement()) != this) {
            ((Navigatable)element).navigate(requestFocus);
            return;
        }
        super.navigate(requestFocus);
    }

    @Override
    public String getName() {
        XmlElement xmlElement = this.getNameElement();
        if (xmlElement != null) {
            return xmlElement.getText();
        }
        return XmlElementDeclImpl.getNameFromEntityRef(this, XmlTokenType.XML_ELEMENT_DECL_START);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        if (!(another instanceof XmlElementDecl)) {
            return false;
        }
        XmlElementDeclImpl element1 = this;
        PsiElement element2 = another;
        if (!element1.isPhysical()) {
            element1 = element1.getOriginalElement();
        }
        if (!element2.isPhysical()) {
            element2 = element2.getOriginalElement();
        }
        return element1 == element2;
    }

    public PsiElement getNameIdentifier() {
        return null;
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        return this;
    }
}

