/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.Navigatable;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.parsing.xml.DtdParsing;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.impl.source.xml.XmlTokenImpl;
import com.intellij.psi.tree.xml.IXmlLeafElementType;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementContentSpec;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlEntityDeclImpl
extends XmlElementImpl
implements XmlEntityDecl,
XmlElementType {
    public XmlEntityDeclImpl() {
        super(XML_ENTITY_DECL);
    }

    public PsiElement getNameElement() {
        for (TreeElement e = this.getFirstChildNode(); e != null; e = e.getTreeNext()) {
            XmlTokenImpl xmlToken;
            if (!(e instanceof XmlTokenImpl) || (xmlToken = (XmlTokenImpl)e).getTokenType() != XmlTokenType.XML_NAME) continue;
            return xmlToken;
        }
        return null;
    }

    public XmlAttributeValue getValueElement() {
        if (this.isInternalReference()) {
            for (TreeElement e = this.getFirstChildNode(); e != null; e = e.getTreeNext()) {
                if (e.getElementType() != XmlElementType.XML_ATTRIBUTE_VALUE) continue;
                return (XmlAttributeValue)SourceTreeToPsiMap.treeElementToPsi(e);
            }
        } else {
            for (TreeElement e = this.getLastChildNode(); e != null; e = e.getTreePrev()) {
                if (e.getElementType() != XmlElementType.XML_ATTRIBUTE_VALUE) continue;
                return (XmlAttributeValue)SourceTreeToPsiMap.treeElementToPsi(e);
            }
        }
        return null;
    }

    @Override
    public String getName() {
        PsiElement nameElement = this.getNameElement();
        return nameElement != null ? nameElement.getText() : "";
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        PsiElement nameElement = this.getNameElement();
        if (nameElement != null) {
            return ElementManipulators.getManipulator((PsiElement)nameElement).handleContentChange(nameElement, new TextRange(0, nameElement.getTextLength()), name);
        }
        return null;
    }

    public PsiElement parse(PsiFile baseFile, XmlEntityDecl.EntityContextType contextType, XmlEntityRef originalElement) {
        PsiElement dep = (PsiElement)XmlElement.DEPENDING_ELEMENT.get((UserDataHolder)this.getParent());
        PsiElement dependsOnElement = this.getValueElement(dep instanceof PsiFile ? (PsiFile)dep : baseFile);
        String value2 = null;
        if (dependsOnElement instanceof XmlAttributeValue) {
            XmlAttributeValue attributeValue = (XmlAttributeValue)dependsOnElement;
            value2 = attributeValue.getValue();
        } else if (dependsOnElement instanceof PsiFile) {
            PsiFile file2 = (PsiFile)dependsOnElement;
            value2 = file2.getText();
        }
        if (value2 == null) {
            return null;
        }
        DtdParsing dtdParsing = new DtdParsing(value2, XML_ELEMENT_DECL, contextType, baseFile);
        PsiElement generated = dtdParsing.parse().getPsi().getFirstChild();
        if (contextType == XmlEntityDecl.EntityContextType.ELEMENT_CONTENT_SPEC && generated instanceof XmlElementContentSpec) {
            generated = generated.getFirstChild();
        }
        this.setDependsOnElement(generated, dependsOnElement);
        return this.setOriginalElement(generated, (PsiElement)originalElement);
    }

    private PsiElement setDependsOnElement(PsiElement generated, PsiElement dependsOnElement) {
        for (PsiElement e = generated; e != null; e = e.getNextSibling()) {
            e.putUserData(XmlElement.DEPENDING_ELEMENT, (Object)dependsOnElement);
        }
        return generated;
    }

    private PsiElement setOriginalElement(PsiElement element, PsiElement valueElement) {
        for (PsiElement e = element; e != null; e = e.getNextSibling()) {
            e.putUserData(XmlElement.INCLUDING_ELEMENT, (Object)((XmlElement)valueElement));
        }
        return element;
    }

    @Nullable
    private PsiElement getValueElement(PsiFile baseFile) {
        String value2;
        XmlAttributeValue attributeValue = this.getValueElement();
        if (this.isInternalReference()) {
            return attributeValue;
        }
        if (attributeValue != null && (value2 = attributeValue.getValue()) != null) {
            XmlFile xmlFile = XmlUtil.findNamespaceByLocation(baseFile, value2);
            if (xmlFile != null) {
                return xmlFile;
            }
            int i2 = XmlUtil.getPrefixLength(value2);
            if (i2 > 0) {
                return XmlUtil.findNamespaceByLocation(baseFile, value2.substring(i2));
            }
        }
        return null;
    }

    public boolean isInternalReference() {
        for (TreeElement e = this.getFirstChildNode(); e != null; e = e.getTreeNext()) {
            XmlToken token;
            if (!(e.getElementType() instanceof IXmlLeafElementType) || (token = (XmlToken)SourceTreeToPsiMap.treeElementToPsi(e)).getTokenType() != XmlTokenType.XML_DOCTYPE_PUBLIC && token.getTokenType() != XmlTokenType.XML_DOCTYPE_SYSTEM) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        return this.getNameElement();
    }

    @Override
    public int getTextOffset() {
        PsiElement name = this.getNameElement();
        return name != null ? name.getTextOffset() : super.getTextOffset();
    }

    @Override
    public boolean canNavigate() {
        if (this.isPhysical()) {
            return super.canNavigate();
        }
        PsiNamedElement psiNamedElement = XmlUtil.findRealNamedElement((PsiNamedElement)this);
        return psiNamedElement != null;
    }

    @Override
    public void navigate(boolean requestFocus) {
        if (!this.isPhysical()) {
            ((Navigatable)XmlUtil.findRealNamedElement((PsiNamedElement)this)).navigate(requestFocus);
            return;
        }
        super.navigate(requestFocus);
    }
}

