/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.presentation.java;

import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProvider;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ClassPresentationProvider
implements ItemPresentationProvider<PsiClass> {
    public ItemPresentation getPresentation(final @NotNull PsiClass psiClass) {
        return new ColoredItemPresentation(){

            public String getPresentableText() {
                return ClassPresentationUtil.getNameForClass(psiClass, false);
            }

            public String getLocationString() {
                PsiFile file2 = psiClass.getContainingFile();
                if (file2 instanceof PsiClassOwner) {
                    PsiClassOwner classOwner = (PsiClassOwner)file2;
                    String packageName = classOwner.getPackageName();
                    if (packageName.isEmpty()) {
                        return null;
                    }
                    return "(" + packageName + ")";
                }
                return null;
            }

            public TextAttributesKey getTextAttributesKey() {
                try {
                    if (psiClass.isDeprecated()) {
                        return CodeInsightColors.DEPRECATED_ATTRIBUTES;
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
                return null;
            }

            public Icon getIcon(boolean open2) {
                return psiClass.getIcon(3);
            }
        };
    }
}

