/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.presentation.java;

import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.impl.PsiImplUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaModulePresentationProvider
implements ItemPresentationProvider<PsiJavaModule> {
    private static final Pattern JAR_NAME = Pattern.compile(".+/([^/]+\\.jar)!/.*");

    public ItemPresentation getPresentation(final @NotNull PsiJavaModule item) {
        return new ItemPresentation(){

            public String getPresentableText() {
                return item.getName();
            }

            @Nullable
            public String getLocationString() {
                Module module2;
                VirtualFile file2 = PsiImplUtil.getModuleVirtualFile(item);
                FileIndexFacade index = FileIndexFacade.getInstance((Project)item.getProject());
                if (index.isInLibraryClasses(file2)) {
                    Matcher matcher = JAR_NAME.matcher(file2.getPath());
                    if (matcher.find()) {
                        return matcher.group(1);
                    }
                } else if (index.isInSource(file2) && (module2 = index.getModuleForFile(file2)) != null) {
                    return '[' + module2.getName() + ']';
                }
                return null;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return AllIcons.Nodes.JavaModule;
            }
        };
    }
}

