/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.refResolve;

import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.CacheUpdateRunner;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.RefResolveService;
import com.intellij.psi.refResolve.PersistentIntList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;

public class RefResolveServiceImpl
extends RefResolveService
implements Runnable,
Disposable {
    private static final Logger LOG = Logger.getInstance(RefResolveServiceImpl.class);
    private final AtomicInteger fileCount = new AtomicInteger();
    private final AtomicLong bytesSize = new AtomicLong();
    private final AtomicLong refCount = new AtomicLong();
    private final PersistentIntList storage;
    private final Deque<VirtualFile> filesToResolve = new ArrayDeque<VirtualFile>();
    private final ConcurrentBitSet fileIsInQueue = new ConcurrentBitSet();
    private final ConcurrentBitSet fileIsResolved;
    private final ApplicationEx myApplication;
    private volatile boolean myDisposed;
    private volatile boolean upToDate;
    private final AtomicInteger enableVetoes = new AtomicInteger();
    private final FileWriter log;
    private final ProjectFileIndex myProjectFileIndex;
    private volatile Future<?> resolveProcess = new FutureTask<Object>(EmptyRunnable.getInstance(), null);
    private volatile int resolvedInPreviousBatch;
    private String prevLog = "";
    private static final Set<JavaSourceRootType> SOURCE_ROOTS = ContainerUtil.newTroveSet((Object[])new JavaSourceRootType[]{JavaSourceRootType.SOURCE, JavaSourceRootType.TEST_SOURCE});
    private final List<RefResolveService.Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public RefResolveServiceImpl(Project project2, MessageBus messageBus, PsiManager psiManager, StartupManager startupManager, ApplicationEx application, ProjectFileIndex projectFileIndex) throws IOException {
        super(project2);
        ((FutureTask)this.resolveProcess).run();
        this.myApplication = application;
        this.myProjectFileIndex = projectFileIndex;
        if (ENABLED) {
            this.log = new FileWriter(new File(this.getStorageDirectory(), "log.txt"));
            File dataFile = new File(this.getStorageDirectory(), "data");
            this.fileIsResolved = ConcurrentBitSet.readFrom((File)new File(this.getStorageDirectory(), "bitSet"));
            this.log("Read resolved file bitset: " + this.fileIsResolved);
            int maxId = FSRecords.getMaxId();
            PersistentIntList list = new PersistentIntList(dataFile, dataFile.exists() ? 0 : maxId);
            if (list.getSize() == maxId) {
                this.storage = list;
            } else {
                list.dispose();
                this.storage = new PersistentIntList(dataFile, maxId);
                this.log("VFS maxId changed: was " + list.getSize() + "; now: " + maxId + "; re-resolving everything");
                this.fileIsResolved.clear();
            }
            Disposer.register((Disposable)this, (Disposable)this.storage);
            if (!application.isUnitTestMode()) {
                startupManager.runWhenProjectIsInitialized(() -> {
                    this.initListeners(messageBus, psiManager);
                    this.startThread();
                });
            }
            Disposer.register((Disposable)this, (Disposable)new Disposable(){

                public void dispose() {
                    try {
                        RefResolveServiceImpl.this.save();
                        RefResolveServiceImpl.this.log.close();
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            });
        } else {
            this.log = null;
            this.fileIsResolved = null;
            this.storage = null;
        }
    }

    @NotNull
    private static List<VirtualFile> toVf(@NotNull int[] ids) {
        ArrayList<VirtualFile> res = new ArrayList<VirtualFile>();
        for (int id : ids) {
            VirtualFile file2 = PersistentFS.getInstance().findFileById(id);
            if (file2 == null) continue;
            res.add(file2);
        }
        return res;
    }

    @NotNull
    private static String toVfString(@NotNull int[] backIds) {
        List<VirtualFile> list = RefResolveServiceImpl.toVf(backIds);
        return RefResolveServiceImpl.toVfString(list);
    }

    @NotNull
    private static String toVfString(@NotNull Collection<VirtualFile> list) {
        List<VirtualFile> sub = new ArrayList<VirtualFile>(list).subList(0, Math.min(list.size(), 100));
        return list.size() + " files: " + StringUtil.join(sub, file2 -> file2.getName(), (String)", ") + (list.size() == sub.size() ? "" : "...");
    }

    private void initListeners(@NotNull MessageBus messageBus, @NotNull PsiManager psiManager) {
        messageBus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                RefResolveServiceImpl.this.fileCount.set(0);
                List files = ContainerUtil.mapNotNull(events, (Function)new Function<VFileEvent, VirtualFile>(){

                    public VirtualFile fun(VFileEvent event) {
                        return event.getFile();
                    }
                });
                RefResolveServiceImpl.this.queue(files, "VFS events " + events.size());
            }
        });
        psiManager.addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                PsiFile file2 = event.getFile();
                VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file2);
                if (virtualFile != null) {
                    RefResolveServiceImpl.this.queue(Collections.singletonList(virtualFile), event);
                }
            }

            public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
                this.childrenChanged(event);
            }
        });
        messageBus.connect().subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                RefResolveServiceImpl.this.disable();
            }

            public void exitDumbMode() {
                RefResolveServiceImpl.this.enable();
            }
        });
        messageBus.connect().subscribe(PowerSaveMode.TOPIC, (Object)new PowerSaveMode.Listener(){

            public void powerSaveStateChanged() {
                if (PowerSaveMode.isEnabled()) {
                    RefResolveServiceImpl.this.enable();
                } else {
                    RefResolveServiceImpl.this.disable();
                }
            }
        });
        this.myApplication.addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void beforeWriteActionStart(@NotNull Object action) {
                RefResolveServiceImpl.this.disable();
            }

            public void writeActionFinished(@NotNull Object action) {
                RefResolveServiceImpl.this.enable();
            }

            public void applicationExiting() {
                RefResolveServiceImpl.this.disable();
            }
        }, this);
        VirtualFileManager.getInstance().addVirtualFileManagerListener(new VirtualFileManagerListener(){

            public void beforeRefreshStart(boolean asynchronous) {
                RefResolveServiceImpl.this.disable();
            }

            public void afterRefreshFinish(boolean asynchronous) {
                RefResolveServiceImpl.this.enable();
            }
        }, (Disposable)this);
        HeavyProcessLatch.INSTANCE.addListener(new HeavyProcessLatch.HeavyProcessListener(){

            public void processStarted() {
            }

            public void processFinished() {
                RefResolveServiceImpl.this.wakeUp();
            }
        }, (Disposable)this);
    }

    private boolean queueIfNeeded(VirtualFile virtualFile, @NotNull Project project2) {
        return this.toResolve(virtualFile, project2) && this.queueUpdate(virtualFile);
    }

    private boolean toResolve(VirtualFile virtualFile, @NotNull Project project2) {
        if (virtualFile != null && virtualFile.isValid() && project2.isInitialized() && this.myProjectFileIndex.isInSourceContent(virtualFile) && RefResolveServiceImpl.isSupportedFileType(virtualFile)) {
            return true;
        }
        if (virtualFile instanceof VirtualFileWithId) {
            int id = RefResolveServiceImpl.getAbsId(virtualFile);
            this.fileIsResolved.set(id);
        }
        return false;
    }

    public static boolean isSupportedFileType(@NotNull VirtualFile virtualFile) {
        if (virtualFile.isDirectory()) {
            return true;
        }
        if (virtualFile.getFileType() == StdFileTypes.JAVA) {
            return true;
        }
        if (virtualFile.getFileType() == StdFileTypes.XML && !ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile)) {
            return true;
        }
        String extension = virtualFile.getExtension();
        return "groovy".equals(extension) || "kt".equals(extension);
    }

    @NotNull
    private File getStorageDirectory() {
        String dirName = this.myProject.getName() + "." + Integer.toHexString(this.myProject.getPresentableUrl().hashCode());
        File dir = new File(PathManager.getSystemPath(), "refs/" + dirName);
        FileUtil.createDirectory((File)dir);
        return dir;
    }

    private void log(String m) {
        this.logf(m);
    }

    private void logf(String m) {
        if (LOG.isDebugEnabled()) {
            try {
                this.log.write(DateFormat.getDateTimeInstance().format(new Date()) + " " + m + "\n");
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void flushLog() {
        try {
            this.log.flush();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queueUpdate(@NotNull VirtualFile file2) {
        Deque<VirtualFile> deque = this.filesToResolve;
        synchronized (deque) {
            if (!(file2 instanceof VirtualFileWithId)) {
                return false;
            }
            int fileId = RefResolveServiceImpl.getAbsId(file2);
            this.countAndMarkUnresolved(file2, new LinkedHashSet<VirtualFile>(), true);
            boolean alreadyAdded = this.fileIsInQueue.set(fileId);
            if (!alreadyAdded) {
                this.filesToResolve.add(file2);
            }
            this.upToDate = false;
            this.wakeUpUnderLock();
            return !alreadyAdded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUp() {
        Deque<VirtualFile> deque = this.filesToResolve;
        synchronized (deque) {
            this.wakeUpUnderLock();
        }
    }

    private void wakeUpUnderLock() {
        this.filesToResolve.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForQueue() throws InterruptedException {
        Deque<VirtualFile> deque = this.filesToResolve;
        synchronized (deque) {
            this.filesToResolve.wait(1000L);
        }
    }

    private void startThread() {
        new Thread((Runnable)this, "Ref resolve service").start();
        this.upToDate = true;
        this.queueUnresolvedFilesSinceLastRestart();
    }

    private void queueUnresolvedFilesSinceLastRestart() {
        PersistentFS fs = PersistentFS.getInstance();
        int maxId = FSRecords.getMaxId();
        TIntArrayList list = new TIntArrayList();
        int id = this.fileIsResolved.nextClearBit(1);
        while (id >= 0 && id < maxId) {
            int nextSetBit = this.fileIsResolved.nextSetBit(id);
            int endOfRun = Math.min(maxId, nextSetBit == -1 ? maxId : nextSetBit);
            do {
                VirtualFile virtualFile;
                if (this.queueIfNeeded(virtualFile = fs.findFileById(id), this.myProject)) {
                    list.add(id);
                    continue;
                }
                this.fileIsResolved.set(id);
            } while (++id < endOfRun);
            id = this.fileIsResolved.nextClearBit(id + 1);
        }
        this.log("Initially added to resolve " + RefResolveServiceImpl.toVfString(list.toNativeArray()));
    }

    public void dispose() {
        this.myDisposed = true;
    }

    private void save() throws IOException {
        this.log("Saving resolved file bitset: " + this.fileIsResolved);
        this.fileIsResolved.writeTo(new File(this.getStorageDirectory(), "bitSet"));
        this.log("list.size = " + this.storage.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.myDisposed) {
            boolean isEmpty;
            Deque<VirtualFile> deque = this.filesToResolve;
            synchronized (deque) {
                isEmpty = this.filesToResolve.isEmpty();
            }
            if (this.enableVetoes.get() > 0 || isEmpty || !this.resolveProcess.isDone() || HeavyProcessLatch.INSTANCE.isRunning() || PsiDocumentManager.getInstance((Project)this.myProject).hasUncommitedDocuments()) {
                try {
                    this.waitForQueue();
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            final Set<VirtualFile> files = this.pollFilesToResolve();
            if (files.isEmpty()) continue;
            this.upToDate = false;
            this.myApplication.invokeLater(() -> {
                if (!this.resolveProcess.isDone()) {
                    return;
                }
                this.log("Started to resolve " + files.size() + " files");
                Task.Backgroundable backgroundable = new Task.Backgroundable(this.myProject, "Resolving files...", false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (!RefResolveServiceImpl.this.myApplication.isDisposed()) {
                            RefResolveServiceImpl.this.processBatch(indicator, files);
                        }
                    }
                };
                ProgressIndicatorBase indicator = files.size() > 1 ? new BackgroundableProcessIndicator(backgroundable) : new MyProgress();
                this.resolveProcess = ((ProgressManagerImpl)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(backgroundable, indicator, null);
            }, this.myProject.getDisposed());
            this.flushLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBatch(@NotNull ProgressIndicator indicator, @NotNull Set<VirtualFile> files) {
        assert (!this.myApplication.isDispatchThread());
        int resolvedInPreviousBatch = this.resolvedInPreviousBatch;
        int totalSize = files.size() + resolvedInPreviousBatch;
        ConcurrentIntObjectMap fileToForwardIds = ContainerUtil.createConcurrentIntObjectMap();
        Set<VirtualFile> toProcess = Collections.synchronizedSet(files);
        indicator.setIndeterminate(false);
        ProgressIndicatorUtils.forceWriteActionPriority(indicator, (Disposable)indicator);
        long start = System.currentTimeMillis();
        Processor processor2 = file2 -> {
            double fraction = 1.0 - (double)toProcess.size() * 1.0 / (double)totalSize;
            indicator.setFraction(fraction);
            try {
                if (!file2.isDirectory() && this.toResolve((VirtualFile)file2, this.myProject)) {
                    int fileId = RefResolveServiceImpl.getAbsId(file2);
                    int i2 = totalSize - toProcess.size();
                    indicator.setText(i2 + "/" + totalSize + ": Resolving " + file2.getPresentableUrl());
                    int[] forwardIds = this.processFile((VirtualFile)file2, fileId, indicator);
                    if (forwardIds == null) {
                        return false;
                    }
                    fileToForwardIds.put(fileId, (Object)forwardIds);
                }
                toProcess.remove(file2);
                return true;
            }
            catch (RuntimeException e) {
                indicator.checkCanceled();
                return true;
            }
        };
        boolean success = true;
        try {
            success = this.processFilesConcurrently(files, indicator, (Processor<VirtualFile>)processor2);
            this.resolvedInPreviousBatch = toProcess.isEmpty() ? 0 : totalSize - toProcess.size();
        }
        catch (Throwable throwable) {
            this.resolvedInPreviousBatch = toProcess.isEmpty() ? 0 : totalSize - toProcess.size();
            this.queue(toProcess, "re-added after fail. success=" + success);
            this.storeIds((ConcurrentIntObjectMap<int[]>)fileToForwardIds);
            long end = System.currentTimeMillis();
            this.log("Resolved batch of " + (totalSize - toProcess.size()) + " from " + totalSize + " files in " + (end - start) / 1000L + "sec. (Gap: " + this.storage.gap + ")");
            Deque<VirtualFile> deque = this.filesToResolve;
            synchronized (deque) {
                this.upToDate = this.filesToResolve.isEmpty();
                this.log("upToDate = " + this.upToDate);
                if (this.upToDate) {
                    for (RefResolveService.Listener listener2 : this.myListeners) {
                        listener2.allFilesResolved();
                    }
                }
            }
            throw throwable;
        }
        this.queue(toProcess, "re-added after fail. success=" + success);
        this.storeIds((ConcurrentIntObjectMap<int[]>)fileToForwardIds);
        long end = System.currentTimeMillis();
        this.log("Resolved batch of " + (totalSize - toProcess.size()) + " from " + totalSize + " files in " + (end - start) / 1000L + "sec. (Gap: " + this.storage.gap + ")");
        Deque<VirtualFile> deque = this.filesToResolve;
        synchronized (deque) {
            this.upToDate = this.filesToResolve.isEmpty();
            this.log("upToDate = " + this.upToDate);
            if (this.upToDate) {
                for (RefResolveService.Listener listener3 : this.myListeners) {
                    listener3.allFilesResolved();
                }
            }
        }
    }

    private boolean processFilesConcurrently(@NotNull Set<VirtualFile> files, @NotNull ProgressIndicator indicator, @NotNull Processor<VirtualFile> processor2) {
        ArrayList<VirtualFile> fileList = new ArrayList<VirtualFile>(files);
        int parallelism = CacheUpdateRunner.indexingThreadCount();
        Callable<Boolean> processFileFromSet = () -> {
            boolean[] result2 = new boolean[]{true};
            ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                block4: {
                    VirtualFile file2;
                    do {
                        ProgressManager.checkCanceled();
                        List list = fileList;
                        synchronized (list) {
                            file2 = fileList.isEmpty() ? null : (VirtualFile)fileList.remove(fileList.size() - 1);
                        }
                        if (file2 == null) break block4;
                    } while (processor2.process((Object)file2));
                    result2[0] = false;
                }
            }, indicator);
            return result2[0];
        };
        List futures = ContainerUtil.map(Collections.nCopies(parallelism, ""), s -> this.myApplication.executeOnPooledThread(processFileFromSet));
        List results = ContainerUtil.map((Collection)futures, future2 -> {
            try {
                return (Boolean)future2.get();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return false;
            }
        });
        return !ContainerUtil.exists((Iterable)results, result2 -> result2 != null && result2 == false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Set<VirtualFile> pollFilesToResolve() {
        LinkedHashSet<VirtualFile> set2;
        Deque<VirtualFile> deque = this.filesToResolve;
        synchronized (deque) {
            int queuedSize = this.filesToResolve.size();
            set2 = new LinkedHashSet<VirtualFile>(queuedSize);
            for (VirtualFile file2 : this.filesToResolve) {
                if (!this.fileIsInQueue.clear(RefResolveServiceImpl.getAbsId(file2))) continue;
                set2.add(file2);
            }
            this.filesToResolve.clear();
        }
        return this.countAndMarkUnresolved(set2, false);
    }

    private static int getAbsId(@NotNull VirtualFile file2) {
        return Math.abs(((VirtualFileWithId)file2).getId());
    }

    @NotNull
    private Set<VirtualFile> countAndMarkUnresolved(@NotNull Collection<VirtualFile> files, boolean inDbOnly) {
        LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
        for (VirtualFile file2 : files) {
            this.countAndMarkUnresolved(file2, result2, inDbOnly);
        }
        return result2;
    }

    private void countAndMarkUnresolved(@NotNull VirtualFile file2, final @NotNull Set<VirtualFile> result2, final boolean inDbOnly) {
        if (file2.isDirectory()) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file2) {
                    return RefResolveServiceImpl.this.doCountAndMarkUnresolved(file2, result2);
                }

                @Nullable
                public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file2) {
                    return inDbOnly ? ((NewVirtualFile)file2).iterInDbChildren() : null;
                }
            });
        } else {
            this.doCountAndMarkUnresolved(file2, result2);
        }
    }

    private boolean doCountAndMarkUnresolved(@NotNull VirtualFile file2, @NotNull Set<VirtualFile> result2) {
        if (file2.isDirectory()) {
            this.fileIsResolved.set(RefResolveServiceImpl.getAbsId(file2));
            return result2.add(file2);
        }
        if (this.toResolve(file2, this.myProject)) {
            result2.add(file2);
            this.fileIsResolved.clear(RefResolveServiceImpl.getAbsId(file2));
        }
        return true;
    }

    private void enable() {
        int vetoes;
        while ((vetoes = this.enableVetoes.get()) != 0 && !this.enableVetoes.compareAndSet(vetoes, vetoes - 1)) {
        }
        this.wakeUp();
    }

    private void disable() {
        this.enableVetoes.incrementAndGet();
        this.wakeUp();
    }

    private int[] processFile(@NotNull VirtualFile file2, int fileId, @NotNull ProgressIndicator indicator) {
        TIntHashSet forward;
        try {
            forward = this.calcForwardRefs(file2, indicator);
        }
        catch (ApplicationUtil.CannotRunReadActionException | IndexNotReadyException e) {
            return null;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            this.log(ExceptionUtil.getThrowableText((Throwable)e));
            this.flushLog();
            return null;
        }
        int[] forwardIds = forward.toArray();
        this.fileIsResolved.set(fileId);
        this.logf("  ---- " + file2.getPresentableUrl() + " processed. forwardIds: " + RefResolveServiceImpl.toVfString(forwardIds));
        for (RefResolveService.Listener listener2 : this.myListeners) {
            listener2.fileResolved(file2);
        }
        return forwardIds;
    }

    private void storeIds(@NotNull ConcurrentIntObjectMap<int[]> fileToForwardIds) {
        int forwardSize = 0;
        int backwardSize = 0;
        TIntObjectHashMap fileToBackwardIds = new TIntObjectHashMap(fileToForwardIds.size());
        for (ConcurrentIntObjectMap.IntEntry entry : fileToForwardIds.entries()) {
            int fileId = entry.getKey();
            int[] forwardIds = (int[])entry.getValue();
            forwardSize += forwardIds.length;
            for (int forwardId : forwardIds) {
                TIntArrayList backIds = (TIntArrayList)fileToBackwardIds.get(forwardId);
                if (backIds == null) {
                    backIds = new TIntArrayList();
                    fileToBackwardIds.put(forwardId, (Object)backIds);
                }
                backIds.add(fileId);
                ++backwardSize;
            }
        }
        this.log("backwardSize = " + backwardSize);
        this.log("forwardSize = " + forwardSize);
        this.log("fileToForwardIds.size() = " + fileToForwardIds.size());
        this.log("fileToBackwardIds.size() = " + fileToBackwardIds.size());
        assert (forwardSize == backwardSize);
        this.myApplication.runReadAction(() -> {
            if (!this.myApplication.isDisposed()) {
                fileToBackwardIds.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<TIntArrayList>(){

                    public boolean execute(int fileId, TIntArrayList backIds) {
                        RefResolveServiceImpl.this.storage.addAll(fileId, backIds.toNativeArray());
                        return true;
                    }
                });
            }
        });
    }

    @NotNull
    private TIntHashSet calcForwardRefs(@NotNull VirtualFile virtualFile, final @NotNull ProgressIndicator indicator) throws IndexNotReadyException, ApplicationUtil.CannotRunReadActionException {
        TIntHashSet forward = new TIntHashSet();
        final PsiFile psiFile = (PsiFile)ApplicationUtil.tryRunReadAction(() -> {
            if (this.myProject.isDisposed()) {
                throw new ProcessCanceledException();
            }
            if (this.fileCount.incrementAndGet() % 100 == 0) {
                PsiManager.getInstance((Project)this.myProject).dropResolveCaches();
                try {
                    this.storage.flush();
                    this.log.flush();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            return PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
        });
        int fileId = RefResolveServiceImpl.getAbsId(virtualFile);
        if (psiFile != null) {
            this.bytesSize.addAndGet(virtualFile.getLength());
            THashSet resolved = new THashSet();
            ApplicationUtil.tryRunReadAction(new Runnable((Set)resolved, forward){
                final /* synthetic */ Set val$resolved;
                final /* synthetic */ TIntHashSet val$forward;
                {
                    this.val$resolved = set2;
                    this.val$forward = tIntHashSet;
                }

                @Override
                public void run() {
                    indicator.checkCanceled();
                    if (psiFile instanceof PsiJavaFile) {
                        psiFile.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                                indicator.checkCanceled();
                                RefResolveServiceImpl.this.resolveReference((PsiReference)reference, val$resolved);
                                super.visitReferenceElement(reference);
                            }
                        });
                    } else {
                        psiFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                            public void visitElement(PsiElement element) {
                                for (PsiReference reference : element.getReferences()) {
                                    indicator.checkCanceled();
                                    RefResolveServiceImpl.this.resolveReference(reference, val$resolved);
                                }
                                super.visitElement(element);
                            }
                        });
                    }
                    indicator.checkCanceled();
                    for (PsiElement element : this.val$resolved) {
                        PsiFile file2 = element.getContainingFile();
                        RefResolveServiceImpl.addIdAndSuperClasses(file2, this.val$forward);
                    }
                }
            });
        }
        forward.remove(fileId);
        return forward;
    }

    private void resolveReference(@NotNull PsiReference reference, @NotNull Set<PsiElement> resolved) {
        PsiElement element = reference.resolve();
        if (element != null) {
            resolved.add(element);
        }
        this.refCount.incrementAndGet();
    }

    private static void addIdAndSuperClasses(PsiFile file2, @NotNull TIntHashSet forward) {
        if (file2 instanceof PsiJavaFile && file2.getName().equals("Object.class") && ((PsiJavaFile)file2).getPackageName().equals("java.lang")) {
            return;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file2);
        if (virtualFile instanceof VirtualFileWithId && forward.add(RefResolveServiceImpl.getAbsId(virtualFile)) && file2 instanceof PsiClassOwner) {
            for (PsiClass aClass : ((PsiClassOwner)file2).getClasses()) {
                for (PsiClass superClass : aClass.getSupers()) {
                    RefResolveServiceImpl.addIdAndSuperClasses(superClass.getContainingFile(), forward);
                }
            }
        }
    }

    @Nullable
    public int[] getBackwardIds(@NotNull VirtualFileWithId file2) {
        if (!this.isUpToDate()) {
            return null;
        }
        int fileId = RefResolveServiceImpl.getAbsId((VirtualFile)file2);
        return this.storage.get(fileId);
    }

    @NotNull
    public GlobalSearchScope restrictByBackwardIds(final @NotNull VirtualFile virtualFile, @NotNull GlobalSearchScope scope) {
        final int[] backIds = RefResolveService.getInstance((Project)this.myProject).getBackwardIds((VirtualFileWithId)virtualFile);
        if (backIds == null) {
            return scope;
        }
        String files = RefResolveServiceImpl.toVfString(backIds);
        String log = "Restricting scope of " + virtualFile.getName() + " to " + files;
        if (!log.equals(this.prevLog)) {
            this.log(log);
            this.flushLog();
            this.prevLog = log;
        }
        GlobalSearchScope restrictedByBackwardIds = new GlobalSearchScope(){

            public boolean contains(@NotNull VirtualFile file2) {
                if (!(file2 instanceof VirtualFileWithId) || file2.equals(virtualFile) || ArrayUtil.indexOf((int[])backIds, (int)RefResolveServiceImpl.getAbsId(file2)) != -1) {
                    return true;
                }
                return false & !RefResolveServiceImpl.this.myProjectFileIndex.isUnderSourceRootOfType(file2, SOURCE_ROOTS);
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                return 0;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                return true;
            }

            public boolean isSearchInLibraries() {
                return false;
            }
        };
        return scope.intersectWith(restrictedByBackwardIds);
    }

    public boolean queue(@NotNull Collection<VirtualFile> files, @NotNull Object reason) {
        if (files.isEmpty()) {
            return false;
        }
        boolean queued = false;
        ArrayList<VirtualFile> added = new ArrayList<VirtualFile>(files.size());
        for (VirtualFile file2 : files) {
            boolean wasAdded = this.queueIfNeeded(file2, this.myProject);
            if (wasAdded) {
                added.add(file2);
            }
            queued |= wasAdded;
        }
        if (queued) {
            this.log("Queued to resolve (from " + reason + "): " + RefResolveServiceImpl.toVfString(added));
            this.flushLog();
        }
        return queued;
    }

    public boolean isUpToDate() {
        return ENABLED && !this.myDisposed && this.upToDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize() {
        Deque<VirtualFile> deque = this.filesToResolve;
        synchronized (deque) {
            return this.filesToResolve.size();
        }
    }

    public void addListener(@NotNull Disposable parent, final @NotNull RefResolveService.Listener listener2) {
        this.myListeners.add(listener2);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                RefResolveServiceImpl.this.myListeners.remove(listener2);
            }
        });
    }

    private static class MyProgress
    extends ProgressIndicatorBase
    implements Disposable {
        private MyProgress() {
        }

        public void dispose() {
        }
    }
}

