/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.processor;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterScopeProcessor<T>
extends BaseScopeProcessor {
    protected final List<T> myResults;
    private PsiElement myCurrentDeclarationHolder;
    private final ElementFilter myFilter;
    private final PsiScopeProcessor myProcessor;

    public FilterScopeProcessor(@NotNull ElementFilter filter, @NotNull List<T> container) {
        this(filter, null, container);
    }

    public FilterScopeProcessor(@NotNull ElementFilter filter, @NotNull PsiScopeProcessor processor2) {
        this(filter, processor2, (List<T>)new SmartList());
    }

    public FilterScopeProcessor(@NotNull ElementFilter filter) {
        this(filter, null, (List<T>)new SmartList());
    }

    public FilterScopeProcessor(@NotNull ElementFilter filter, @Nullable PsiScopeProcessor processor2, @NotNull List<T> container) {
        this.myFilter = filter;
        this.myProcessor = processor2;
        this.myResults = container;
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (this.myProcessor != null) {
            this.myProcessor.handleEvent(event, associated);
        }
        if (event == PsiScopeProcessor.Event.SET_DECLARATION_HOLDER && associated instanceof PsiElement) {
            this.myCurrentDeclarationHolder = (PsiElement)associated;
        }
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (this.myFilter.isAcceptable((Object)element, this.myCurrentDeclarationHolder)) {
            if (this.myProcessor != null) {
                return this.myProcessor.execute(element, state);
            }
            this.add(element, (PsiSubstitutor)state.get(PsiSubstitutor.KEY));
        }
        return true;
    }

    protected void add(@NotNull PsiElement element, @NotNull PsiSubstitutor substitutor) {
        this.myResults.add(element);
    }

    public <K> K getHint(@NotNull Key<K> hintKey) {
        if (this.myProcessor != null) {
            return (K)this.myProcessor.getHint(hintKey);
        }
        return null;
    }

    @NotNull
    public List<T> getResults() {
        return this.myResults;
    }
}

